"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = initializeCommandService;
const CommandService_1 = require("@joplin/lib/services/CommandService");
const stateToWhenClauseContext_1 = require("@joplin/lib/services/commands/stateToWhenClauseContext");
const index_1 = require("@joplin/lib/commands/index");
function initializeCommandService(store, devMode) {
    CommandService_1.default.instance().initialize(store, devMode, stateToWhenClauseContext_1.default);
    for (const command of index_1.default) {
        CommandService_1.default.instance().registerDeclaration(command.declaration);
        CommandService_1.default.instance().registerRuntime(command.declaration.name, command.runtime());
    }
}
//# sourceMappingURL=initializeCommandService.js.map