"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = require("readline/promises");
const iterateStdin = function (prompt) {
    return __asyncGenerator(this, arguments, function* () {
        let nextLineListeners = [];
        const dispatchAllListeners = () => {
            const listeners = nextLineListeners;
            nextLineListeners = [];
            for (const listener of listeners) {
                listener();
            }
        };
        const rl = (0, promises_1.createInterface)({
            input: process.stdin,
            output: process.stdout,
        });
        rl.setPrompt(prompt);
        let buffer = [];
        rl.on('line', (line) => {
            buffer.push(line);
            dispatchAllListeners();
        });
        let done = false;
        rl.on('close', () => {
            done = true;
            dispatchAllListeners();
        });
        const readNextLines = () => {
            return new Promise(resolve => {
                if (done) {
                    resolve(null);
                }
                else if (buffer.length > 0) {
                    resolve(buffer.join('\n'));
                    buffer = [];
                }
                else {
                    nextLineListeners.push(() => {
                        resolve(buffer.join('\n'));
                        buffer = [];
                    });
                }
            });
        };
        while (!done) {
            rl.prompt();
            const lines = yield __await(readNextLines());
            yield yield __await(lines);
        }
    });
};
exports.default = iterateStdin;
//# sourceMappingURL=iterateStdin.js.map