
using ArrayInterface
using BlockBandedMatrices
using FillArrays
using Test

BB=BlockBandedMatrix(Ones(10,10),[1,2,3,4],[4,3,2,1],(1,0))
BB[BlockBandedMatrices.Block(1,1)].=[1 2 3 4]
BB[BlockBandedMatrices.Block(2,1)].=[5 6 7 8;9 10 11 12]
rowind,colind=ArrayInterface.findstructralnz(BB)
@test [BB[rowind[i],colind[i]] for i in 1:length(rowind)]==
    [1,5,9,2,6,10,3,7,11,4,8,12,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1]
@test ArrayInterface.isstructured(typeof(BB))
@test ArrayInterface.has_sparsestruct(typeof(BB))
@test ArrayInterface.fast_matrix_colors(typeof(BB))

dense=collect(Ones(8,8))
for i in 1:8
    dense[:,i].=[1,2,3,4,5,6,7,8]
end
BBB=BandedBlockBandedMatrix(dense, [4, 4] ,[4, 4], (1, 1), (1, 1))
rowind,colind=ArrayInterface.findstructralnz(BBB)
@test [BBB[rowind[i],colind[i]] for i in 1:length(rowind)]==
    [1,2,3,1,2,3,4,2,3,4,5,6,7,5,6,7,8,6,7,8,
     1,2,3,1,2,3,4,2,3,4,5,6,7,5,6,7,8,6,7,8]
@test ArrayInterface.isstructured(typeof(BBB))
@test ArrayInterface.has_sparsestruct(typeof(BBB))
@test ArrayInterface.fast_matrix_colors(typeof(BBB))

