# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: bedrock_agent_runtime
using AWS.Compat
using AWS.UUIDs

"""
    invoke_agent(agent_alias_id, agent_id, session_id)
    invoke_agent(agent_alias_id, agent_id, session_id, params::Dict{String,<:Any})

 The CLI doesn't support InvokeAgent.  Sends a prompt for the agent to process and respond
to. Note the following fields for the request:   To continue the same conversation with an
agent, use the same sessionId value in the request.   To activate trace enablement, turn
enableTrace to true. Trace enablement helps you follow the agent's reasoning process that
led it to the information it processed, the actions it took, and the final result it
yielded. For more information, see Trace enablement.   End a conversation by setting
endSession to true.   In the sessionState object, you can include attributes for the
session or prompt or, if you configured an action group to return control, results from
invocation of the action group.   The response is returned in the bytes field of the chunk
object.   The attribution object contains citations for parts of the response.   If you set
enableTrace to true in the request, you can trace the agent's steps and reasoning process
that led it to the response.   If the action predicted was configured to return control,
the response returns parameters for the action, elicited from the user, in the
returnControl field.   Errors are also surfaced in the response.

# Arguments
- `agent_alias_id`: The alias of the agent to use.
- `agent_id`: The unique identifier of the agent to use.
- `session_id`: The unique identifier of the session. Use the same value across requests to
  continue the same conversation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enableTrace"`: Specifies whether to turn on the trace or not to track the agent's
  reasoning process. For more information, see Trace enablement.
- `"endSession"`: Specifies whether to end the session with the agent or not.
- `"inputText"`: The prompt text to send the agent.  If you include
  returnControlInvocationResults in the sessionState field, the inputText field will be
  ignored.
- `"sessionState"`: Contains parameters that specify various attributes of the session. For
  more information, see Control session context.  If you include
  returnControlInvocationResults in the sessionState field, the inputText field will be
  ignored.
"""
function invoke_agent(
    agentAliasId, agentId, sessionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent_runtime(
        "POST",
        "/agents/$(agentId)/agentAliases/$(agentAliasId)/sessions/$(sessionId)/text";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_agent(
    agentAliasId,
    agentId,
    sessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent_runtime(
        "POST",
        "/agents/$(agentId)/agentAliases/$(agentAliasId)/sessions/$(sessionId)/text",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve(knowledge_base_id, retrieval_query)
    retrieve(knowledge_base_id, retrieval_query, params::Dict{String,<:Any})

Queries a knowledge base and retrieves information from it.

# Arguments
- `knowledge_base_id`: The unique identifier of the knowledge base to query.
- `retrieval_query`: Contains the query to send the knowledge base.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: If there are more results than can fit in the response, the response
  returns a nextToken. Use this token in the nextToken field of another request to retrieve
  the next batch of results.
- `"retrievalConfiguration"`: Contains configurations for the knowledge base query and
  retrieval process. For more information, see Query configurations.
"""
function retrieve(
    knowledgeBaseId, retrievalQuery; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent_runtime(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/retrieve",
        Dict{String,Any}("retrievalQuery" => retrievalQuery);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve(
    knowledgeBaseId,
    retrievalQuery,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent_runtime(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/retrieve",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("retrievalQuery" => retrievalQuery), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve_and_generate(input)
    retrieve_and_generate(input, params::Dict{String,<:Any})

Queries a knowledge base and generates responses based on the retrieved results. The
response only cites sources that are relevant to the query.

# Arguments
- `input`: Contains the query to be made to the knowledge base.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"retrieveAndGenerateConfiguration"`: Contains configurations for the knowledge base
  query and retrieval process. For more information, see Query configurations.
- `"sessionConfiguration"`: Contains details about the session with the knowledge base.
- `"sessionId"`: The unique identifier of the session. Reuse the same value to continue the
  same session with the knowledge base.
"""
function retrieve_and_generate(input; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent_runtime(
        "POST",
        "/retrieveAndGenerate",
        Dict{String,Any}("input" => input);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve_and_generate(
    input, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent_runtime(
        "POST",
        "/retrieveAndGenerate",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("input" => input), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
