# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: cloudwatch_events
using AWS.Compat
using AWS.UUIDs

"""
    activate_event_source(name)
    activate_event_source(name, params::Dict{String,<:Any})

Activates a partner event source that has been deactivated. Once activated, your matching
event bus will start receiving events from the event source.

# Arguments
- `name`: The name of the partner event source to activate.

"""
function activate_event_source(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ActivateEventSource",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_event_source(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ActivateEventSource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_replay(replay_name)
    cancel_replay(replay_name, params::Dict{String,<:Any})

Cancels the specified replay.

# Arguments
- `replay_name`: The name of the replay to cancel.

"""
function cancel_replay(ReplayName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "CancelReplay",
        Dict{String,Any}("ReplayName" => ReplayName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_replay(
    ReplayName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CancelReplay",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ReplayName" => ReplayName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_api_destination(connection_arn, http_method, invocation_endpoint, name)
    create_api_destination(connection_arn, http_method, invocation_endpoint, name, params::Dict{String,<:Any})

Creates an API destination, which is an HTTP invocation endpoint configured as a target for
events.

# Arguments
- `connection_arn`: The ARN of the connection to use for the API destination. The
  destination endpoint must support the authorization type specified for the connection.
- `http_method`: The method to use for the request to the HTTP invocation endpoint.
- `invocation_endpoint`: The URL to the HTTP invocation endpoint for the API destination.
- `name`: The name for the API destination to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the API destination to create.
- `"InvocationRateLimitPerSecond"`: The maximum number of requests per second to send to
  the HTTP invocation endpoint.
"""
function create_api_destination(
    ConnectionArn,
    HttpMethod,
    InvocationEndpoint,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreateApiDestination",
        Dict{String,Any}(
            "ConnectionArn" => ConnectionArn,
            "HttpMethod" => HttpMethod,
            "InvocationEndpoint" => InvocationEndpoint,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_api_destination(
    ConnectionArn,
    HttpMethod,
    InvocationEndpoint,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreateApiDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectionArn" => ConnectionArn,
                    "HttpMethod" => HttpMethod,
                    "InvocationEndpoint" => InvocationEndpoint,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_archive(archive_name, event_source_arn)
    create_archive(archive_name, event_source_arn, params::Dict{String,<:Any})

Creates an archive of events with the specified settings. When you create an archive,
incoming events might not immediately start being sent to the archive. Allow a short period
of time for changes to take effect. If you do not specify a pattern to filter events sent
to the archive, all events are sent to the archive except replayed events. Replayed events
are not sent to an archive.

# Arguments
- `archive_name`: The name for the archive to create.
- `event_source_arn`: The ARN of the event bus that sends events to the archive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the archive.
- `"EventPattern"`: An event pattern to use to filter events sent to the archive.
- `"RetentionDays"`: The number of days to retain events for. Default value is 0. If set to
  0, events are retained indefinitely
"""
function create_archive(
    ArchiveName, EventSourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "CreateArchive",
        Dict{String,Any}("ArchiveName" => ArchiveName, "EventSourceArn" => EventSourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_archive(
    ArchiveName,
    EventSourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreateArchive",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ArchiveName" => ArchiveName, "EventSourceArn" => EventSourceArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connection(auth_parameters, authorization_type, name)
    create_connection(auth_parameters, authorization_type, name, params::Dict{String,<:Any})

Creates a connection. A connection defines the authorization type and credentials to use
for authorization with an API destination HTTP endpoint.

# Arguments
- `auth_parameters`: A CreateConnectionAuthRequestParameters object that contains the
  authorization parameters to use to authorize with the endpoint.
- `authorization_type`: The type of authorization to use for the connection.
- `name`: The name for the connection to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the connection to create.
"""
function create_connection(
    AuthParameters,
    AuthorizationType,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreateConnection",
        Dict{String,Any}(
            "AuthParameters" => AuthParameters,
            "AuthorizationType" => AuthorizationType,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connection(
    AuthParameters,
    AuthorizationType,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreateConnection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthParameters" => AuthParameters,
                    "AuthorizationType" => AuthorizationType,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_bus(name)
    create_event_bus(name, params::Dict{String,<:Any})

Creates a new event bus within your account. This can be a custom event bus which you can
use to receive events from your custom applications and services, or it can be a partner
event bus which can be matched to a partner event source.

# Arguments
- `name`: The name of the new event bus.  Event bus names cannot contain the / character.
  You can't use the name default for a custom event bus, as this name is already used for
  your account's default event bus. If this is a partner event bus, the name must exactly
  match the name of the partner event source that this event bus is matched to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventSourceName"`: If you are creating a partner event bus, this specifies the partner
  event source that the new event bus will be matched with.
- `"Tags"`: Tags to associate with the event bus.
"""
function create_event_bus(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "CreateEventBus",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_bus(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "CreateEventBus",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_partner_event_source(account, name)
    create_partner_event_source(account, name, params::Dict{String,<:Any})

Called by an SaaS partner to create a partner event source. This operation is not used by
Amazon Web Services customers. Each partner event source can be used by one Amazon Web
Services account to create a matching partner event bus in that Amazon Web Services
account. A SaaS partner must create one partner event source for each Amazon Web Services
account that wants to receive those event types.  A partner event source creates events
based on resources within the SaaS partner's service or application. An Amazon Web Services
account that creates a partner event bus that matches the partner event source can use that
event bus to receive events from the partner, and then process them using Amazon Web
Services Events rules and targets. Partner event source names follow this format:
partner_name/event_namespace/event_name    partner_name is determined during partner
registration and identifies the partner to Amazon Web Services customers. event_namespace
is determined by the partner and is a way for the partner to categorize their events.
event_name is determined by the partner, and should uniquely identify an event-generating
resource within the partner system. The combination of event_namespace and event_name
should help Amazon Web Services customers decide whether to create an event bus to receive
these events.

# Arguments
- `account`: The Amazon Web Services account ID that is permitted to create a matching
  partner event bus for this partner event source.
- `name`: The name of the partner event source. This name must be unique and must be in the
  format  partner_name/event_namespace/event_name . The Amazon Web Services account that
  wants to use this partner event source must create a partner event bus with a name that
  matches the name of the partner event source.

"""
function create_partner_event_source(
    Account, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "CreatePartnerEventSource",
        Dict{String,Any}("Account" => Account, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_partner_event_source(
    Account,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "CreatePartnerEventSource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Account" => Account, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_event_source(name)
    deactivate_event_source(name, params::Dict{String,<:Any})

You can use this operation to temporarily stop receiving events from the specified partner
event source. The matching event bus is not deleted.  When you deactivate a partner event
source, the source goes into PENDING state. If it remains in PENDING state for more than
two weeks, it is deleted. To activate a deactivated partner event source, use
ActivateEventSource.

# Arguments
- `name`: The name of the partner event source to deactivate.

"""
function deactivate_event_source(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeactivateEventSource",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_event_source(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeactivateEventSource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deauthorize_connection(name)
    deauthorize_connection(name, params::Dict{String,<:Any})

Removes all authorization parameters from the connection. This lets you remove the secret
from the connection so you can reuse it without having to create a new connection.

# Arguments
- `name`: The name of the connection to remove authorization from.

"""
function deauthorize_connection(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeauthorizeConnection",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deauthorize_connection(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeauthorizeConnection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_api_destination(name)
    delete_api_destination(name, params::Dict{String,<:Any})

Deletes the specified API destination.

# Arguments
- `name`: The name of the destination to delete.

"""
function delete_api_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeleteApiDestination",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_api_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeleteApiDestination",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_archive(archive_name)
    delete_archive(archive_name, params::Dict{String,<:Any})

Deletes the specified archive.

# Arguments
- `archive_name`: The name of the archive to delete.

"""
function delete_archive(ArchiveName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeleteArchive",
        Dict{String,Any}("ArchiveName" => ArchiveName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_archive(
    ArchiveName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "DeleteArchive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ArchiveName" => ArchiveName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connection(name)
    delete_connection(name, params::Dict{String,<:Any})

Deletes a connection.

# Arguments
- `name`: The name of the connection to delete.

"""
function delete_connection(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeleteConnection",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connection(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeleteConnection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_bus(name)
    delete_event_bus(name, params::Dict{String,<:Any})

Deletes the specified custom event bus or partner event bus. All rules associated with this
event bus need to be deleted. You can't delete your account's default event bus.

# Arguments
- `name`: The name of the event bus to delete.

"""
function delete_event_bus(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeleteEventBus",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_bus(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeleteEventBus",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_partner_event_source(account, name)
    delete_partner_event_source(account, name, params::Dict{String,<:Any})

This operation is used by SaaS partners to delete a partner event source. This operation is
not used by Amazon Web Services customers. When you delete an event source, the status of
the corresponding partner event bus in the Amazon Web Services customer account becomes
DELETED.

# Arguments
- `account`: The Amazon Web Services account ID of the Amazon Web Services customer that
  the event source was created for.
- `name`: The name of the event source to delete.

"""
function delete_partner_event_source(
    Account, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeletePartnerEventSource",
        Dict{String,Any}("Account" => Account, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_partner_event_source(
    Account,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "DeletePartnerEventSource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Account" => Account, "Name" => Name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rule(name)
    delete_rule(name, params::Dict{String,<:Any})

Deletes the specified rule. Before you can delete the rule, you must remove all targets,
using RemoveTargets. When you delete a rule, incoming events might continue to match to the
deleted rule. Allow a short period of time for changes to take effect. If you call delete
rule multiple times for the same rule, all calls will succeed. When you call delete rule
for a non-existent custom eventbus, ResourceNotFoundException is returned. Managed rules
are rules created and managed by another Amazon Web Services service on your behalf. These
rules are created by those other Amazon Web Services services to support functionality in
those services. You can delete these rules using the Force option, but you should do so
only if you are sure the other service is not still using that rule.

# Arguments
- `name`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
- `"Force"`: If this is a managed rule, created by an Amazon Web Services service on your
  behalf, you must specify Force as True to delete the rule. This parameter is ignored for
  rules that are not managed rules. You can check whether a rule is a managed rule by using
  DescribeRule or ListRules and checking the ManagedBy field of the response.
"""
function delete_rule(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DeleteRule",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rule(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DeleteRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_api_destination(name)
    describe_api_destination(name, params::Dict{String,<:Any})

Retrieves details about an API destination.

# Arguments
- `name`: The name of the API destination to retrieve.

"""
function describe_api_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeApiDestination",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_api_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribeApiDestination",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_archive(archive_name)
    describe_archive(archive_name, params::Dict{String,<:Any})

Retrieves details about an archive.

# Arguments
- `archive_name`: The name of the archive to retrieve.

"""
function describe_archive(ArchiveName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeArchive",
        Dict{String,Any}("ArchiveName" => ArchiveName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_archive(
    ArchiveName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "DescribeArchive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ArchiveName" => ArchiveName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connection(name)
    describe_connection(name, params::Dict{String,<:Any})

Retrieves details about a connection.

# Arguments
- `name`: The name of the connection to retrieve.

"""
function describe_connection(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeConnection",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_connection(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribeConnection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_bus()
    describe_event_bus(params::Dict{String,<:Any})

Displays details about an event bus in your account. This can include the external Amazon
Web Services accounts that are permitted to write events to your default event bus, and the
associated policy. For custom event buses and partner event buses, it displays the name,
ARN, policy, state, and creation time.  To enable your account to receive events from other
accounts on its default event bus, use PutPermission. For more information about partner
event buses, see CreateEventBus.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The name or ARN of the event bus to show details for. If you omit this, the
  default event bus is displayed.
"""
function describe_event_bus(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeEventBus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_bus(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribeEventBus", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_event_source(name)
    describe_event_source(name, params::Dict{String,<:Any})

This operation lists details about a partner event source that is shared with your account.

# Arguments
- `name`: The name of the partner event source to display the details of.

"""
function describe_event_source(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeEventSource",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_event_source(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribeEventSource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_partner_event_source(name)
    describe_partner_event_source(name, params::Dict{String,<:Any})

An SaaS partner can use this operation to list details about a partner event source that
they have created. Amazon Web Services customers do not use this operation. Instead, Amazon
Web Services customers can use DescribeEventSource to see details about a partner event
source that is shared with them.

# Arguments
- `name`: The name of the event source to display.

"""
function describe_partner_event_source(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribePartnerEventSource",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_partner_event_source(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribePartnerEventSource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_replay(replay_name)
    describe_replay(replay_name, params::Dict{String,<:Any})

Retrieves details about a replay. Use DescribeReplay to determine the progress of a running
replay. A replay processes events to replay based on the time in the event, and replays
them using 1 minute intervals. If you use StartReplay and specify an EventStartTime and an
EventEndTime that covers a 20 minute time range, the events are replayed from the first
minute of that 20 minute range first. Then the events from the second minute are replayed.
You can use DescribeReplay to determine the progress of a replay. The value returned for
EventLastReplayedTime indicates the time within the specified time range associated with
the last event replayed.

# Arguments
- `replay_name`: The name of the replay to retrieve.

"""
function describe_replay(ReplayName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeReplay",
        Dict{String,Any}("ReplayName" => ReplayName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_replay(
    ReplayName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "DescribeReplay",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ReplayName" => ReplayName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_rule(name)
    describe_rule(name, params::Dict{String,<:Any})

Describes the specified rule. DescribeRule does not list the targets of a rule. To see the
targets associated with a rule, use ListTargetsByRule.

# Arguments
- `name`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
"""
function describe_rule(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DescribeRule",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_rule(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DescribeRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_rule(name)
    disable_rule(name, params::Dict{String,<:Any})

Disables the specified rule. A disabled rule won't match any events, and won't self-trigger
if it has a schedule expression. When you disable a rule, incoming events might continue to
match to the disabled rule. Allow a short period of time for changes to take effect.

# Arguments
- `name`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
"""
function disable_rule(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "DisableRule",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_rule(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "DisableRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_rule(name)
    enable_rule(name, params::Dict{String,<:Any})

Enables the specified rule. If the rule does not exist, the operation fails. When you
enable a rule, incoming events might not immediately start matching to a newly enabled
rule. Allow a short period of time for changes to take effect.

# Arguments
- `name`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
"""
function enable_rule(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "EnableRule",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_rule(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "EnableRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_api_destinations()
    list_api_destinations(params::Dict{String,<:Any})

Retrieves a list of API destination in the account in the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionArn"`: The ARN of the connection specified for the API destination.
- `"Limit"`: The maximum number of API destinations to include in the response.
- `"NamePrefix"`: A name prefix to filter results returned. Only API destinations with a
  name that starts with the prefix are returned.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_api_destinations(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListApiDestinations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_api_destinations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListApiDestinations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_archives()
    list_archives(params::Dict{String,<:Any})

Lists your archives. You can either list all the archives or you can provide a prefix to
match to the archive names. Filter parameters are exclusive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventSourceArn"`: The ARN of the event source associated with the archive.
- `"Limit"`: The maximum number of results to return.
- `"NamePrefix"`: A name prefix to filter the archives returned. Only archives with name
  that match the prefix are returned.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
- `"State"`: The state of the archive.
"""
function list_archives(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListArchives"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_archives(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListArchives", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_connections()
    list_connections(params::Dict{String,<:Any})

Retrieves a list of connections from the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionState"`: The state of the connection.
- `"Limit"`: The maximum number of connections to return.
- `"NamePrefix"`: A name prefix to filter results returned. Only connections with a name
  that starts with the prefix are returned.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_connections(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListConnections"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListConnections", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_event_buses()
    list_event_buses(params::Dict{String,<:Any})

Lists all the event buses in your account, including the default event bus, custom event
buses, and partner event buses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifying this limits the number of results returned by this operation. The
  operation also returns a NextToken which you can use in a subsequent operation to retrieve
  the next set of results.
- `"NamePrefix"`: Specifying this limits the results to only those event buses with names
  that start with the specified prefix.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_event_buses(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListEventBuses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_event_buses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListEventBuses", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_event_sources()
    list_event_sources(params::Dict{String,<:Any})

You can use this to see all the partner event sources that have been shared with your
Amazon Web Services account. For more information about partner event sources, see
CreateEventBus.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifying this limits the number of results returned by this operation. The
  operation also returns a NextToken which you can use in a subsequent operation to retrieve
  the next set of results.
- `"NamePrefix"`: Specifying this limits the results to only those partner event sources
  with names that start with the specified prefix.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_event_sources(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListEventSources"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_event_sources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListEventSources", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_partner_event_source_accounts(event_source_name)
    list_partner_event_source_accounts(event_source_name, params::Dict{String,<:Any})

An SaaS partner can use this operation to display the Amazon Web Services account ID that a
particular partner event source name is associated with. This operation is not used by
Amazon Web Services customers.

# Arguments
- `event_source_name`: The name of the partner event source to display account information
  about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifying this limits the number of results returned by this operation. The
  operation also returns a NextToken which you can use in a subsequent operation to retrieve
  the next set of results.
- `"NextToken"`: The token returned by a previous call to this operation. Specifying this
  retrieves the next set of results.
"""
function list_partner_event_source_accounts(
    EventSourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListPartnerEventSourceAccounts",
        Dict{String,Any}("EventSourceName" => EventSourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_partner_event_source_accounts(
    EventSourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "ListPartnerEventSourceAccounts",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("EventSourceName" => EventSourceName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_partner_event_sources(name_prefix)
    list_partner_event_sources(name_prefix, params::Dict{String,<:Any})

An SaaS partner can use this operation to list all the partner event source names that they
have created. This operation is not used by Amazon Web Services customers.

# Arguments
- `name_prefix`: If you specify this, the results are limited to only those partner event
  sources that start with the string you specify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: pecifying this limits the number of results returned by this operation. The
  operation also returns a NextToken which you can use in a subsequent operation to retrieve
  the next set of results.
- `"NextToken"`: The token returned by a previous call to this operation. Specifying this
  retrieves the next set of results.
"""
function list_partner_event_sources(
    NamePrefix; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListPartnerEventSources",
        Dict{String,Any}("NamePrefix" => NamePrefix);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_partner_event_sources(
    NamePrefix,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "ListPartnerEventSources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("NamePrefix" => NamePrefix), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_replays()
    list_replays(params::Dict{String,<:Any})

Lists your replays. You can either list all the replays or you can provide a prefix to
match to the replay names. Filter parameters are exclusive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventSourceArn"`: The ARN of the archive from which the events are replayed.
- `"Limit"`: The maximum number of replays to retrieve.
- `"NamePrefix"`: A name prefix to filter the replays returned. Only replays with name that
  match the prefix are returned.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
- `"State"`: The state of the replay.
"""
function list_replays(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListReplays"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_replays(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListReplays", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_rule_names_by_target(target_arn)
    list_rule_names_by_target(target_arn, params::Dict{String,<:Any})

Lists the rules for the specified target. You can see which of the rules in Amazon
EventBridge can invoke a specific target in your account.

# Arguments
- `target_arn`: The Amazon Resource Name (ARN) of the target resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus to list rules for. If you omit this,
  the default event bus is used.
- `"Limit"`: The maximum number of results to return.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_rule_names_by_target(
    TargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListRuleNamesByTarget",
        Dict{String,Any}("TargetArn" => TargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rule_names_by_target(
    TargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "ListRuleNamesByTarget",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TargetArn" => TargetArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rules()
    list_rules(params::Dict{String,<:Any})

Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a
prefix to match to the rule names. ListRules does not list the targets of a rule. To see
the targets associated with a rule, use ListTargetsByRule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus to list the rules for. If you omit
  this, the default event bus is used.
- `"Limit"`: The maximum number of results to return.
- `"NamePrefix"`: The prefix matching the rule name.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListRules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Displays the tags associated with an EventBridge resource. In EventBridge, rules and event
buses can be tagged.

# Arguments
- `resource_arn`: The ARN of the EventBridge resource for which you want to view tags.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets_by_rule(rule)
    list_targets_by_rule(rule, params::Dict{String,<:Any})

Lists the targets assigned to the specified rule.

# Arguments
- `rule`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
- `"Limit"`: The maximum number of results to return.
- `"NextToken"`: The token returned by a previous call to retrieve the next set of results.
"""
function list_targets_by_rule(Rule; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "ListTargetsByRule",
        Dict{String,Any}("Rule" => Rule);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_targets_by_rule(
    Rule, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "ListTargetsByRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Rule" => Rule), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_events(entries)
    put_events(entries, params::Dict{String,<:Any})

Sends custom events to Amazon EventBridge so that they can be matched to rules.

# Arguments
- `entries`: The entry that defines an event in your system. You can specify several
  parameters for the entry such as the source and type of the event, resources associated
  with the event, and so on.

"""
function put_events(Entries; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "PutEvents",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_events(
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "PutEvents",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_partner_events(entries)
    put_partner_events(entries, params::Dict{String,<:Any})

This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web
Services customers do not use this operation.

# Arguments
- `entries`: The list of events to write to the event bus.

"""
function put_partner_events(Entries; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "PutPartnerEvents",
        Dict{String,Any}("Entries" => Entries);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_partner_events(
    Entries,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "PutPartnerEvents",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Entries" => Entries), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_permission()
    put_permission(params::Dict{String,<:Any})

Running PutPermission permits the specified Amazon Web Services account or Amazon Web
Services organization to put events to the specified event bus. Amazon EventBridge
(CloudWatch Events) rules in your account are triggered by these events arriving to an
event bus in your account.  For another account to send events to your account, that
external account must have an EventBridge rule with your account's event bus as a target.
To enable multiple Amazon Web Services accounts to put events to your event bus, run
PutPermission once for each of these accounts. Or, if all the accounts are members of the
same Amazon Web Services organization, you can run PutPermission once specifying Principal
as \"*\" and specifying the Amazon Web Services organization ID in Condition, to grant
permissions to all accounts in that organization. If you grant permissions using an
organization, then accounts in that organization must specify a RoleArn with proper
permissions when they use PutTarget to add your account's event bus as a target. For more
information, see Sending and Receiving Events Between Amazon Web Services Accounts in the
Amazon EventBridge User Guide. The permission policy on the event bus cannot exceed 10 KB
in size.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Action"`: The action that you are enabling the other account to perform.
- `"Condition"`: This parameter enables you to limit the permission to accounts that
  fulfill a certain condition, such as being a member of a certain Amazon Web Services
  organization. For more information about Amazon Web Services Organizations, see What Is
  Amazon Web Services Organizations in the Amazon Web Services Organizations User Guide. If
  you specify Condition with an Amazon Web Services organization ID, and specify \"*\" as the
  value for Principal, you grant permission to all the accounts in the named organization.
  The Condition is a JSON string which must contain Type, Key, and Value fields.
- `"EventBusName"`: The name of the event bus associated with the rule. If you omit this,
  the default event bus is used.
- `"Policy"`: A JSON string that describes the permission policy statement. You can include
  a Policy parameter in the request instead of using the StatementId, Action, Principal, or
  Condition parameters.
- `"Principal"`: The 12-digit Amazon Web Services account ID that you are permitting to put
  events to your default event bus. Specify \"*\" to permit any account to put events to your
  default event bus. If you specify \"*\" without specifying Condition, avoid creating rules
  that may match undesirable events. To create more secure rules, make sure that the event
  pattern for each rule contains an account field with a specific account ID from which to
  receive events. Rules with an account field do not match any events sent from other
  accounts.
- `"StatementId"`: An identifier string for the external account that you are granting
  permissions to. If you later want to revoke the permission for this external account,
  specify this StatementId when you run RemovePermission.
"""
function put_permission(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "PutPermission"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function put_permission(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "PutPermission", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_rule(name)
    put_rule(name, params::Dict{String,<:Any})

Creates or updates the specified rule. Rules are enabled by default, or based on value of
the state. You can disable a rule using DisableRule. A single rule watches for events from
a single event bus. Events generated by Amazon Web Services services go to your account's
default event bus. Events generated by SaaS partner services or applications go to the
matching partner event bus. If you have custom applications or services, you can specify
whether their events go to your default event bus or a custom event bus that you have
created. For more information, see CreateEventBus. If you are updating an existing rule,
the rule is replaced with what you specify in this PutRule command. If you omit arguments
in PutRule, the old values for those arguments are not kept. Instead, they are replaced
with null values. When you create or update a rule, incoming events might not immediately
start matching to new or updated rules. Allow a short period of time for changes to take
effect. A rule must contain at least an EventPattern or ScheduleExpression. Rules with
EventPatterns are triggered when a matching event is observed. Rules with
ScheduleExpressions self-trigger based on the given schedule. A rule can have both an
EventPattern and a ScheduleExpression, in which case the rule triggers on matching events
as well as on a schedule. When you initially create a rule, you can optionally assign one
or more tags to the rule. Tags can help you organize and categorize your resources. You can
also use them to scope user permissions, by granting a user permission to access or change
only rules with certain tag values. To use the PutRule operation and assign tags, you must
have both the events:PutRule and events:TagResource permissions. If you are updating an
existing rule, any tags you specify in the PutRule operation are ignored. To update the
tags of an existing rule, use TagResource and UntagResource. Most services in Amazon Web
Services treat : or / as the same character in Amazon Resource Names (ARNs). However,
EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN
characters when creating event patterns so that they match the ARN syntax in the event you
want to match. In EventBridge, it is possible to create rules that lead to infinite loops,
where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed
on an S3 bucket, and trigger software to change them to the desired state. If the rule is
not written carefully, the subsequent change to the ACLs fires the rule again, creating an
infinite loop. To prevent this, write the rules so that the triggered actions do not
re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a
bad state, instead of after any change.  An infinite loop can quickly cause higher than
expected charges. We recommend that you use budgeting, which alerts you when charges exceed
your specified limit. For more information, see Managing Your Costs with Budgets.

# Arguments
- `name`: The name of the rule that you are creating or updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the rule.
- `"EventBusName"`: The name or ARN of the event bus to associate with this rule. If you
  omit this, the default event bus is used.
- `"EventPattern"`: The event pattern. For more information, see Events and Event Patterns
  in the Amazon EventBridge User Guide.
- `"RoleArn"`: The Amazon Resource Name (ARN) of the IAM role associated with the rule. If
  you're setting an event bus in another account as the target and that account granted
  permission to your account through an organization instead of directly by the account ID,
  you must specify a RoleArn with proper permissions in the Target structure, instead of here
  in this parameter.
- `"ScheduleExpression"`: The scheduling expression. For example, \"cron(0 20 * * ? *)\" or
  \"rate(5 minutes)\".
- `"State"`: Indicates whether the rule is enabled or disabled.
- `"Tags"`: The list of key-value pairs to associate with the rule.
"""
function put_rule(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "PutRule",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_rule(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "PutRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_targets(rule, targets)
    put_targets(rule, targets, params::Dict{String,<:Any})

Adds the specified targets to the specified rule, or updates the targets if they are
already associated with the rule. Targets are the resources that are invoked when a rule is
triggered. You can configure the following as targets for Events:    API destination
Amazon API Gateway REST API endpoints   API Gateway   Batch job queue   CloudWatch Logs
group   CodeBuild project   CodePipeline   Amazon EC2 CreateSnapshot API call   Amazon EC2
RebootInstances API call   Amazon EC2 StopInstances API call   Amazon EC2
TerminateInstances API call   Amazon ECS tasks   Event bus in a different Amazon Web
Services account or Region. You can use an event bus in the US East (N. Virginia)
us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target
for a rule.   Firehose delivery stream (Kinesis Data Firehose)   Inspector assessment
template (Amazon Inspector)   Kinesis stream (Kinesis Data Stream)   Lambda function
Redshift clusters (Data API statement execution)   Amazon SNS topic   Amazon SQS queues
(includes FIFO queues   SSM Automation   SSM OpsItem   SSM Run Command   Step Functions
state machines   Creating rules with built-in targets is supported only in the Amazon Web
Services Management Console. The built-in targets are EC2 CreateSnapshot API call, EC2
RebootInstances API call, EC2 StopInstances API call, and EC2 TerminateInstances API call.
For some target types, PutTargets provides target-specific parameters. If the target is a
Kinesis data stream, you can optionally specify which shard the event goes to by using the
KinesisParameters argument. To invoke a command on multiple EC2 instances with one rule,
you can use the RunCommandParameters field. To be able to make API calls against the
resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda
and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances,
Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge
relies on IAM roles that you specify in the RoleARN argument in PutTargets. For more
information, see Authentication and Access Control in the Amazon EventBridge User Guide. If
another Amazon Web Services account is in the same region and has granted you permission
(using PutPermission), you can send events to that account. Set that account's event bus as
a target of the rules in your account. To send the matched events to the other account,
specify that account's event bus as the Arn value when you run PutTargets. If your account
sends events to another account, your account is charged for each sent event. Each event
sent to another account is charged as a custom event. The account receiving the event is
not charged. For more information, see Amazon EventBridge Pricing.   Input, InputPath, and
InputTransformer are not available with PutTarget if the target is an event bus of a
different Amazon Web Services account.  If you are setting the event bus of another account
as the target, and that account granted permission to your account through an organization
instead of directly by the account ID, then you must specify a RoleArn with proper
permissions in the Target structure. For more information, see Sending and Receiving Events
Between Amazon Web Services Accounts in the Amazon EventBridge User Guide. For more
information about enabling cross-account events, see PutPermission.  Input, InputPath, and
InputTransformer are mutually exclusive and optional parameters of a target. When a rule is
triggered due to a matched event:   If none of the following arguments are specified for a
target, then the entire event is passed to the target in JSON format (unless the target is
Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed
to the target).   If Input is specified in the form of valid JSON, then the matched event
is overridden with this constant.   If InputPath is specified in the form of JSONPath (for
example, .detail), then only the part of the event specified in the path is passed to the
target (for example, only the detail part of the event is passed).   If InputTransformer is
specified, then one or more specified JSONPaths are extracted from the event and used as
values in a template that you specify as the input to the target.   When you specify
InputPath or InputTransformer, you must use JSON dot notation, not bracket notation. When
you add targets to a rule and the associated rule triggers soon after, new or updated
targets might not be immediately invoked. Allow a short period of time for changes to take
effect. This action can partially fail if too many requests are made at the same time. If
that happens, FailedEntryCount is non-zero in the response and each entry in FailedEntries
provides the ID of the failed target and the error code.

# Arguments
- `rule`: The name of the rule.
- `targets`: The targets to update or add to the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
"""
function put_targets(Rule, Targets; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "PutTargets",
        Dict{String,Any}("Rule" => Rule, "Targets" => Targets);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_targets(
    Rule,
    Targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "PutTargets",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Rule" => Rule, "Targets" => Targets), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_permission()
    remove_permission(params::Dict{String,<:Any})

Revokes the permission of another Amazon Web Services account to be able to put events to
the specified event bus. Specify the account to revoke by the StatementId value that you
associated with the account when you granted it permission with PutPermission. You can find
the StatementId by using DescribeEventBus.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name of the event bus to revoke permissions for. If you omit this,
  the default event bus is used.
- `"RemoveAllPermissions"`: Specifies whether to remove all permissions.
- `"StatementId"`: The statement ID corresponding to the account that is no longer allowed
  to put events to the default event bus.
"""
function remove_permission(; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "RemovePermission"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function remove_permission(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "RemovePermission", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    remove_targets(ids, rule)
    remove_targets(ids, rule, params::Dict{String,<:Any})

Removes the specified targets from the specified rule. When the rule is triggered, those
targets are no longer be invoked. When you remove a target, when the associated rule
triggers, removed targets might continue to be invoked. Allow a short period of time for
changes to take effect. This action can partially fail if too many requests are made at the
same time. If that happens, FailedEntryCount is non-zero in the response and each entry in
FailedEntries provides the ID of the failed target and the error code.

# Arguments
- `ids`: The IDs of the targets to remove from the rule.
- `rule`: The name of the rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventBusName"`: The name or ARN of the event bus associated with the rule. If you omit
  this, the default event bus is used.
- `"Force"`: If this is a managed rule, created by an Amazon Web Services service on your
  behalf, you must specify Force as True to remove targets. This parameter is ignored for
  rules that are not managed rules. You can check whether a rule is a managed rule by using
  DescribeRule or ListRules and checking the ManagedBy field of the response.
"""
function remove_targets(Ids, Rule; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "RemoveTargets",
        Dict{String,Any}("Ids" => Ids, "Rule" => Rule);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_targets(
    Ids,
    Rule,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "RemoveTargets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Ids" => Ids, "Rule" => Rule), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_replay(destination, event_end_time, event_source_arn, event_start_time, replay_name)
    start_replay(destination, event_end_time, event_source_arn, event_start_time, replay_name, params::Dict{String,<:Any})

Starts the specified replay. Events are not necessarily replayed in the exact same order
that they were added to the archive. A replay processes events to replay based on the time
in the event, and replays them using 1 minute intervals. If you specify an EventStartTime
and an EventEndTime that covers a 20 minute time range, the events are replayed from the
first minute of that 20 minute range first. Then the events from the second minute are
replayed. You can use DescribeReplay to determine the progress of a replay. The value
returned for EventLastReplayedTime indicates the time within the specified time range
associated with the last event replayed.

# Arguments
- `destination`: A ReplayDestination object that includes details about the destination for
  the replay.
- `event_end_time`: A time stamp for the time to stop replaying events. Only events that
  occurred between the EventStartTime and EventEndTime are replayed.
- `event_source_arn`: The ARN of the archive to replay events from.
- `event_start_time`: A time stamp for the time to start replaying events. Only events that
  occurred between the EventStartTime and EventEndTime are replayed.
- `replay_name`: The name of the replay to start.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the replay to start.
"""
function start_replay(
    Destination,
    EventEndTime,
    EventSourceArn,
    EventStartTime,
    ReplayName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "StartReplay",
        Dict{String,Any}(
            "Destination" => Destination,
            "EventEndTime" => EventEndTime,
            "EventSourceArn" => EventSourceArn,
            "EventStartTime" => EventStartTime,
            "ReplayName" => ReplayName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_replay(
    Destination,
    EventEndTime,
    EventSourceArn,
    EventStartTime,
    ReplayName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "StartReplay",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Destination" => Destination,
                    "EventEndTime" => EventEndTime,
                    "EventSourceArn" => EventSourceArn,
                    "EventStartTime" => EventStartTime,
                    "ReplayName" => ReplayName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can
help you organize and categorize your resources. You can also use them to scope user
permissions by granting a user permission to access or change only resources with certain
tag values. In EventBridge, rules and event buses can be tagged. Tags don't have any
semantic meaning to Amazon Web Services and are interpreted strictly as strings of
characters. You can use the TagResource action with a resource that already has tags. If
you specify a new tag key, this tag is appended to the list of tags associated with the
resource. If you specify a tag key that is already associated with the resource, the new
tag value that you specify replaces the previous value for that tag. You can associate as
many as 50 tags with a resource.

# Arguments
- `resource_arn`: The ARN of the EventBridge resource that you're adding tags to.
- `tags`: The list of key-value pairs to associate with the resource.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_event_pattern(event, event_pattern)
    test_event_pattern(event, event_pattern, params::Dict{String,<:Any})

Tests whether the specified event pattern matches the provided event. Most services in
Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs).
However, EventBridge uses an exact match in event patterns and rules. Be sure to use the
correct ARN characters when creating event patterns so that they match the ARN syntax in
the event you want to match.

# Arguments
- `event`: The event, in JSON format, to test against the event pattern. The JSON must
  follow the format specified in Amazon Web Services Events, and the following fields are
  mandatory:    id     account     source     time     region     resources     detail-type
- `event_pattern`: The event pattern. For more information, see Events and Event Patterns
  in the Amazon EventBridge User Guide.

"""
function test_event_pattern(
    Event, EventPattern; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "TestEventPattern",
        Dict{String,Any}("Event" => Event, "EventPattern" => EventPattern);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_event_pattern(
    Event,
    EventPattern,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "TestEventPattern",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Event" => Event, "EventPattern" => EventPattern),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge
(CloudWatch Events), rules and event buses can be tagged.

# Arguments
- `resource_arn`: The ARN of the EventBridge resource from which you are removing tags.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_api_destination(name)
    update_api_destination(name, params::Dict{String,<:Any})

Updates an API destination.

# Arguments
- `name`: The name of the API destination to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionArn"`: The ARN of the connection to use for the API destination.
- `"Description"`: The name of the API destination to update.
- `"HttpMethod"`: The method to use for the API destination.
- `"InvocationEndpoint"`: The URL to the endpoint to use for the API destination.
- `"InvocationRateLimitPerSecond"`: The maximum number of invocations per second to send to
  the API destination.
"""
function update_api_destination(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "UpdateApiDestination",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_api_destination(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "UpdateApiDestination",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_archive(archive_name)
    update_archive(archive_name, params::Dict{String,<:Any})

Updates the specified archive.

# Arguments
- `archive_name`: The name of the archive to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description for the archive.
- `"EventPattern"`: The event pattern to use to filter events sent to the archive.
- `"RetentionDays"`: The number of days to retain events in the archive.
"""
function update_archive(ArchiveName; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "UpdateArchive",
        Dict{String,Any}("ArchiveName" => ArchiveName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_archive(
    ArchiveName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cloudwatch_events(
        "UpdateArchive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ArchiveName" => ArchiveName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connection(name)
    update_connection(name, params::Dict{String,<:Any})

Updates settings for a connection.

# Arguments
- `name`: The name of the connection to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthParameters"`: The authorization parameters to use for the connection.
- `"AuthorizationType"`: The type of authorization to use for the connection.
- `"Description"`: A description for the connection.
"""
function update_connection(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return cloudwatch_events(
        "UpdateConnection",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connection(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cloudwatch_events(
        "UpdateConnection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
