# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: storage_gateway
using AWS.Compat
using AWS.UUIDs

"""
    activate_gateway(activation_key, gateway_name, gateway_region, gateway_timezone)
    activate_gateway(activation_key, gateway_name, gateway_region, gateway_timezone, params::Dict{String,<:Any})

Activates the gateway you previously deployed on your host. In the activation process, you
specify information such as the Amazon Web Services Region that you want to use for storing
snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule
window, an activation key, and a name for your gateway. The activation process also
associates your gateway with your account. For more information, see
UpdateGatewayInformation.  You must turn on the gateway VM before you can activate your
gateway.

# Arguments
- `activation_key`: Your gateway activation key. You can obtain the activation key by
  sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The
  redirect URL returned in the response provides you the activation key for your gateway in
  the query string parameter activationKey. It may also include other activation-related
  parameters, however, these are merely defaults -- the arguments you pass to the
  ActivateGateway API call determine the actual configuration of your gateway. For more
  information, see Getting activation key in the Storage Gateway User Guide.
- `gateway_name`: The name you configured for your gateway.
- `gateway_region`: A value that indicates the Amazon Web Services Region where you want to
  store your data. The gateway Amazon Web Services Region specified must be the same Amazon
  Web Services Region as the Amazon Web Services Region in your Host header in the request.
  For more information about available Amazon Web Services Regions and endpoints for Storage
  Gateway, see  Storage Gateway endpoints and quotas in the Amazon Web Services General
  Reference. Valid Values: See  Storage Gateway endpoints and quotas in the Amazon Web
  Services General Reference.
- `gateway_timezone`: A value that indicates the time zone you want to set for the gateway.
  The time zone is of the format \"GMT\", \"GMT-hr:mm\", or \"GMT+hr:mm\". For example, GMT
  indicates Greenwich Mean Time without any offset. GMT-4:00 indicates the time is 4 hours
  behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for
  example, for scheduling snapshots and your gateway's maintenance schedule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayType"`: A value that defines the type of gateway to activate. The type specified
  is critical to all later functions of the gateway and cannot be changed after activation.
  The default value is CACHED. Valid Values: STORED | CACHED | VTL | FILE_S3 | FILE_FSX_SMB
- `"MediumChangerType"`: The value that indicates the type of medium changer to use for
  tape gateway. This field is optional. Valid Values: STK-L700 | AWS-Gateway-VTL |
  IBM-03584L32-0402
- `"Tags"`: A list of up to 50 tags that you can assign to the gateway. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers that
  can be represented in UTF-8 format, and the following special characters: + - = . _ : / @.
  The maximum length of a tag's key is 128 characters, and the maximum length for a tag's
  value is 256 characters.
- `"TapeDriveType"`: The value that indicates the type of tape drive to use for tape
  gateway. This field is optional. Valid Values: IBM-ULT3580-TD5
"""
function activate_gateway(
    ActivationKey,
    GatewayName,
    GatewayRegion,
    GatewayTimezone;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ActivateGateway",
        Dict{String,Any}(
            "ActivationKey" => ActivationKey,
            "GatewayName" => GatewayName,
            "GatewayRegion" => GatewayRegion,
            "GatewayTimezone" => GatewayTimezone,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_gateway(
    ActivationKey,
    GatewayName,
    GatewayRegion,
    GatewayTimezone,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ActivateGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActivationKey" => ActivationKey,
                    "GatewayName" => GatewayName,
                    "GatewayRegion" => GatewayRegion,
                    "GatewayTimezone" => GatewayTimezone,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_cache(disk_ids, gateway_arn)
    add_cache(disk_ids, gateway_arn, params::Dict{String,<:Any})

Configures one or more gateway local disks as cache for a gateway. This operation is only
supported in the cached volume, tape, and file gateway type (see How Storage Gateway works
(architecture). In the request, you specify the gateway Amazon Resource Name (ARN) to which
you want to add cache, and one or more disk IDs that you want to configure as cache.

# Arguments
- `disk_ids`: An array of strings that identify disks that are to be configured as working
  storage. Each string has a minimum length of 1 and maximum length of 300. You can get the
  disk IDs from the ListLocalDisks API.
- `gateway_arn`:

"""
function add_cache(DiskIds, GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "AddCache",
        Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_cache(
    DiskIds,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AddCache",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_tags_to_resource(resource_arn, tags)
    add_tags_to_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds one or more tags to the specified resource. You use tags to add metadata to resources,
which you can use to categorize these resources. For example, you can categorize resources
by purpose, owner, environment, or team. Each tag consists of a key and a value, which you
define. You can add tags to the following Storage Gateway resources:   Storage gateways of
all types   Storage volumes   Virtual tapes   NFS and SMB file shares   File System
associations   You can create a maximum of 50 tags for each resource. Virtual tapes and
storage volumes that are recovered to a new gateway maintain their tags.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource you want to add tags to.
- `tags`: The key-value pair that represents the tag you want to add to the resource. The
  value can be an empty string.  Valid characters for key and value are letters, spaces, and
  numbers representable in UTF-8 format, and the following special characters: + - = . _ : /
  @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's
  value is 256.

"""
function add_tags_to_resource(
    ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "AddTagsToResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_upload_buffer(disk_ids, gateway_arn)
    add_upload_buffer(disk_ids, gateway_arn, params::Dict{String,<:Any})

Configures one or more gateway local disks as upload buffer for a specified gateway. This
operation is supported for the stored volume, cached volume, and tape gateway types. In the
request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload
buffer, and one or more disk IDs that you want to configure as upload buffer.

# Arguments
- `disk_ids`: An array of strings that identify disks that are to be configured as working
  storage. Each string has a minimum length of 1 and maximum length of 300. You can get the
  disk IDs from the ListLocalDisks API.
- `gateway_arn`:

"""
function add_upload_buffer(
    DiskIds, GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "AddUploadBuffer",
        Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_upload_buffer(
    DiskIds,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AddUploadBuffer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_working_storage(disk_ids, gateway_arn)
    add_working_storage(disk_ids, gateway_arn, params::Dict{String,<:Any})

Configures one or more gateway local disks as working storage for a gateway. This operation
is only supported in the stored volume gateway type. This operation is deprecated in cached
volume API version 20120630. Use AddUploadBuffer instead.  Working storage is also referred
to as upload buffer. You can also use the AddUploadBuffer operation to add upload buffer to
a stored volume gateway.  In the request, you specify the gateway Amazon Resource Name
(ARN) to which you want to add working storage, and one or more disk IDs that you want to
configure as working storage.

# Arguments
- `disk_ids`: An array of strings that identify disks that are to be configured as working
  storage. Each string has a minimum length of 1 and maximum length of 300. You can get the
  disk IDs from the ListLocalDisks API.
- `gateway_arn`:

"""
function add_working_storage(
    DiskIds, GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "AddWorkingStorage",
        Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_working_storage(
    DiskIds,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AddWorkingStorage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DiskIds" => DiskIds, "GatewayARN" => GatewayARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assign_tape_pool(pool_id, tape_arn)
    assign_tape_pool(pool_id, tape_arn, params::Dict{String,<:Any})

Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the
S3 storage class that is associated with the pool. When you use your backup application to
eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3
Glacier Deep Archive) that corresponds to the pool.

# Arguments
- `pool_id`: The ID of the pool that you want to add your tape to for archiving. The tape
  in this pool is archived in the S3 storage class that is associated with the pool. When you
  use your backup application to eject the tape, the tape is archived directly into the
  storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
- `tape_arn`: The unique Amazon Resource Name (ARN) of the virtual tape that you want to
  add to the tape pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BypassGovernanceRetention"`: Set permissions to bypass governance retention. If the
  lock type of the archived tape is Governance, the tape's archived age is not older than
  RetentionLockInDays, and the user does not already have BypassGovernanceRetention, setting
  this to TRUE enables the user to bypass the retention lock. This parameter is set to true
  by default for calls from the console. Valid values: TRUE | FALSE
"""
function assign_tape_pool(
    PoolId, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "AssignTapePool",
        Dict{String,Any}("PoolId" => PoolId, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_tape_pool(
    PoolId,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AssignTapePool",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("PoolId" => PoolId, "TapeARN" => TapeARN), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_file_system(client_token, gateway_arn, location_arn, password, user_name)
    associate_file_system(client_token, gateway_arn, location_arn, password, user_name, params::Dict{String,<:Any})

Associate an Amazon FSx file system with the FSx File Gateway. After the association
process is complete, the file shares on the Amazon FSx file system are available for access
through the gateway. This operation only supports the FSx File Gateway type.

# Arguments
- `client_token`: A unique string value that you supply that is used by the FSx File
  Gateway to ensure idempotent file system association creation.
- `gateway_arn`:
- `location_arn`: The Amazon Resource Name (ARN) of the Amazon FSx file system to associate
  with the FSx File Gateway.
- `password`: The password of the user credential.
- `user_name`: The user name of the user credential that has permission to access the root
  share D of the Amazon FSx file system. The user account must belong to the Amazon FSx
  delegated admin user group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for the audit
  logs.
- `"CacheAttributes"`:
- `"EndpointNetworkConfiguration"`: Specifies the network configuration information for the
  gateway associated with the Amazon FSx file system.  If multiple file systems are
  associated with this gateway, this parameter's IpAddresses field is required.
- `"Tags"`: A list of up to 50 tags that can be assigned to the file system association.
  Each tag is a key-value pair.
"""
function associate_file_system(
    ClientToken,
    GatewayARN,
    LocationARN,
    Password,
    UserName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AssociateFileSystem",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "GatewayARN" => GatewayARN,
            "LocationARN" => LocationARN,
            "Password" => Password,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_file_system(
    ClientToken,
    GatewayARN,
    LocationARN,
    Password,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AssociateFileSystem",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "GatewayARN" => GatewayARN,
                    "LocationARN" => LocationARN,
                    "Password" => Password,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_volume(gateway_arn, network_interface_id, volume_arn)
    attach_volume(gateway_arn, network_interface_id, volume_arn, params::Dict{String,<:Any})

Connects a volume to an iSCSI connection and then attaches the volume to the specified
gateway. Detaching and attaching a volume enables you to recover your data from one gateway
to a different gateway without creating a snapshot. It also makes it easier to move your
volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway that you want to attach the
  volume to.
- `network_interface_id`: The network interface of the gateway on which to expose the iSCSI
  target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of
  the network interfaces available on a gateway. Valid Values: A valid IP address.
- `volume_arn`: The Amazon Resource Name (ARN) of the volume to attach to the specified
  gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DiskId"`: The unique device ID or other distinguishing data that identifies the local
  disk used to create the volume. This value is only required when you are attaching a stored
  volume.
- `"TargetName"`: The name of the iSCSI target used by an initiator to connect to a volume
  and used as a suffix for the target ARN. For example, specifying TargetName as myvolume
  results in the target ARN of
  arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.am
  azon:myvolume. The target name must be unique across all volumes on a gateway. If you don't
  specify a value, Storage Gateway uses the value that was previously used for this volume as
  the new target name.
"""
function attach_volume(
    GatewayARN,
    NetworkInterfaceId,
    VolumeARN;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AttachVolume",
        Dict{String,Any}(
            "GatewayARN" => GatewayARN,
            "NetworkInterfaceId" => NetworkInterfaceId,
            "VolumeARN" => VolumeARN,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_volume(
    GatewayARN,
    NetworkInterfaceId,
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "AttachVolume",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayARN" => GatewayARN,
                    "NetworkInterfaceId" => NetworkInterfaceId,
                    "VolumeARN" => VolumeARN,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_archival(gateway_arn, tape_arn)
    cancel_archival(gateway_arn, tape_arn, params::Dict{String,<:Any})

Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving
process is initiated. This operation is only supported in the tape gateway type.

# Arguments
- `gateway_arn`:
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape you want to cancel
  archiving for.

"""
function cancel_archival(
    GatewayARN, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "CancelArchival",
        Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_archival(
    GatewayARN,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CancelArchival",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_retrieval(gateway_arn, tape_arn)
    cancel_retrieval(gateway_arn, tape_arn, params::Dict{String,<:Any})

Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after
the retrieval process is initiated. The virtual tape is returned to the VTS. This operation
is only supported in the tape gateway type.

# Arguments
- `gateway_arn`:
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape you want to cancel
  retrieval for.

"""
function cancel_retrieval(
    GatewayARN, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "CancelRetrieval",
        Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_retrieval(
    GatewayARN,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CancelRetrieval",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cachedi_scsivolume(client_token, gateway_arn, network_interface_id, target_name, volume_size_in_bytes)
    create_cachedi_scsivolume(client_token, gateway_arn, network_interface_id, target_name, volume_size_in_bytes, params::Dict{String,<:Any})

Creates a cached volume on a specified cached volume gateway. This operation is only
supported in the cached volume gateway type.  Cache storage must be allocated to the
gateway before you can create a cached volume. Use the AddCache operation to add cache
storage to a gateway.  In the request, you must specify the gateway, size of the volume in
bytes, the iSCSI target name, an IP address on which to expose the target, and a unique
client token. In response, the gateway creates the volume and returns information about it.
This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI
target ARN that initiators can use to connect to the volume target. Optionally, you can
provide the ARN for an existing volume as the SourceVolumeARN for this cached volume, which
creates an exact copy of the existing volume’s latest recovery point. The
VolumeSizeInBytes value must be equal to or larger than the size of the copied volume, in
bytes.

# Arguments
- `client_token`: A unique identifier that you use to retry a request. If you retry a
  request, use the same ClientToken you specified in the initial request.
- `gateway_arn`:
- `network_interface_id`: The network interface of the gateway on which to expose the iSCSI
  target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of
  the network interfaces available on a gateway. Valid Values: A valid IP address.
- `target_name`: The name of the iSCSI target used by an initiator to connect to a volume
  and used as a suffix for the target ARN. For example, specifying TargetName as myvolume
  results in the target ARN of
  arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.am
  azon:myvolume. The target name must be unique across all volumes on a gateway. If you don't
  specify a value, Storage Gateway uses the value that was previously used for this volume as
  the new target name.
- `volume_size_in_bytes`: The size of the volume in bytes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"SnapshotId"`: The snapshot ID (e.g. \"snap-1122aabb\") of the snapshot to restore as
  the new cached volume. Specify this field if you want to create the iSCSI storage volume
  from a snapshot; otherwise, do not include this field. To list snapshots for your account
  use DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference.
- `"SourceVolumeARN"`: The ARN for an existing volume. Specifying this ARN makes the new
  volume into an exact copy of the specified existing volume's latest recovery point. The
  VolumeSizeInBytes value for this new volume must be equal to or larger than the size of the
  existing volume, in bytes.
- `"Tags"`: A list of up to 50 tags that you can assign to a cached volume. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers that
  you can represent in UTF-8 format, and the following special characters: + - = . _ : / @.
  The maximum length of a tag's key is 128 characters, and the maximum length for a tag's
  value is 256 characters.
"""
function create_cachedi_scsivolume(
    ClientToken,
    GatewayARN,
    NetworkInterfaceId,
    TargetName,
    VolumeSizeInBytes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateCachediSCSIVolume",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "GatewayARN" => GatewayARN,
            "NetworkInterfaceId" => NetworkInterfaceId,
            "TargetName" => TargetName,
            "VolumeSizeInBytes" => VolumeSizeInBytes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cachedi_scsivolume(
    ClientToken,
    GatewayARN,
    NetworkInterfaceId,
    TargetName,
    VolumeSizeInBytes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateCachediSCSIVolume",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "GatewayARN" => GatewayARN,
                    "NetworkInterfaceId" => NetworkInterfaceId,
                    "TargetName" => TargetName,
                    "VolumeSizeInBytes" => VolumeSizeInBytes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_nfsfile_share(client_token, gateway_arn, location_arn, role)
    create_nfsfile_share(client_token, gateway_arn, location_arn, role, params::Dict{String,<:Any})

Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage
Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage.
Storage Gateway exposes file shares using an NFS interface. This operation is only
supported for S3 File Gateways.  S3 File gateway requires Security Token Service (Amazon
Web Services STS) to be activated to enable you to create a file share. Make sure Amazon
Web Services STS is activated in the Amazon Web Services Region you are creating your S3
File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services
Region, activate it. For information about how to activate Amazon Web Services STS, see
Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region in the
Identity and Access Management User Guide. S3 File Gateways do not support creating hard or
symbolic links on a file share.

# Arguments
- `client_token`: A unique string value that you supply that is used by S3 File Gateway to
  ensure idempotent file share creation.
- `gateway_arn`: The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to
  create a file share.
- `location_arn`: A custom ARN for the backend storage used for storing data for file
  shares. It includes a resource ARN with an optional prefix concatenation. The prefix must
  end with a forward slash (/).  You can specify LocationARN as a bucket ARN, access point
  ARN or access point alias, as shown in the following examples. Bucket ARN:
  arn:aws:s3:::my-bucket/prefix/  Access point ARN:
  arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/  If you specify an
  access point, the bucket policy must be configured to delegate access control to the access
  point. For information, see Delegating access control to access points in the Amazon S3
  User Guide. Access point alias:  test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias
- `role`: The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway
  assumes when it accesses the underlying storage.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for audit
  logs.
- `"BucketRegion"`: Specifies the Region of the S3 bucket where the NFS file share stores
  files.  This parameter is required for NFS file shares that connect to Amazon S3 through a
  VPC endpoint, a VPC access point, or an access point alias that points to a VPC access
  point.
- `"CacheAttributes"`: Specifies refresh cache information for the file share.
- `"ClientList"`: The list of clients that are allowed to access the S3 File Gateway. The
  list must contain either valid IP addresses or valid CIDR blocks.
- `"DefaultStorageClass"`: The default storage class for objects put into an Amazon S3
  bucket by the S3 File Gateway. The default value is S3_STANDARD. Optional. Valid Values:
  S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
- `"FileShareName"`: The name of the file share. Optional.   FileShareName must be set if
  an S3 prefix name is set in LocationARN, or if an access point or access point alias is
  used.
- `"GuessMIMETypeEnabled"`: A value that enables guessing of the MIME type for uploaded
  objects based on file extensions. Set this value to true to enable MIME type guessing,
  otherwise set to false. The default value is true. Valid Values: true | false
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"NFSFileShareDefaults"`: File share default values. Optional.
- `"NotificationPolicy"`: The notification policy of the file share. SettlingTimeInSeconds
  controls the number of seconds to wait after the last point in time a client wrote to a
  file before generating an ObjectUploaded notification. Because clients can make many small
  writes to files, it's best to set this parameter for as long as possible to avoid
  generating multiple notifications for the same file in a small time period.
  SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3,
  only the timing of the notification.  The following example sets NotificationPolicy on with
  SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The
  following example sets NotificationPolicy off.  {}
- `"ObjectACL"`: A value that sets the access control list (ACL) permission for objects in
  the S3 bucket that a S3 File Gateway puts objects into. The default value is private.
- `"ReadOnly"`: A value that sets the write status of a file share. Set this value to true
  to set the write status to read-only, otherwise set to false. Valid Values: true | false
- `"RequesterPays"`: A value that sets who pays the cost of the request and the cost
  associated with data download from the S3 bucket. If this value is set to true, the
  requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner
  always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket
  that backs the file share, so make sure that the configuration on the file share is the
  same as the S3 bucket configuration.  Valid Values: true | false
- `"Squash"`: A value that maps a user to anonymous user. Valid values are the following:
   RootSquash: Only root is mapped to anonymous user.    NoSquash: No one is mapped to
  anonymous user.    AllSquash: Everyone is mapped to anonymous user.
- `"Tags"`: A list of up to 50 tags that can be assigned to the NFS file share. Each tag is
  a key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
- `"VPCEndpointDNSName"`: Specifies the DNS name for the VPC endpoint that the NFS file
  share uses to connect to Amazon S3.  This parameter is required for NFS file shares that
  connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias
  that points to a VPC access point.
"""
function create_nfsfile_share(
    ClientToken,
    GatewayARN,
    LocationARN,
    Role;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateNFSFileShare",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "GatewayARN" => GatewayARN,
            "LocationARN" => LocationARN,
            "Role" => Role,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_nfsfile_share(
    ClientToken,
    GatewayARN,
    LocationARN,
    Role,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateNFSFileShare",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "GatewayARN" => GatewayARN,
                    "LocationARN" => LocationARN,
                    "Role" => Role,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_smbfile_share(client_token, gateway_arn, location_arn, role)
    create_smbfile_share(client_token, gateway_arn, location_arn, role, params::Dict{String,<:Any})

Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage
Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage.
Storage Gateway exposes file shares using an SMB interface. This operation is only
supported for S3 File Gateways.  S3 File Gateways require Security Token Service (Amazon
Web Services STS) to be activated to enable you to create a file share. Make sure that
Amazon Web Services STS is activated in the Amazon Web Services Region you are creating
your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web
Services Region, activate it. For information about how to activate Amazon Web Services
STS, see Activating and deactivating Amazon Web Services STS in an Amazon Web Services
Region in the Identity and Access Management User Guide. File gateways don't support
creating hard or symbolic links on a file share.

# Arguments
- `client_token`: A unique string value that you supply that is used by S3 File Gateway to
  ensure idempotent file share creation.
- `gateway_arn`: The ARN of the S3 File Gateway on which you want to create a file share.
- `location_arn`: A custom ARN for the backend storage used for storing data for file
  shares. It includes a resource ARN with an optional prefix concatenation. The prefix must
  end with a forward slash (/).  You can specify LocationARN as a bucket ARN, access point
  ARN or access point alias, as shown in the following examples. Bucket ARN:
  arn:aws:s3:::my-bucket/prefix/  Access point ARN:
  arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/  If you specify an
  access point, the bucket policy must be configured to delegate access control to the access
  point. For information, see Delegating access control to access points in the Amazon S3
  User Guide. Access point alias:  test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias
- `role`: The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway
  assumes when it accesses the underlying storage.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessBasedEnumeration"`: The files and folders on this share will only be visible to
  users with read access.
- `"AdminUserList"`: A list of users or groups in the Active Directory that will be granted
  administrator privileges on the file share. These users can do all file operations as the
  super-user. Acceptable formats include: DOMAINUser1, user1, @group1, and @DOMAINgroup1.
  Use this option very carefully, because any user in this list can do anything they like on
  the file share, regardless of file permissions.
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for audit
  logs.
- `"Authentication"`: The authentication method that users use to access the file share.
  The default is ActiveDirectory. Valid Values: ActiveDirectory | GuestAccess
- `"BucketRegion"`: Specifies the Region of the S3 bucket where the SMB file share stores
  files.  This parameter is required for SMB file shares that connect to Amazon S3 through a
  VPC endpoint, a VPC access point, or an access point alias that points to a VPC access
  point.
- `"CacheAttributes"`: Specifies refresh cache information for the file share.
- `"CaseSensitivity"`: The case of an object name in an Amazon S3 bucket. For
  ClientSpecified, the client determines the case sensitivity. For CaseSensitive, the gateway
  determines the case sensitivity. The default value is ClientSpecified.
- `"DefaultStorageClass"`: The default storage class for objects put into an Amazon S3
  bucket by the S3 File Gateway. The default value is S3_STANDARD. Optional. Valid Values:
  S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
- `"FileShareName"`: The name of the file share. Optional.   FileShareName must be set if
  an S3 prefix name is set in LocationARN, or if an access point or access point alias is
  used.
- `"GuessMIMETypeEnabled"`: A value that enables guessing of the MIME type for uploaded
  objects based on file extensions. Set this value to true to enable MIME type guessing,
  otherwise set to false. The default value is true. Valid Values: true | false
- `"InvalidUserList"`: A list of users or groups in the Active Directory that are not
  allowed to access the file share. A group must be prefixed with the @ character. Acceptable
  formats include: DOMAINUser1, user1, @group1, and @DOMAINgroup1. Can only be set if
  Authentication is set to ActiveDirectory.
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"NotificationPolicy"`: The notification policy of the file share. SettlingTimeInSeconds
  controls the number of seconds to wait after the last point in time a client wrote to a
  file before generating an ObjectUploaded notification. Because clients can make many small
  writes to files, it's best to set this parameter for as long as possible to avoid
  generating multiple notifications for the same file in a small time period.
  SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3,
  only the timing of the notification.  The following example sets NotificationPolicy on with
  SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The
  following example sets NotificationPolicy off.  {}
- `"ObjectACL"`: A value that sets the access control list (ACL) permission for objects in
  the S3 bucket that a S3 File Gateway puts objects into. The default value is private.
- `"OplocksEnabled"`: Specifies whether opportunistic locking is enabled for the SMB file
  share.  Enabling opportunistic locking on case-sensitive shares is not recommended for
  workloads that involve access to files with the same name in different case.  Valid Values:
  true | false
- `"ReadOnly"`: A value that sets the write status of a file share. Set this value to true
  to set the write status to read-only, otherwise set to false. Valid Values: true | false
- `"RequesterPays"`: A value that sets who pays the cost of the request and the cost
  associated with data download from the S3 bucket. If this value is set to true, the
  requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner
  always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket
  that backs the file share, so make sure that the configuration on the file share is the
  same as the S3 bucket configuration.  Valid Values: true | false
- `"SMBACLEnabled"`: Set this value to true to enable access control list (ACL) on the SMB
  file share. Set it to false to map file and directory permissions to the POSIX permissions.
  For more information, see Using Microsoft Windows ACLs to control access to an SMB file
  share in the Storage Gateway User Guide. Valid Values: true | false
- `"Tags"`: A list of up to 50 tags that can be assigned to the NFS file share. Each tag is
  a key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
- `"VPCEndpointDNSName"`: Specifies the DNS name for the VPC endpoint that the SMB file
  share uses to connect to Amazon S3.  This parameter is required for SMB file shares that
  connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias
  that points to a VPC access point.
- `"ValidUserList"`: A list of users or groups in the Active Directory that are allowed to
  access the file  share. A group must be prefixed with the @ character. Acceptable formats
  include: DOMAINUser1, user1, @group1, and @DOMAINgroup1. Can only be set if Authentication
  is set to ActiveDirectory.
"""
function create_smbfile_share(
    ClientToken,
    GatewayARN,
    LocationARN,
    Role;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateSMBFileShare",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "GatewayARN" => GatewayARN,
            "LocationARN" => LocationARN,
            "Role" => Role,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_smbfile_share(
    ClientToken,
    GatewayARN,
    LocationARN,
    Role,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateSMBFileShare",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "GatewayARN" => GatewayARN,
                    "LocationARN" => LocationARN,
                    "Role" => Role,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot(snapshot_description, volume_arn)
    create_snapshot(snapshot_description, volume_arn, params::Dict{String,<:Any})

Initiates a snapshot of a volume. Storage Gateway provides the ability to back up
point-in-time snapshots of your data to Amazon Simple Storage (Amazon S3) for durable
off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume
in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a
scheduled or ad hoc basis. This API enables you to take an ad hoc snapshot. For more
information, see Editing a snapshot schedule. In the CreateSnapshot request, you identify
the volume by providing its Amazon Resource Name (ARN). You must also provide description
for the snapshot. When Storage Gateway takes the snapshot of specified volume, the snapshot
and description appears in the Storage Gateway console. In response, Storage Gateway
returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or
later use it when you want to create a volume from a snapshot. This operation is only
supported in stored and cached volume gateway type.  To list or delete a snapshot, you must
use the Amazon EC2 API. For more information, see DescribeSnapshots or DeleteSnapshot in
the Amazon Elastic Compute Cloud API Reference.   Volume and snapshot IDs are changing to a
longer length ID format. For more information, see the important note on the Welcome page.

# Arguments
- `snapshot_description`: Textual description of the snapshot that appears in the Amazon
  EC2 console, Elastic Block Store snapshots panel in the Description field, and in the
  Storage Gateway snapshot Details pane, Description field.
- `volume_arn`: The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
  to return a list of gateway volumes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
"""
function create_snapshot(
    SnapshotDescription, VolumeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "CreateSnapshot",
        Dict{String,Any}(
            "SnapshotDescription" => SnapshotDescription, "VolumeARN" => VolumeARN
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot(
    SnapshotDescription,
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SnapshotDescription" => SnapshotDescription, "VolumeARN" => VolumeARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot_from_volume_recovery_point(snapshot_description, volume_arn)
    create_snapshot_from_volume_recovery_point(snapshot_description, volume_arn, params::Dict{String,<:Any})

Initiates a snapshot of a gateway from a volume recovery point. This operation is only
supported in the cached volume gateway type. A volume recovery point is a point in time at
which all data of the volume is consistent and from which you can create a snapshot. To get
a list of volume recovery point for cached volume gateway, use ListVolumeRecoveryPoints. In
the CreateSnapshotFromVolumeRecoveryPoint request, you identify the volume by providing its
Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the
gateway takes a snapshot of the specified volume, the snapshot and its description appear
in the Storage Gateway console. In response, the gateway returns you a snapshot ID. You can
use this snapshot ID to check the snapshot progress or later use it when you want to create
a volume from a snapshot.  To list or delete a snapshot, you must use the Amazon EC2 API.
For more information, see DescribeSnapshots or DeleteSnapshot in the Amazon Elastic Compute
Cloud API Reference.

# Arguments
- `snapshot_description`: Textual description of the snapshot that appears in the Amazon
  EC2 console, Elastic Block Store snapshots panel in the Description field, and in the
  Storage Gateway snapshot Details pane, Description field.
- `volume_arn`: The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
  DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN for specified
  VolumeARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
"""
function create_snapshot_from_volume_recovery_point(
    SnapshotDescription, VolumeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "CreateSnapshotFromVolumeRecoveryPoint",
        Dict{String,Any}(
            "SnapshotDescription" => SnapshotDescription, "VolumeARN" => VolumeARN
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot_from_volume_recovery_point(
    SnapshotDescription,
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateSnapshotFromVolumeRecoveryPoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SnapshotDescription" => SnapshotDescription, "VolumeARN" => VolumeARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_storedi_scsivolume(disk_id, gateway_arn, network_interface_id, preserve_existing_data, target_name)
    create_storedi_scsivolume(disk_id, gateway_arn, network_interface_id, preserve_existing_data, target_name, params::Dict{String,<:Any})

Creates a volume on a specified gateway. This operation is only supported in the stored
volume gateway type. The size of the volume to create is inferred from the disk size. You
can choose to preserve existing data on the disk, create volume from an existing snapshot,
or create an empty volume. If you choose to create an empty gateway volume, then any
existing data on the disk is erased. In the request, you must specify the gateway and the
disk information on which you are creating the volume. In response, the gateway creates the
volume and returns volume information such as the volume Amazon Resource Name (ARN), its
size, and the iSCSI target ARN that initiators can use to connect to the volume target.

# Arguments
- `disk_id`: The unique identifier for the gateway local disk that is configured as a
  stored volume. Use ListLocalDisks to list disk IDs for a gateway.
- `gateway_arn`:
- `network_interface_id`: The network interface of the gateway on which to expose the iSCSI
  target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of
  the network interfaces available on a gateway. Valid Values: A valid IP address.
- `preserve_existing_data`: Set to true if you want to preserve the data on the local disk.
  Otherwise, set to false to create an empty volume. Valid Values: true | false
- `target_name`: The name of the iSCSI target used by an initiator to connect to a volume
  and used as a suffix for the target ARN. For example, specifying TargetName as myvolume
  results in the target ARN of
  arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.am
  azon:myvolume. The target name must be unique across all volumes on a gateway. If you don't
  specify a value, Storage Gateway uses the value that was previously used for this volume as
  the new target name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"SnapshotId"`: The snapshot ID (e.g., \"snap-1122aabb\") of the snapshot to restore as
  the new stored volume. Specify this field if you want to create the iSCSI storage volume
  from a snapshot; otherwise, do not include this field. To list snapshots for your account
  use DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference.
- `"Tags"`: A list of up to 50 tags that can be assigned to a stored volume. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
"""
function create_storedi_scsivolume(
    DiskId,
    GatewayARN,
    NetworkInterfaceId,
    PreserveExistingData,
    TargetName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateStorediSCSIVolume",
        Dict{String,Any}(
            "DiskId" => DiskId,
            "GatewayARN" => GatewayARN,
            "NetworkInterfaceId" => NetworkInterfaceId,
            "PreserveExistingData" => PreserveExistingData,
            "TargetName" => TargetName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_storedi_scsivolume(
    DiskId,
    GatewayARN,
    NetworkInterfaceId,
    PreserveExistingData,
    TargetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateStorediSCSIVolume",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DiskId" => DiskId,
                    "GatewayARN" => GatewayARN,
                    "NetworkInterfaceId" => NetworkInterfaceId,
                    "PreserveExistingData" => PreserveExistingData,
                    "TargetName" => TargetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tape_pool(pool_name, storage_class)
    create_tape_pool(pool_name, storage_class, params::Dict{String,<:Any})

Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock
on tapes that are archived in the custom pool.

# Arguments
- `pool_name`: The name of the new custom tape pool.
- `storage_class`: The storage class that is associated with the new custom pool. When you
  use your backup application to eject the tape, the tape is archived directly into the
  storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RetentionLockTimeInDays"`: Tape retention lock time is set in days. Tape retention lock
  can be enabled for up to 100 years (36,500 days).
- `"RetentionLockType"`: Tape retention lock can be configured in two modes. When
  configured in governance mode, Amazon Web Services accounts with specific IAM permissions
  are authorized to remove the tape retention lock from archived virtual tapes. When
  configured in compliance mode, the tape retention lock cannot be removed by any user,
  including the root Amazon Web Services account.
- `"Tags"`: A list of up to 50 tags that can be assigned to tape pool. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
"""
function create_tape_pool(
    PoolName, StorageClass; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "CreateTapePool",
        Dict{String,Any}("PoolName" => PoolName, "StorageClass" => StorageClass);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tape_pool(
    PoolName,
    StorageClass,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateTapePool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PoolName" => PoolName, "StorageClass" => StorageClass),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tape_with_barcode(gateway_arn, tape_barcode, tape_size_in_bytes)
    create_tape_with_barcode(gateway_arn, tape_barcode, tape_size_in_bytes, params::Dict{String,<:Any})

Creates a virtual tape by using your own barcode. You write data to the virtual tape and
then archive the tape. A barcode is unique and cannot be reused if it has already been used
on a tape. This applies to barcodes used on deleted tapes. This operation is only supported
in the tape gateway type.  Cache storage must be allocated to the gateway before you can
create a virtual tape. Use the AddCache operation to add cache storage to a gateway.

# Arguments
- `gateway_arn`: The unique Amazon Resource Name (ARN) that represents the gateway to
  associate the virtual tape with. Use the ListGateways operation to return a list of
  gateways for your account and Amazon Web Services Region.
- `tape_barcode`: The barcode that you want to assign to the tape.  Barcodes cannot be
  reused. This includes barcodes used for tapes that have been deleted.
- `tape_size_in_bytes`: The size, in bytes, of the virtual tape that you want to create.
  The size must be aligned by gigabyte (1024*1024*1024 bytes).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"PoolId"`: The ID of the pool that you want to add your tape to for archiving. The tape
  in this pool is archived in the S3 storage class that is associated with the pool. When you
  use your backup application to eject the tape, the tape is archived directly into the
  storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
- `"Tags"`: A list of up to 50 tags that can be assigned to a virtual tape that has a
  barcode. Each tag is a key-value pair.  Valid characters for key and value are letters,
  spaces, and numbers representable in UTF-8 format, and the following special characters: +
  - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length
  for a tag's value is 256.
- `"Worm"`: Set to TRUE if the tape you are creating is to be configured as a
  write-once-read-many (WORM) tape.
"""
function create_tape_with_barcode(
    GatewayARN,
    TapeBarcode,
    TapeSizeInBytes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateTapeWithBarcode",
        Dict{String,Any}(
            "GatewayARN" => GatewayARN,
            "TapeBarcode" => TapeBarcode,
            "TapeSizeInBytes" => TapeSizeInBytes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tape_with_barcode(
    GatewayARN,
    TapeBarcode,
    TapeSizeInBytes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateTapeWithBarcode",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayARN" => GatewayARN,
                    "TapeBarcode" => TapeBarcode,
                    "TapeSizeInBytes" => TapeSizeInBytes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tapes(client_token, gateway_arn, num_tapes_to_create, tape_barcode_prefix, tape_size_in_bytes)
    create_tapes(client_token, gateway_arn, num_tapes_to_create, tape_barcode_prefix, tape_size_in_bytes, params::Dict{String,<:Any})

Creates one or more virtual tapes. You write data to the virtual tapes and then archive the
tapes. This operation is only supported in the tape gateway type.  Cache storage must be
allocated to the gateway before you can create virtual tapes. Use the AddCache operation to
add cache storage to a gateway.

# Arguments
- `client_token`: A unique identifier that you use to retry a request. If you retry a
  request, use the same ClientToken you specified in the initial request.  Using the same
  ClientToken prevents creating the tape multiple times.
- `gateway_arn`: The unique Amazon Resource Name (ARN) that represents the gateway to
  associate the virtual tapes with. Use the ListGateways operation to return a list of
  gateways for your account and Amazon Web Services Region.
- `num_tapes_to_create`: The number of virtual tapes that you want to create.
- `tape_barcode_prefix`: A prefix that you append to the barcode of the virtual tape you
  are creating. This prefix makes the barcode unique.  The prefix must be 1-4 characters in
  length and must be one of the uppercase letters from A to Z.
- `tape_size_in_bytes`: The size, in bytes, of the virtual tapes that you want to create.
  The size must be aligned by gigabyte (1024*1024*1024 bytes).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"PoolId"`: The ID of the pool that you want to add your tape to for archiving. The tape
  in this pool is archived in the S3 storage class that is associated with the pool. When you
  use your backup application to eject the tape, the tape is archived directly into the
  storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
- `"Tags"`: A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
- `"Worm"`: Set to TRUE if the tape you are creating is to be configured as a
  write-once-read-many (WORM) tape.
"""
function create_tapes(
    ClientToken,
    GatewayARN,
    NumTapesToCreate,
    TapeBarcodePrefix,
    TapeSizeInBytes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateTapes",
        Dict{String,Any}(
            "ClientToken" => ClientToken,
            "GatewayARN" => GatewayARN,
            "NumTapesToCreate" => NumTapesToCreate,
            "TapeBarcodePrefix" => TapeBarcodePrefix,
            "TapeSizeInBytes" => TapeSizeInBytes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tapes(
    ClientToken,
    GatewayARN,
    NumTapesToCreate,
    TapeBarcodePrefix,
    TapeSizeInBytes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "CreateTapes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken,
                    "GatewayARN" => GatewayARN,
                    "NumTapesToCreate" => NumTapesToCreate,
                    "TapeBarcodePrefix" => TapeBarcodePrefix,
                    "TapeSizeInBytes" => TapeSizeInBytes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_automatic_tape_creation_policy(gateway_arn)
    delete_automatic_tape_creation_policy(gateway_arn, params::Dict{String,<:Any})

Deletes the automatic tape creation policy of a gateway. If you delete this policy, new
virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway
in your request to remove the policy.

# Arguments
- `gateway_arn`:

"""
function delete_automatic_tape_creation_policy(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DeleteAutomaticTapeCreationPolicy",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_automatic_tape_creation_policy(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteAutomaticTapeCreationPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_bandwidth_rate_limit(bandwidth_type, gateway_arn)
    delete_bandwidth_rate_limit(bandwidth_type, gateway_arn, params::Dict{String,<:Any})

Deletes the bandwidth rate limits of a gateway. You can delete either the upload and
download bandwidth rate limit, or you can delete both. If you delete only one of the
limits, the other limit remains unchanged. To specify which gateway to work with, use the
Amazon Resource Name (ARN) of the gateway in your request. This operation is supported only
for the stored volume, cached volume, and tape gateway types.

# Arguments
- `bandwidth_type`: One of the BandwidthType values that indicates the gateway bandwidth
  rate limit to delete. Valid Values: UPLOAD | DOWNLOAD | ALL
- `gateway_arn`:

"""
function delete_bandwidth_rate_limit(
    BandwidthType, GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DeleteBandwidthRateLimit",
        Dict{String,Any}("BandwidthType" => BandwidthType, "GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_bandwidth_rate_limit(
    BandwidthType,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteBandwidthRateLimit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BandwidthType" => BandwidthType, "GatewayARN" => GatewayARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_chap_credentials(initiator_name, target_arn)
    delete_chap_credentials(initiator_name, target_arn, params::Dict{String,<:Any})

Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified
iSCSI target and initiator pair. This operation is supported in volume and tape gateway
types.

# Arguments
- `initiator_name`: The iSCSI initiator that connects to the target.
- `target_arn`: The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
  DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN for specified
  VolumeARN.

"""
function delete_chap_credentials(
    InitiatorName, TargetARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DeleteChapCredentials",
        Dict{String,Any}("InitiatorName" => InitiatorName, "TargetARN" => TargetARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_chap_credentials(
    InitiatorName,
    TargetARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteChapCredentials",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InitiatorName" => InitiatorName, "TargetARN" => TargetARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_file_share(file_share_arn)
    delete_file_share(file_share_arn, params::Dict{String,<:Any})

Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File
Gateways.

# Arguments
- `file_share_arn`: The Amazon Resource Name (ARN) of the file share to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceDelete"`: If this value is set to true, the operation deletes a file share
  immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share
  is not deleted until all data is uploaded to Amazon Web Services. This process aborts the
  data upload process, and the file share enters the FORCE_DELETING status. Valid Values:
  true | false
"""
function delete_file_share(FileShareARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DeleteFileShare",
        Dict{String,Any}("FileShareARN" => FileShareARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_file_share(
    FileShareARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteFileShare",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FileShareARN" => FileShareARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_gateway(gateway_arn)
    delete_gateway(gateway_arn, params::Dict{String,<:Any})

Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN)
of the gateway in your request. The operation deletes the gateway; however, it does not
delete the gateway virtual machine (VM) from your host computer. After you delete a
gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not
deleted upon deleting the gateway, however, pending snapshots will not complete. After you
delete a gateway, your next step is to remove it from your environment.  You no longer pay
software charges after the gateway is deleted; however, your existing Amazon EBS snapshots
persist and you will continue to be billed for these snapshots. You can choose to remove
all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription.  If you
prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the
Amazon EC2 console. For more information, see the Storage Gateway detail page.

# Arguments
- `gateway_arn`:

"""
function delete_gateway(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DeleteGateway",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_gateway(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot_schedule(volume_arn)
    delete_snapshot_schedule(volume_arn, params::Dict{String,<:Any})

Deletes a snapshot of a volume. You can take snapshots of your gateway volumes on a
scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a
volume. For more information, see Backing up your volumes. In the DeleteSnapshotSchedule
request, you identify the volume by providing its Amazon Resource Name (ARN). This
operation is only supported for cached volume gateway types.  To list or delete a snapshot,
you must use the Amazon EC2 API. For more information, go to DescribeSnapshots in the
Amazon Elastic Compute Cloud API Reference.

# Arguments
- `volume_arn`: The volume which snapshot schedule to delete.

"""
function delete_snapshot_schedule(
    VolumeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DeleteSnapshotSchedule",
        Dict{String,Any}("VolumeARN" => VolumeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot_schedule(
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteSnapshotSchedule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARN" => VolumeARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tape(gateway_arn, tape_arn)
    delete_tape(gateway_arn, tape_arn, params::Dict{String,<:Any})

Deletes the specified virtual tape. This operation is only supported in the tape gateway
type.

# Arguments
- `gateway_arn`: The unique Amazon Resource Name (ARN) of the gateway that the virtual tape
  to delete is associated with. Use the ListGateways operation to return a list of gateways
  for your account and Amazon Web Services Region.
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BypassGovernanceRetention"`: Set to TRUE to delete an archived tape that belongs to a
  custom pool with tape retention lock. Only archived tapes with tape retention lock set to
  governance can be deleted. Archived tapes with tape retention lock set to compliance can't
  be deleted.
"""
function delete_tape(
    GatewayARN, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DeleteTape",
        Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tape(
    GatewayARN,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteTape",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tape_archive(tape_arn)
    delete_tape_archive(tape_arn, params::Dict{String,<:Any})

Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is
only supported in the tape gateway type.

# Arguments
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual
  tape shelf (VTS).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BypassGovernanceRetention"`: Set to TRUE to delete an archived tape that belongs to a
  custom pool with tape retention lock. Only archived tapes with tape retention lock set to
  governance can be deleted. Archived tapes with tape retention lock set to compliance can't
  be deleted.
"""
function delete_tape_archive(TapeARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DeleteTapeArchive",
        Dict{String,Any}("TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tape_archive(
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteTapeArchive",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TapeARN" => TapeARN), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tape_pool(pool_arn)
    delete_tape_pool(pool_arn, params::Dict{String,<:Any})

Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in
the pool and if there are no automatic tape creation policies that reference the custom
tape pool.

# Arguments
- `pool_arn`: The Amazon Resource Name (ARN) of the custom tape pool to delete.

"""
function delete_tape_pool(PoolARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DeleteTapePool",
        Dict{String,Any}("PoolARN" => PoolARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tape_pool(
    PoolARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteTapePool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolARN" => PoolARN), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_volume(volume_arn)
    delete_volume(volume_arn, params::Dict{String,<:Any})

Deletes the specified storage volume that you previously created using the
CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This operation is only supported in
the cached volume and stored volume types. For stored volume gateways, the local disk that
was configured as the storage volume is not deleted. You can reuse the local disk to create
another storage volume. Before you delete a volume, make sure there are no iSCSI
connections to the volume you are deleting. You should also make sure there is no snapshot
in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query
snapshots on the volume you are deleting and check the snapshot status. For more
information, go to DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference. In
the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want
to delete.

# Arguments
- `volume_arn`: The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
  to return a list of gateway volumes.

"""
function delete_volume(VolumeARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DeleteVolume",
        Dict{String,Any}("VolumeARN" => VolumeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_volume(
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DeleteVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARN" => VolumeARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_availability_monitor_test(gateway_arn)
    describe_availability_monitor_test(gateway_arn, params::Dict{String,<:Any})

Returns information about the most recent high availability monitoring test that was
performed on the host in a cluster. If a test isn't performed, the status and start time in
the response would be null.

# Arguments
- `gateway_arn`:

"""
function describe_availability_monitor_test(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeAvailabilityMonitorTest",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_availability_monitor_test(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeAvailabilityMonitorTest",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_bandwidth_rate_limit(gateway_arn)
    describe_bandwidth_rate_limit(gateway_arn, params::Dict{String,<:Any})

Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which
means no bandwidth rate limiting is in effect. This operation is supported only for the
stored volume, cached volume, and tape gateway types. To describe bandwidth rate limits for
S3 file gateways, use DescribeBandwidthRateLimitSchedule. This operation returns a value
for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway,
then this operation returns only the gateway ARN in the response body. To specify which
gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.

# Arguments
- `gateway_arn`:

"""
function describe_bandwidth_rate_limit(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeBandwidthRateLimit",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_bandwidth_rate_limit(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeBandwidthRateLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_bandwidth_rate_limit_schedule(gateway_arn)
    describe_bandwidth_rate_limit_schedule(gateway_arn, params::Dict{String,<:Any})

 Returns information about the bandwidth rate limit schedule of a gateway. By default,
gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting
is in effect. This operation is supported only for volume, tape and S3 file gateways. FSx
file gateways do not support bandwidth rate limits. This operation returns information
about a gateway's bandwidth rate limit schedule. A bandwidth rate limit schedule consists
of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a
period of time on one or more days of the week, during which bandwidth rate limits are
specified for uploading, downloading, or both.   A bandwidth rate limit interval consists
of one or more days of the week, a start hour and minute, an ending hour and minute, and
bandwidth rate limits for uploading and downloading   If no bandwidth rate limit schedule
intervals are set for the gateway, this operation returns an empty response. To specify
which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your
request.

# Arguments
- `gateway_arn`:

"""
function describe_bandwidth_rate_limit_schedule(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeBandwidthRateLimitSchedule",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_bandwidth_rate_limit_schedule(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeBandwidthRateLimitSchedule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cache(gateway_arn)
    describe_cache(gateway_arn, params::Dict{String,<:Any})

Returns information about the cache of a gateway. This operation is only supported in the
cached volume, tape, and file gateway types. The response includes disk IDs that are
configured as cache, and it includes the amount of cache allocated and used.

# Arguments
- `gateway_arn`:

"""
function describe_cache(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DescribeCache",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cache(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeCache",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cachedi_scsivolumes(volume_arns)
    describe_cachedi_scsivolumes(volume_arns, params::Dict{String,<:Any})

Returns a description of the gateway volumes specified in the request. This operation is
only supported in the cached volume gateway types. The list of gateway volumes in the
request must be from one gateway. In the response, Storage Gateway returns volume
information sorted by volume Amazon Resource Name (ARN).

# Arguments
- `volume_arns`: An array of strings where each string represents the Amazon Resource Name
  (ARN) of a cached volume. All of the specified cached volumes must be from the same
  gateway. Use ListVolumes to get volume ARNs for a gateway.

"""
function describe_cachedi_scsivolumes(
    VolumeARNs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeCachediSCSIVolumes",
        Dict{String,Any}("VolumeARNs" => VolumeARNs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cachedi_scsivolumes(
    VolumeARNs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeCachediSCSIVolumes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARNs" => VolumeARNs), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_chap_credentials(target_arn)
    describe_chap_credentials(target_arn, params::Dict{String,<:Any})

Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
information for a specified iSCSI target, one for each target-initiator pair. This
operation is supported in the volume and tape gateway types.

# Arguments
- `target_arn`: The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
  DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN for specified
  VolumeARN.

"""
function describe_chap_credentials(
    TargetARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeChapCredentials",
        Dict{String,Any}("TargetARN" => TargetARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_chap_credentials(
    TargetARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeChapCredentials",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TargetARN" => TargetARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_file_system_associations(file_system_association_arnlist)
    describe_file_system_associations(file_system_association_arnlist, params::Dict{String,<:Any})

Gets the file system association information. This operation is only supported for FSx File
Gateways.

# Arguments
- `file_system_association_arnlist`: An array containing the Amazon Resource Name (ARN) of
  each file system association to be described.

"""
function describe_file_system_associations(
    FileSystemAssociationARNList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeFileSystemAssociations",
        Dict{String,Any}("FileSystemAssociationARNList" => FileSystemAssociationARNList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_file_system_associations(
    FileSystemAssociationARNList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeFileSystemAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FileSystemAssociationARNList" => FileSystemAssociationARNList
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_gateway_information(gateway_arn)
    describe_gateway_information(gateway_arn, params::Dict{String,<:Any})

Returns metadata about a gateway such as its name, network interfaces, time zone, status,
and software version. To specify which gateway to describe, use the Amazon Resource Name
(ARN) of the gateway in your request.

# Arguments
- `gateway_arn`:

"""
function describe_gateway_information(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeGatewayInformation",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_gateway_information(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeGatewayInformation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_maintenance_start_time(gateway_arn)
    describe_maintenance_start_time(gateway_arn, params::Dict{String,<:Any})

Returns your gateway's maintenance window schedule information, with values for monthly or
weekly cadence, specific day and time to begin maintenance, and which types of updates to
apply. Time values returned are for the gateway's time zone.

# Arguments
- `gateway_arn`:

"""
function describe_maintenance_start_time(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeMaintenanceStartTime",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_maintenance_start_time(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeMaintenanceStartTime",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_nfsfile_shares(file_share_arnlist)
    describe_nfsfile_shares(file_share_arnlist, params::Dict{String,<:Any})

Gets a description for one or more Network File System (NFS) file shares from an S3 File
Gateway. This operation is only supported for S3 File Gateways.

# Arguments
- `file_share_arnlist`: An array containing the Amazon Resource Name (ARN) of each file
  share to be described.

"""
function describe_nfsfile_shares(
    FileShareARNList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeNFSFileShares",
        Dict{String,Any}("FileShareARNList" => FileShareARNList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_nfsfile_shares(
    FileShareARNList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeNFSFileShares",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("FileShareARNList" => FileShareARNList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_smbfile_shares(file_share_arnlist)
    describe_smbfile_shares(file_share_arnlist, params::Dict{String,<:Any})

Gets a description for one or more Server Message Block (SMB) file shares from a S3 File
Gateway. This operation is only supported for S3 File Gateways.

# Arguments
- `file_share_arnlist`: An array containing the Amazon Resource Name (ARN) of each file
  share to be described.

"""
function describe_smbfile_shares(
    FileShareARNList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeSMBFileShares",
        Dict{String,Any}("FileShareARNList" => FileShareARNList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_smbfile_shares(
    FileShareARNList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeSMBFileShares",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("FileShareARNList" => FileShareARNList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_smbsettings(gateway_arn)
    describe_smbsettings(gateway_arn, params::Dict{String,<:Any})

Gets a description of a Server Message Block (SMB) file share settings from a file gateway.
This operation is only supported for file gateways.

# Arguments
- `gateway_arn`:

"""
function describe_smbsettings(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeSMBSettings",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_smbsettings(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeSMBSettings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshot_schedule(volume_arn)
    describe_snapshot_schedule(volume_arn, params::Dict{String,<:Any})

Describes the snapshot schedule for the specified gateway volume. The snapshot schedule
information includes intervals at which snapshots are automatically initiated on the
volume. This operation is only supported in the cached volume and stored volume types.

# Arguments
- `volume_arn`: The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
  to return a list of gateway volumes.

"""
function describe_snapshot_schedule(
    VolumeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeSnapshotSchedule",
        Dict{String,Any}("VolumeARN" => VolumeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_snapshot_schedule(
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeSnapshotSchedule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARN" => VolumeARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_storedi_scsivolumes(volume_arns)
    describe_storedi_scsivolumes(volume_arns, params::Dict{String,<:Any})

Returns the description of the gateway volumes specified in the request. The list of
gateway volumes in the request must be from one gateway. In the response, Storage Gateway
returns volume information sorted by volume ARNs. This operation is only supported in
stored volume gateway type.

# Arguments
- `volume_arns`: An array of strings where each string represents the Amazon Resource Name
  (ARN) of a stored volume. All of the specified stored volumes must be from the same
  gateway. Use ListVolumes to get volume ARNs for a gateway.

"""
function describe_storedi_scsivolumes(
    VolumeARNs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeStorediSCSIVolumes",
        Dict{String,Any}("VolumeARNs" => VolumeARNs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_storedi_scsivolumes(
    VolumeARNs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeStorediSCSIVolumes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARNs" => VolumeARNs), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tape_archives()
    describe_tape_archives(params::Dict{String,<:Any})

Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This
operation is only supported in the tape gateway type. If a specific TapeARN is not
specified, Storage Gateway returns a description of all virtual tapes found in the VTS
associated with your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the number of virtual tapes described be limited to the
  specified number.
- `"Marker"`: An opaque string that indicates the position at which to begin describing
  virtual tapes.
- `"TapeARNs"`: Specifies one or more unique Amazon Resource Names (ARNs) that represent
  the virtual tapes you want to describe.
"""
function describe_tape_archives(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DescribeTapeArchives"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_tape_archives(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeTapeArchives",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tape_recovery_points(gateway_arn)
    describe_tape_recovery_points(gateway_arn, params::Dict{String,<:Any})

Returns a list of virtual tape recovery points that are available for the specified tape
gateway. A recovery point is a point-in-time view of a virtual tape at which all the data
on the virtual tape is consistent. If your gateway crashes, virtual tapes that have
recovery points can be recovered to a new gateway. This operation is only supported in the
tape gateway type.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the number of virtual tape recovery points that are described
  be limited to the specified number.
- `"Marker"`: An opaque string that indicates the position at which to begin describing the
  virtual tape recovery points.
"""
function describe_tape_recovery_points(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeTapeRecoveryPoints",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_tape_recovery_points(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeTapeRecoveryPoints",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tapes(gateway_arn)
    describe_tapes(gateway_arn, params::Dict{String,<:Any})

Returns a description of virtual tapes that correspond to the specified Amazon Resource
Names (ARNs). If TapeARN is not specified, returns a description of the virtual tapes
associated with the specified gateway. This operation is only supported for the tape
gateway type. The operation supports pagination. By default, the operation returns a
maximum of up to 100 tapes. You can optionally specify the Limit field in the body to limit
the number of tapes in the response. If the number of tapes returned in the response is
truncated, the response includes a Marker field. You can use this Marker value in your
subsequent request to retrieve the next set of tapes.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the number of virtual tapes described be limited to the
  specified number.  Amazon Web Services may impose its own limit, if this field is not set.
- `"Marker"`: A marker value, obtained in a previous call to DescribeTapes. This marker
  indicates which page of results to retrieve. If not specified, the first page of results is
  retrieved.
- `"TapeARNs"`: Specifies one or more unique Amazon Resource Names (ARNs) that represent
  the virtual tapes you want to describe. If this parameter is not specified, Tape gateway
  returns a description of all virtual tapes associated with the specified gateway.
"""
function describe_tapes(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DescribeTapes",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_tapes(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeTapes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_upload_buffer(gateway_arn)
    describe_upload_buffer(gateway_arn, params::Dict{String,<:Any})

Returns information about the upload buffer of a gateway. This operation is supported for
the stored volume, cached volume, and tape gateway types. The response includes disk IDs
that are configured as upload buffer space, and it includes the amount of upload buffer
space allocated and used.

# Arguments
- `gateway_arn`:

"""
function describe_upload_buffer(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeUploadBuffer",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_upload_buffer(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeUploadBuffer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vtldevices(gateway_arn)
    describe_vtldevices(gateway_arn, params::Dict{String,<:Any})

Returns a description of virtual tape library (VTL) devices for the specified tape gateway.
In the response, Storage Gateway returns VTL device information. This operation is only
supported in the tape gateway type.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the number of VTL devices described be limited to the specified
  number.
- `"Marker"`: An opaque string that indicates the position at which to begin describing the
  VTL devices.
- `"VTLDeviceARNs"`: An array of strings, where each string represents the Amazon Resource
  Name (ARN) of a VTL device.  All of the specified VTL devices must be from the same
  gateway. If no VTL devices are specified, the result will contain all devices on the
  specified gateway.
"""
function describe_vtldevices(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DescribeVTLDevices",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vtldevices(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeVTLDevices",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_working_storage(gateway_arn)
    describe_working_storage(gateway_arn, params::Dict{String,<:Any})

Returns information about the working storage of a gateway. This operation is only
supported in the stored volumes gateway type. This operation is deprecated in cached
volumes API version (20120630). Use DescribeUploadBuffer instead.  Working storage is also
referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add
upload buffer to a stored volume gateway.  The response includes disk IDs that are
configured as working storage, and it includes the amount of working storage allocated and
used.

# Arguments
- `gateway_arn`:

"""
function describe_working_storage(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DescribeWorkingStorage",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_working_storage(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DescribeWorkingStorage",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_volume(volume_arn)
    detach_volume(volume_arn, params::Dict{String,<:Any})

Disconnects a volume from an iSCSI connection and then detaches the volume from the
specified gateway. Detaching and attaching a volume enables you to recover your data from
one gateway to a different gateway without creating a snapshot. It also makes it easier to
move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2
instance. This operation is only supported in the volume gateway type.

# Arguments
- `volume_arn`: The Amazon Resource Name (ARN) of the volume to detach from the gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceDetach"`: Set to true to forcibly remove the iSCSI connection of the target volume
  and detach the volume. The default is false. If this value is set to false, you must
  manually disconnect the iSCSI connection from the target volume. Valid Values: true | false
"""
function detach_volume(VolumeARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DetachVolume",
        Dict{String,Any}("VolumeARN" => VolumeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_volume(
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DetachVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARN" => VolumeARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_gateway(gateway_arn)
    disable_gateway(gateway_arn, params::Dict{String,<:Any})

Disables a tape gateway when the gateway is no longer functioning. For example, if your
gateway VM is damaged, you can disable the gateway so you can recover virtual tapes. Use
this operation for a tape gateway that is not reachable or not functioning. This operation
is only supported in the tape gateway type.  After a gateway is disabled, it cannot be
enabled.

# Arguments
- `gateway_arn`:

"""
function disable_gateway(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "DisableGateway",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_gateway(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DisableGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_file_system(file_system_association_arn)
    disassociate_file_system(file_system_association_arn, params::Dict{String,<:Any})

Disassociates an Amazon FSx file system from the specified gateway. After the
disassociation process finishes, the gateway can no longer access the Amazon FSx file
system. This operation is only supported in the FSx File Gateway type.

# Arguments
- `file_system_association_arn`: The Amazon Resource Name (ARN) of the file system
  association to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceDelete"`: If this value is set to true, the operation disassociates an Amazon FSx
  file system immediately. It ends all data uploads to the file system, and the file system
  association enters the FORCE_DELETING status. If this value is set to false, the Amazon FSx
  file system does not disassociate until all data is uploaded.
"""
function disassociate_file_system(
    FileSystemAssociationARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "DisassociateFileSystem",
        Dict{String,Any}("FileSystemAssociationARN" => FileSystemAssociationARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_file_system(
    FileSystemAssociationARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "DisassociateFileSystem",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FileSystemAssociationARN" => FileSystemAssociationARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    join_domain(domain_name, gateway_arn, password, user_name)
    join_domain(domain_name, gateway_arn, password, user_name, params::Dict{String,<:Any})

Adds a file gateway to an Active Directory domain. This operation is only supported for
file gateways that support the SMB file protocol.  Joining a domain creates an Active
Directory computer account in the default organizational unit, using the gateway's Gateway
ID as the account name (for example, SGW-1234ADE). If your Active Directory environment
requires that you pre-stage accounts to facilitate the join domain process, you will need
to create this account ahead of time. To create the gateway's computer account in an
organizational unit other than the default, you must specify the organizational unit when
joining the domain.

# Arguments
- `domain_name`: The name of the domain that you want the gateway to join.
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
  operation to return a list of gateways for your account and Amazon Web Services Region.
- `password`: Sets the password of the user who has permission to add the gateway to the
  Active Directory domain.
- `user_name`: Sets the user name of user who has permission to add the gateway to the
  Active Directory domain. The domain user account should be enabled to join computers to the
  domain. For example, you can use the domain administrator account or an account with
  delegated permissions to join computers to the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DomainControllers"`: List of IPv4 addresses, NetBIOS names, or host names of your
  domain server. If you need to specify the port number include it after the colon (“:”).
  For example, mydc.mydomain.com:389.
- `"OrganizationalUnit"`: The organizational unit (OU) is a container in an Active
  Directory that can hold users, groups, computers, and other OUs and this parameter
  specifies the OU that the gateway will join within the AD domain.
- `"TimeoutInSeconds"`: Specifies the time in seconds, in which the JoinDomain operation
  must complete. The default is 20 seconds.
"""
function join_domain(
    DomainName,
    GatewayARN,
    Password,
    UserName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "JoinDomain",
        Dict{String,Any}(
            "DomainName" => DomainName,
            "GatewayARN" => GatewayARN,
            "Password" => Password,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function join_domain(
    DomainName,
    GatewayARN,
    Password,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "JoinDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DomainName" => DomainName,
                    "GatewayARN" => GatewayARN,
                    "Password" => Password,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_automatic_tape_creation_policies()
    list_automatic_tape_creation_policies(params::Dict{String,<:Any})

Lists the automatic tape creation policies for a gateway. If there are no automatic tape
creation policies for the gateway, it returns an empty list. This operation is only
supported for tape gateways.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayARN"`:
"""
function list_automatic_tape_creation_policies(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListAutomaticTapeCreationPolicies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_automatic_tape_creation_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListAutomaticTapeCreationPolicies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_file_shares()
    list_file_shares(params::Dict{String,<:Any})

Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares
that belong to the calling Amazon Web Services account. This operation is only supported
for S3 File Gateways.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayARN"`: The Amazon Resource Name (ARN) of the gateway whose file shares you want
  to list. If this field is not present, all file shares under your account are listed.
- `"Limit"`: The maximum number of file shares to return in the response. The value must be
  an integer with a value greater than zero. Optional.
- `"Marker"`: Opaque pagination token returned from a previous ListFileShares operation. If
  present, Marker specifies where to continue the list from after a previous call to
  ListFileShares. Optional.
"""
function list_file_shares(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListFileShares"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_file_shares(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListFileShares", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_file_system_associations()
    list_file_system_associations(params::Dict{String,<:Any})

Gets a list of FileSystemAssociationSummary objects. Each object contains a summary of a
file system association. This operation is only supported for FSx File Gateways.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayARN"`:
- `"Limit"`: The maximum number of file system associations to return in the response. If
  present, Limit must be an integer with a value greater than zero. Optional.
- `"Marker"`: Opaque pagination token returned from a previous ListFileSystemAssociations
  operation. If present, Marker specifies where to continue the list from after a previous
  call to ListFileSystemAssociations. Optional.
"""
function list_file_system_associations(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListFileSystemAssociations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_file_system_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListFileSystemAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_gateways()
    list_gateways(params::Dict{String,<:Any})

Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region
specified in the request. The returned list is ordered by gateway Amazon Resource Name
(ARN). By default, the operation returns a maximum of 100 gateways. This operation supports
pagination that allows you to optionally reduce the number of gateways returned in a
response. If you have more gateways than are returned in a response (that is, the response
returns only a truncated list of your gateways), the response contains a marker that you
can specify in your next request to fetch the next page of gateways.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the list of gateways returned be limited to the specified
  number of items.
- `"Marker"`: An opaque string that indicates the position at which to begin the returned
  list of gateways.
"""
function list_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListGateways", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_local_disks(gateway_arn)
    list_local_disks(gateway_arn, params::Dict{String,<:Any})

Returns a list of the gateway's local disks. To specify which gateway to describe, you use
the Amazon Resource Name (ARN) of the gateway in the body of the request. The request
returns a list of all disks, specifying which are configured as working storage, cache
storage, or stored volume or not configured at all. The response includes a DiskStatus
field. This field can have a value of present (the disk is available to use), missing (the
disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a
disk that has incorrect metadata or the disk content is corrupted).

# Arguments
- `gateway_arn`:

"""
function list_local_disks(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListLocalDisks",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_local_disks(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ListLocalDisks",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags that have been added to the specified resource. This operation is supported
in storage gateways of all types.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to list
  tags.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies that the list of tags returned be limited to the specified number of
  items.
- `"Marker"`: An opaque string that indicates the position at which to begin returning the
  list of tags.
"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tape_pools()
    list_tape_pools(params::Dict{String,<:Any})

Lists custom tape pools. You specify custom tape pools to list by specifying one or more
custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN,
the operation lists all custom tape pools. This operation supports pagination. You can
optionally specify the Limit parameter in the body to limit the number of tape pools in the
response. If the number of tape pools returned in the response is truncated, the response
includes a Marker element that you can use in your subsequent request to retrieve the next
set of tape pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: An optional number limit for the tape pools in the list returned by this call.
- `"Marker"`: A string that indicates the position at which to begin the returned list of
  tape pools.
- `"PoolARNs"`: The Amazon Resource Name (ARN) of each of the custom tape pools you want to
  list. If you don't specify a custom tape pool ARN, the response lists all custom tape
  pools.
"""
function list_tape_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListTapePools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_tape_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListTapePools", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tapes()
    list_tapes(params::Dict{String,<:Any})

Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).
You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs).
If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and
VTS. This operation supports pagination. By default, the operation returns a maximum of up
to 100 tapes. You can optionally specify the Limit parameter in the body to limit the
number of tapes in the response. If the number of tapes returned in the response is
truncated, the response includes a Marker element that you can use in your subsequent
request to retrieve the next set of tapes. This operation is only supported in the tape
gateway type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: An optional number limit for the tapes in the list returned by this call.
- `"Marker"`: A string that indicates the position at which to begin the returned list of
  tapes.
- `"TapeARNs"`:
"""
function list_tapes(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListTapes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_tapes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListTapes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_volume_initiators(volume_arn)
    list_volume_initiators(volume_arn, params::Dict{String,<:Any})

Lists iSCSI initiators that are connected to a volume. You can use this operation to
determine whether a volume is being used or not. This operation is only supported in the
cached volume and stored volume gateway types.

# Arguments
- `volume_arn`: The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
  to return a list of gateway volumes for the gateway.

"""
function list_volume_initiators(
    VolumeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListVolumeInitiators",
        Dict{String,Any}("VolumeARN" => VolumeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_volume_initiators(
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ListVolumeInitiators",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeARN" => VolumeARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_volume_recovery_points(gateway_arn)
    list_volume_recovery_points(gateway_arn, params::Dict{String,<:Any})

Lists the recovery points for a specified gateway. This operation is only supported in the
cached volume gateway type. Each cache volume has one recovery point. A volume recovery
point is a point in time at which all data of the volume is consistent and from which you
can create a snapshot or clone a new cached volume from a source volume. To create a
snapshot from a volume recovery point use the CreateSnapshotFromVolumeRecoveryPoint
operation.

# Arguments
- `gateway_arn`:

"""
function list_volume_recovery_points(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListVolumeRecoveryPoints",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_volume_recovery_points(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ListVolumeRecoveryPoints",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_volumes()
    list_volumes(params::Dict{String,<:Any})

Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response
includes only the volume ARNs. If you want additional volume information, use the
DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes API. The operation supports
pagination. By default, the operation returns a maximum of up to 100 volumes. You can
optionally specify the Limit field in the body to limit the number of volumes in the
response. If the number of volumes returned in the response is truncated, the response
includes a Marker field. You can use this Marker value in your subsequent request to
retrieve the next set of volumes. This operation is only supported in the cached volume and
stored volume gateway types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayARN"`:
- `"Limit"`: Specifies that the list of volumes returned be limited to the specified number
  of items.
- `"Marker"`: A string that indicates the position at which to begin the returned list of
  volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.
"""
function list_volumes(; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ListVolumes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_volumes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "ListVolumes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    notify_when_uploaded(file_share_arn)
    notify_when_uploaded(file_share_arn, params::Dict{String,<:Any})

Sends you notification through CloudWatch Events when all files written to your file share
have been uploaded to Amazon S3. Storage Gateway can send a notification through Amazon
CloudWatch Events when all files written to your file share up to that point in time have
been uploaded to Amazon S3. These files include files written to the file share up to the
time that you make a request for notification. When the upload is done, Storage Gateway
sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch
Events to send the notification through event targets such as Amazon SNS or Lambda
function. This operation is only supported for S3 File Gateways. For more information, see
Getting file upload notification in the Amazon S3 File Gateway User Guide.

# Arguments
- `file_share_arn`:

"""
function notify_when_uploaded(
    FileShareARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "NotifyWhenUploaded",
        Dict{String,Any}("FileShareARN" => FileShareARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function notify_when_uploaded(
    FileShareARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "NotifyWhenUploaded",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FileShareARN" => FileShareARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    refresh_cache(file_share_arn)
    refresh_cache(file_share_arn, params::Dict{String,<:Any})

Refreshes the cached inventory of objects for the specified file share. This operation
finds objects in the Amazon S3 bucket that were added, removed, or replaced since the
gateway last listed the bucket's contents and cached the results. This operation does not
import files into the S3 File Gateway cache storage. It only updates the cached inventory
to reflect changes in the inventory of the objects in the S3 bucket. This operation is only
supported in the S3 File Gateway types. You can subscribe to be notified through an Amazon
CloudWatch event when your RefreshCache operation completes. For more information, see
Getting notified about file operations in the Amazon S3 File Gateway User Guide. This
operation is Only supported for S3 File Gateways. When this API is called, it only
initiates the refresh operation. When the API call completes and returns a success code, it
doesn't necessarily mean that the file refresh has completed. You should use the
refresh-complete notification to determine that the operation has completed before you
check for new files on the gateway file share. You can subscribe to be notified through a
CloudWatch event when your RefreshCache operation completes. Throttle limit: This API is
asynchronous, so the gateway will accept no more than two refreshes at any time. We
recommend using the refresh-complete CloudWatch event notification before issuing
additional requests. For more information, see Getting notified about file operations in
the Amazon S3 File Gateway User Guide.    Wait at least 60 seconds between consecutive
RefreshCache API requests.   If you invoke the RefreshCache API when two requests are
already being processed, any new request will cause an InvalidGatewayRequestException error
because too many requests were sent to the server.     The S3 bucket name does not need to
be included when entering the list of folders in the FolderList parameter.  For more
information, see Getting notified about file operations in the Amazon S3 File Gateway User
Guide.

# Arguments
- `file_share_arn`: The Amazon Resource Name (ARN) of the file share you want to refresh.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FolderList"`: A comma-separated list of the paths of folders to refresh in the cache.
  The default is [\"/\"]. The default refreshes objects and folders at the root of the Amazon
  S3 bucket. If Recursive is set to true, the entire S3 bucket that the file share has access
  to is refreshed. Do not include / when specifying folder names. For example, you would
  specify samplefolder rather than samplefolder/.
- `"Recursive"`: A value that specifies whether to recursively refresh folders in the
  cache. The refresh includes folders that were in the cache the last time the gateway listed
  the folder's contents. If this value set to true, each folder that is listed in FolderList
  is recursively updated. Otherwise, subfolders listed in FolderList are not refreshed. Only
  objects that are in folders listed directly under FolderList are found and used for the
  update. The default is true. Valid Values: true | false
"""
function refresh_cache(FileShareARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "RefreshCache",
        Dict{String,Any}("FileShareARN" => FileShareARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function refresh_cache(
    FileShareARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "RefreshCache",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FileShareARN" => FileShareARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_arn, tag_keys)
    remove_tags_from_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource. This operation is supported in
storage gateways of all types.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource you want to remove the
  tags from.
- `tag_keys`: The keys of the tags you want to remove from the specified resource. A tag is
  composed of a key-value pair.

"""
function remove_tags_from_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "RemoveTagsFromResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_cache(gateway_arn)
    reset_cache(gateway_arn, params::Dict{String,<:Any})

Resets all cache disks that have encountered an error and makes the disks available for
reconfiguration as cache storage. If your cache disk encounters an error, the gateway
prevents read and write operations on virtual tapes in the gateway. For example, an error
can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the
gateway loses its cache storage. At this point, you can reconfigure the disks as cache
disks. This operation is only supported in the cached volume and tape types.  If the cache
disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data
can be lost. After you reset cache disks, there will be no configured cache disks left in
the gateway, so you must configure at least one new cache disk for your gateway to function
properly.

# Arguments
- `gateway_arn`:

"""
function reset_cache(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ResetCache",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_cache(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ResetCache",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve_tape_archive(gateway_arn, tape_arn)
    retrieve_tape_archive(gateway_arn, tape_arn, params::Dict{String,<:Any})

Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway.
Virtual tapes archived in the VTS are not associated with any gateway. However after a tape
is retrieved, it is associated with a gateway, even though it is also listed in the VTS,
that is, archive. This operation is only supported in the tape gateway type. Once a tape is
successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You
must archive the tape again before you can retrieve it to another gateway. This operation
is only supported in the tape gateway type.

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the gateway you want to retrieve the
  virtual tape to. Use the ListGateways operation to return a list of gateways for your
  account and Amazon Web Services Region. You retrieve archived virtual tapes to only one
  gateway and the gateway must be a tape gateway.
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
  the virtual tape shelf (VTS).

"""
function retrieve_tape_archive(
    GatewayARN, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "RetrieveTapeArchive",
        Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve_tape_archive(
    GatewayARN,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "RetrieveTapeArchive",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    retrieve_tape_recovery_point(gateway_arn, tape_arn)
    retrieve_tape_recovery_point(gateway_arn, tape_arn, params::Dict{String,<:Any})

Retrieves the recovery point for the specified virtual tape. This operation is only
supported in the tape gateway type. A recovery point is a point in time view of a virtual
tape at which all the data on the tape is consistent. If your gateway crashes, virtual
tapes that have recovery points can be recovered to a new gateway.  The virtual tape can be
retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be
retrieved to only a tape gateway. There is no charge for retrieving recovery points.

# Arguments
- `gateway_arn`:
- `tape_arn`: The Amazon Resource Name (ARN) of the virtual tape for which you want to
  retrieve the recovery point.

"""
function retrieve_tape_recovery_point(
    GatewayARN, TapeARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "RetrieveTapeRecoveryPoint",
        Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function retrieve_tape_recovery_point(
    GatewayARN,
    TapeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "RetrieveTapeRecoveryPoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "TapeARN" => TapeARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_local_console_password(gateway_arn, local_console_password)
    set_local_console_password(gateway_arn, local_console_password, params::Dict{String,<:Any})

Sets the password for your VM local console. When you log in to the local console for the
first time, you log in to the VM with the default credentials. We recommend that you set a
new password. You don't need to know the default password to set a new password.

# Arguments
- `gateway_arn`:
- `local_console_password`: The password you want to set for your VM local console.

"""
function set_local_console_password(
    GatewayARN, LocalConsolePassword; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "SetLocalConsolePassword",
        Dict{String,Any}(
            "GatewayARN" => GatewayARN, "LocalConsolePassword" => LocalConsolePassword
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_local_console_password(
    GatewayARN,
    LocalConsolePassword,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "SetLocalConsolePassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayARN" => GatewayARN,
                    "LocalConsolePassword" => LocalConsolePassword,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_smbguest_password(gateway_arn, password)
    set_smbguest_password(gateway_arn, password, params::Dict{String,<:Any})

Sets the password for the guest user smbguest. The smbguest user is the user when the
authentication method for the file share is set to GuestAccess. This operation only
supported for S3 File Gateways

# Arguments
- `gateway_arn`: The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share
  is associated with.
- `password`: The password that you want to set for your SMB server.

"""
function set_smbguest_password(
    GatewayARN, Password; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "SetSMBGuestPassword",
        Dict{String,Any}("GatewayARN" => GatewayARN, "Password" => Password);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_smbguest_password(
    GatewayARN,
    Password,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "SetSMBGuestPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayARN" => GatewayARN, "Password" => Password),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    shutdown_gateway(gateway_arn)
    shutdown_gateway(gateway_arn, params::Dict{String,<:Any})

Shuts down a Tape Gateway or Volume Gateway. To specify which gateway to shut down, use the
Amazon Resource Name (ARN) of the gateway in the body of your request.  This API action
cannot be used to shut down S3 File Gateway or FSx File Gateway.  The operation shuts down
the gateway service component running in the gateway's virtual machine (VM) and not the
host VM.  If you want to shut down the VM, it is recommended that you first shut down the
gateway component in the VM to avoid unpredictable conditions.  After the gateway is
shutdown, you cannot call any other API except StartGateway, DescribeGatewayInformation,
and ListGateways. For more information, see ActivateGateway. Your applications cannot read
from or write to the gateway's storage volumes, and there are no snapshots taken.  When you
make a shutdown request, you will get a 200 OK success response immediately. However, it
might take some time for the gateway to shut down. You can call the
DescribeGatewayInformation API to check the status. For more information, see
ActivateGateway.  If do not intend to use the gateway again, you must delete the gateway
(using DeleteGateway) to no longer pay software charges associated with the gateway.

# Arguments
- `gateway_arn`:

"""
function shutdown_gateway(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "ShutdownGateway",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function shutdown_gateway(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "ShutdownGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_availability_monitor_test(gateway_arn)
    start_availability_monitor_test(gateway_arn, params::Dict{String,<:Any})

Start a test that verifies that the specified gateway is configured for High Availability
monitoring in your host environment. This request only initiates the test and that a
successful response only indicates that the test was started. It doesn't indicate that the
test passed. For the status of the test, invoke the DescribeAvailabilityMonitorTest API.
Starting this test will cause your gateway to go offline for a brief period.

# Arguments
- `gateway_arn`:

"""
function start_availability_monitor_test(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "StartAvailabilityMonitorTest",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_availability_monitor_test(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "StartAvailabilityMonitorTest",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_gateway(gateway_arn)
    start_gateway(gateway_arn, params::Dict{String,<:Any})

Starts a gateway that you previously shut down (see ShutdownGateway). After the gateway
starts, you can then make other API calls, your applications can read from or write to the
gateway's storage volumes and you will be able to take snapshot backups.  When you make a
request, you will get a 200 OK success response immediately. However, it might take some
time for the gateway to be ready. You should call DescribeGatewayInformation and check the
status before making any additional API calls. For more information, see ActivateGateway.
To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in
your request.

# Arguments
- `gateway_arn`:

"""
function start_gateway(GatewayARN; aws_config::AbstractAWSConfig=current_aws_config())
    return storage_gateway(
        "StartGateway",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_gateway(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "StartGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_automatic_tape_creation_policy(automatic_tape_creation_rules, gateway_arn)
    update_automatic_tape_creation_policy(automatic_tape_creation_rules, gateway_arn, params::Dict{String,<:Any})

Updates the automatic tape creation policy of a gateway. Use this to update the policy with
a new set of automatic tape creation rules. This is only supported for tape gateways. By
default, there is no automatic tape creation policy.  A gateway can have only one automatic
tape creation policy.

# Arguments
- `automatic_tape_creation_rules`: An automatic tape creation policy consists of a list of
  automatic tape creation rules. The rules determine when and how to automatically create new
  tapes.
- `gateway_arn`:

"""
function update_automatic_tape_creation_policy(
    AutomaticTapeCreationRules,
    GatewayARN;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateAutomaticTapeCreationPolicy",
        Dict{String,Any}(
            "AutomaticTapeCreationRules" => AutomaticTapeCreationRules,
            "GatewayARN" => GatewayARN,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_automatic_tape_creation_policy(
    AutomaticTapeCreationRules,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateAutomaticTapeCreationPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AutomaticTapeCreationRules" => AutomaticTapeCreationRules,
                    "GatewayARN" => GatewayARN,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_bandwidth_rate_limit(gateway_arn)
    update_bandwidth_rate_limit(gateway_arn, params::Dict{String,<:Any})

Updates the bandwidth rate limits of a gateway. You can update both the upload and download
bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate
limit, the existing rate limit remains. This operation is supported only for the stored
volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file
gateways, use UpdateBandwidthRateLimitSchedule. By default, a gateway's bandwidth rate
limits are not set. If you don't set any limit, the gateway does not have any limitations
on its bandwidth usage and could potentially use the maximum available bandwidth. To
specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your
request.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AverageDownloadRateLimitInBitsPerSec"`: The average download bandwidth rate limit in
  bits per second.
- `"AverageUploadRateLimitInBitsPerSec"`: The average upload bandwidth rate limit in bits
  per second.
"""
function update_bandwidth_rate_limit(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateBandwidthRateLimit",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_bandwidth_rate_limit(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateBandwidthRateLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_bandwidth_rate_limit_schedule(bandwidth_rate_limit_intervals, gateway_arn)
    update_bandwidth_rate_limit_schedule(bandwidth_rate_limit_intervals, gateway_arn, params::Dict{String,<:Any})

 Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do
not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in
effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This
operation is supported for volume, tape, and S3 file gateways. S3 file gateways support
bandwidth rate limits for upload only. FSx file gateways do not support bandwidth rate
limits.

# Arguments
- `bandwidth_rate_limit_intervals`:  An array containing bandwidth rate limit schedule
  intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the
  array is empty.
- `gateway_arn`:

"""
function update_bandwidth_rate_limit_schedule(
    BandwidthRateLimitIntervals,
    GatewayARN;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateBandwidthRateLimitSchedule",
        Dict{String,Any}(
            "BandwidthRateLimitIntervals" => BandwidthRateLimitIntervals,
            "GatewayARN" => GatewayARN,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_bandwidth_rate_limit_schedule(
    BandwidthRateLimitIntervals,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateBandwidthRateLimitSchedule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BandwidthRateLimitIntervals" => BandwidthRateLimitIntervals,
                    "GatewayARN" => GatewayARN,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_chap_credentials(initiator_name, secret_to_authenticate_initiator, target_arn)
    update_chap_credentials(initiator_name, secret_to_authenticate_initiator, target_arn, params::Dict{String,<:Any})

Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified
iSCSI target. By default, a gateway does not have CHAP enabled; however, for added
security, you might use it. This operation is supported in the volume and tape gateway
types.  When you update CHAP credentials, all existing connections on the target are closed
and initiators must reconnect with the new credentials.

# Arguments
- `initiator_name`: The iSCSI initiator that connects to the target.
- `secret_to_authenticate_initiator`: The secret key that the initiator (for example, the
  Windows client) must provide to participate in mutual CHAP with the target.  The secret key
  must be between 12 and 16 bytes when encoded in UTF-8.
- `target_arn`: The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
  DescribeStorediSCSIVolumes operation to return the TargetARN for specified VolumeARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SecretToAuthenticateTarget"`: The secret key that the target must provide to
  participate in mutual CHAP with the initiator (e.g. Windows client). Byte constraints:
  Minimum bytes of 12. Maximum bytes of 16.  The secret key must be between 12 and 16 bytes
  when encoded in UTF-8.
"""
function update_chap_credentials(
    InitiatorName,
    SecretToAuthenticateInitiator,
    TargetARN;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateChapCredentials",
        Dict{String,Any}(
            "InitiatorName" => InitiatorName,
            "SecretToAuthenticateInitiator" => SecretToAuthenticateInitiator,
            "TargetARN" => TargetARN,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_chap_credentials(
    InitiatorName,
    SecretToAuthenticateInitiator,
    TargetARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateChapCredentials",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InitiatorName" => InitiatorName,
                    "SecretToAuthenticateInitiator" => SecretToAuthenticateInitiator,
                    "TargetARN" => TargetARN,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_file_system_association(file_system_association_arn)
    update_file_system_association(file_system_association_arn, params::Dict{String,<:Any})

Updates a file system association. This operation is only supported in the FSx File
Gateways.

# Arguments
- `file_system_association_arn`: The Amazon Resource Name (ARN) of the file system
  association that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for the audit
  logs.
- `"CacheAttributes"`:
- `"Password"`: The password of the user credential.
- `"UserName"`: The user name of the user credential that has permission to access the root
  share D of the Amazon FSx file system. The user account must belong to the Amazon FSx
  delegated admin user group.
"""
function update_file_system_association(
    FileSystemAssociationARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateFileSystemAssociation",
        Dict{String,Any}("FileSystemAssociationARN" => FileSystemAssociationARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_file_system_association(
    FileSystemAssociationARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateFileSystemAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FileSystemAssociationARN" => FileSystemAssociationARN),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_gateway_information(gateway_arn)
    update_gateway_information(gateway_arn, params::Dict{String,<:Any})

Updates a gateway's metadata, which includes the gateway's name, time zone, and metadata
cache size. To specify which gateway to update, use the Amazon Resource Name (ARN) of the
gateway in your request.  For gateways activated after September 2, 2015, the gateway's ARN
contains the gateway ID rather than the gateway name. However, changing the name of the
gateway has no effect on the gateway's ARN.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CloudWatchLogGroupARN"`: The Amazon Resource Name (ARN) of the Amazon CloudWatch log
  group that you want to use to monitor and log events in the gateway. For more information,
  see What is Amazon CloudWatch Logs?
- `"GatewayCapacity"`: Specifies the size of the gateway's metadata cache. This setting
  impacts gateway performance and hardware recommendations. For more information, see
  Performance guidance for gateways with multiple file shares in the Amazon S3 File Gateway
  User Guide.
- `"GatewayName"`:
- `"GatewayTimezone"`: A value that indicates the time zone of the gateway.
"""
function update_gateway_information(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateGatewayInformation",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_gateway_information(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateGatewayInformation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_gateway_software_now(gateway_arn)
    update_gateway_software_now(gateway_arn, params::Dict{String,<:Any})

Updates the gateway virtual machine (VM) software. The request immediately triggers the
software update.  When you make this request, you get a 200 OK success response
immediately. However, it might take some time for the update to complete. You can call
DescribeGatewayInformation to verify the gateway is in the STATE_RUNNING state.   A
software update forces a system restart of your gateway. You can minimize the chance of any
disruption to your applications by increasing your iSCSI Initiators' timeouts. For more
information about increasing iSCSI Initiator timeouts for Windows and Linux, see
Customizing your Windows iSCSI settings and Customizing your Linux iSCSI settings,
respectively.

# Arguments
- `gateway_arn`:

"""
function update_gateway_software_now(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateGatewaySoftwareNow",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_gateway_software_now(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateGatewaySoftwareNow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_maintenance_start_time(gateway_arn)
    update_maintenance_start_time(gateway_arn, params::Dict{String,<:Any})

Updates a gateway's maintenance window schedule, with settings for monthly or weekly
cadence, specific day and time to begin maintenance, and which types of updates to apply.
Time configuration uses the gateway's time zone. You can pass values for a complete
maintenance schedule, or update policy, or both. Previous values will persist for whichever
setting you choose not to modify. If an incomplete or invalid maintenance schedule is
passed, the entire request will be rejected with an error and no changes will occur. A
complete maintenance schedule must include values for both MinuteOfHour and HourOfDay, and
either DayOfMonth or DayOfWeek.  We recommend keeping maintenance updates turned on, except
in specific use cases where the brief disruptions caused by updating the gateway could
critically impact your deployment.

# Arguments
- `gateway_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DayOfMonth"`: The day of the month component of the maintenance start time represented
  as an ordinal number from 1 to 28, where 1 represents the first day of the month. It is not
  possible to set the maintenance schedule to start on days 29 through 31.
- `"DayOfWeek"`: The day of the week component of the maintenance start time week
  represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 represents
  Saturday.
- `"HourOfDay"`: The hour component of the maintenance start time represented as hh, where
  hh is the hour (00 to 23). The hour of the day is in the time zone of the gateway.
- `"MinuteOfHour"`: The minute component of the maintenance start time represented as mm,
  where mm is the minute (00 to 59). The minute of the hour is in the time zone of the
  gateway.
- `"SoftwareUpdatePreferences"`: A set of variables indicating the software update
  preferences for the gateway. Includes AutomaticUpdatePolicy field with the following
  inputs:  ALL_VERSIONS - Enables regular gateway maintenance updates.
  EMERGENCY_VERSIONS_ONLY - Disables regular gateway maintenance updates.
"""
function update_maintenance_start_time(
    GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateMaintenanceStartTime",
        Dict{String,Any}("GatewayARN" => GatewayARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_maintenance_start_time(
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateMaintenanceStartTime",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GatewayARN" => GatewayARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_nfsfile_share(file_share_arn)
    update_nfsfile_share(file_share_arn, params::Dict{String,<:Any})

Updates a Network File System (NFS) file share. This operation is only supported in S3 File
Gateways.  To leave a file share field unchanged, set the corresponding input field to
null.  Updates the following file share settings:   Default storage class for your S3
bucket   Metadata defaults for your S3 bucket   Allowed NFS clients for your file share
Squash settings   Write status of your file share

# Arguments
- `file_share_arn`: The Amazon Resource Name (ARN) of the file share to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for audit
  logs.
- `"CacheAttributes"`: Specifies refresh cache information for the file share.
- `"ClientList"`: The list of clients that are allowed to access the S3 File Gateway. The
  list must contain either valid IP addresses or valid CIDR blocks.
- `"DefaultStorageClass"`: The default storage class for objects put into an Amazon S3
  bucket by the S3 File Gateway. The default value is S3_STANDARD. Optional. Valid Values:
  S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
- `"FileShareName"`: The name of the file share. Optional.   FileShareName must be set if
  an S3 prefix name is set in LocationARN, or if an access point or access point alias is
  used.
- `"GuessMIMETypeEnabled"`: A value that enables guessing of the MIME type for uploaded
  objects based on file extensions. Set this value to true to enable MIME type guessing,
  otherwise set to false. The default value is true. Valid Values: true | false
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"NFSFileShareDefaults"`: The default values for the file share. Optional.
- `"NotificationPolicy"`: The notification policy of the file share. SettlingTimeInSeconds
  controls the number of seconds to wait after the last point in time a client wrote to a
  file before generating an ObjectUploaded notification. Because clients can make many small
  writes to files, it's best to set this parameter for as long as possible to avoid
  generating multiple notifications for the same file in a small time period.
  SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3,
  only the timing of the notification.  The following example sets NotificationPolicy on with
  SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The
  following example sets NotificationPolicy off.  {}
- `"ObjectACL"`: A value that sets the access control list (ACL) permission for objects in
  the S3 bucket that a S3 File Gateway puts objects into. The default value is private.
- `"ReadOnly"`: A value that sets the write status of a file share. Set this value to true
  to set the write status to read-only, otherwise set to false. Valid Values: true | false
- `"RequesterPays"`: A value that sets who pays the cost of the request and the cost
  associated with data download from the S3 bucket. If this value is set to true, the
  requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner
  always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket
  that backs the file share, so make sure that the configuration on the file share is the
  same as the S3 bucket configuration.  Valid Values: true | false
- `"Squash"`: The user mapped to anonymous user. Valid values are the following:
  RootSquash: Only root is mapped to anonymous user.    NoSquash: No one is mapped to
  anonymous user.    AllSquash: Everyone is mapped to anonymous user.
"""
function update_nfsfile_share(
    FileShareARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateNFSFileShare",
        Dict{String,Any}("FileShareARN" => FileShareARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_nfsfile_share(
    FileShareARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateNFSFileShare",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FileShareARN" => FileShareARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_smbfile_share(file_share_arn)
    update_smbfile_share(file_share_arn, params::Dict{String,<:Any})

Updates a Server Message Block (SMB) file share. This operation is only supported for S3
File Gateways.  To leave a file share field unchanged, set the corresponding input field to
null.   File gateways require Security Token Service (Amazon Web Services STS) to be
activated to enable you to create a file share. Make sure that Amazon Web Services STS is
activated in the Amazon Web Services Region you are creating your file gateway in. If
Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it.
For information about how to activate Amazon Web Services STS, see Activating and
deactivating Amazon Web Services STS in an Amazon Web Services Region in the Identity and
Access Management User Guide. File gateways don't support creating hard or symbolic links
on a file share.

# Arguments
- `file_share_arn`: The Amazon Resource Name (ARN) of the SMB file share that you want to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessBasedEnumeration"`: The files and folders on this share will only be visible to
  users with read access.
- `"AdminUserList"`: A list of users or groups in the Active Directory that have
  administrator rights to the file share. A group must be prefixed with the @ character.
  Acceptable formats include: DOMAINUser1, user1, @group1, and @DOMAINgroup1. Can only be set
  if Authentication is set to ActiveDirectory.
- `"AuditDestinationARN"`: The Amazon Resource Name (ARN) of the storage used for audit
  logs.
- `"CacheAttributes"`: Specifies refresh cache information for the file share.
- `"CaseSensitivity"`: The case of an object name in an Amazon S3 bucket. For
  ClientSpecified, the client determines the case sensitivity. For CaseSensitive, the gateway
  determines the case sensitivity. The default value is ClientSpecified.
- `"DefaultStorageClass"`: The default storage class for objects put into an Amazon S3
  bucket by the S3 File Gateway. The default value is S3_STANDARD. Optional. Valid Values:
  S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
- `"FileShareName"`: The name of the file share. Optional.   FileShareName must be set if
  an S3 prefix name is set in LocationARN, or if an access point or access point alias is
  used.
- `"GuessMIMETypeEnabled"`: A value that enables guessing of the MIME type for uploaded
  objects based on file extensions. Set this value to true to enable MIME type guessing,
  otherwise set to false. The default value is true. Valid Values: true | false
- `"InvalidUserList"`: A list of users or groups in the Active Directory that are not
  allowed to access the file share. A group must be prefixed with the @ character. Acceptable
  formats include: DOMAINUser1, user1, @group1, and @DOMAINgroup1. Can only be set if
  Authentication is set to ActiveDirectory.
- `"KMSEncrypted"`: Set to true to use Amazon S3 server-side encryption with your own KMS
  key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false
- `"KMSKey"`: The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
  for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs.
  This value can only be set when KMSEncrypted is true. Optional.
- `"NotificationPolicy"`: The notification policy of the file share. SettlingTimeInSeconds
  controls the number of seconds to wait after the last point in time a client wrote to a
  file before generating an ObjectUploaded notification. Because clients can make many small
  writes to files, it's best to set this parameter for as long as possible to avoid
  generating multiple notifications for the same file in a small time period.
  SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3,
  only the timing of the notification.  The following example sets NotificationPolicy on with
  SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The
  following example sets NotificationPolicy off.  {}
- `"ObjectACL"`: A value that sets the access control list (ACL) permission for objects in
  the S3 bucket that a S3 File Gateway puts objects into. The default value is private.
- `"OplocksEnabled"`: Specifies whether opportunistic locking is enabled for the SMB file
  share.  Enabling opportunistic locking on case-sensitive shares is not recommended for
  workloads that involve access to files with the same name in different case.  Valid Values:
  true | false
- `"ReadOnly"`: A value that sets the write status of a file share. Set this value to true
  to set write status to read-only, otherwise set to false. Valid Values: true | false
- `"RequesterPays"`: A value that sets who pays the cost of the request and the cost
  associated with data download from the S3 bucket. If this value is set to true, the
  requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner
  always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket
  that backs the file share, so make sure that the configuration on the file share is the
  same as the S3 bucket configuration.  Valid Values: true | false
- `"SMBACLEnabled"`: Set this value to true to enable access control list (ACL) on the SMB
  file share. Set it to false to map file and directory permissions to the POSIX permissions.
  For more information, see Using Microsoft Windows ACLs to control access to an SMB file
  share in the Storage Gateway User Guide. Valid Values: true | false
- `"ValidUserList"`: A list of users or groups in the Active Directory that are allowed to
  access the file share. A group must be prefixed with the @ character. Acceptable formats
  include: DOMAINUser1, user1, @group1, and @DOMAINgroup1. Can only be set if Authentication
  is set to ActiveDirectory.
"""
function update_smbfile_share(
    FileShareARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateSMBFileShare",
        Dict{String,Any}("FileShareARN" => FileShareARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_smbfile_share(
    FileShareARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSMBFileShare",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FileShareARN" => FileShareARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_smbfile_share_visibility(file_shares_visible, gateway_arn)
    update_smbfile_share_visibility(file_shares_visible, gateway_arn, params::Dict{String,<:Any})

Controls whether the shares on an S3 File Gateway are visible in a net view or browse list.
The operation is only supported for S3 File Gateways.

# Arguments
- `file_shares_visible`: The shares on this gateway appear when listing shares.
- `gateway_arn`:

"""
function update_smbfile_share_visibility(
    FileSharesVisible, GatewayARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateSMBFileShareVisibility",
        Dict{String,Any}(
            "FileSharesVisible" => FileSharesVisible, "GatewayARN" => GatewayARN
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_smbfile_share_visibility(
    FileSharesVisible,
    GatewayARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSMBFileShareVisibility",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FileSharesVisible" => FileSharesVisible, "GatewayARN" => GatewayARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_smblocal_groups(gateway_arn, smblocal_groups)
    update_smblocal_groups(gateway_arn, smblocal_groups, params::Dict{String,<:Any})

Updates the list of Active Directory users and groups that have special permissions for SMB
file shares on the gateway.

# Arguments
- `gateway_arn`:
- `smblocal_groups`: A list of Active Directory users and groups that you want to grant
  special permissions for SMB file shares on the gateway.

"""
function update_smblocal_groups(
    GatewayARN, SMBLocalGroups; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateSMBLocalGroups",
        Dict{String,Any}("GatewayARN" => GatewayARN, "SMBLocalGroups" => SMBLocalGroups);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_smblocal_groups(
    GatewayARN,
    SMBLocalGroups,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSMBLocalGroups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayARN" => GatewayARN, "SMBLocalGroups" => SMBLocalGroups
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_smbsecurity_strategy(gateway_arn, smbsecurity_strategy)
    update_smbsecurity_strategy(gateway_arn, smbsecurity_strategy, params::Dict{String,<:Any})

Updates the SMB security strategy level for an Amazon S3 file gateway. This action is only
supported for Amazon S3 file gateways.  For information about configuring this setting
using the Amazon Web Services console, see Setting a security level for your gateway in the
Amazon S3 File Gateway User Guide. A higher security strategy level can affect performance
of the gateway.

# Arguments
- `gateway_arn`:
- `smbsecurity_strategy`: Specifies the type of security strategy.  ClientSpecified: If you
  choose this option, requests are established based on what is negotiated by the client.
  This option is recommended when you want to maximize compatibility across different clients
  in your environment. Supported only for S3 File Gateway.  MandatorySigning: If you choose
  this option, File Gateway only allows connections from SMBv2 or SMBv3 clients that have
  signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows
  Server 2008 or newer.  MandatoryEncryption: If you choose this option, File Gateway only
  allows connections from SMBv3 clients that have encryption enabled. This option is
  recommended for environments that handle sensitive data. This option works with SMB clients
  on Microsoft Windows 8, Windows Server 2012 or newer.  MandatoryEncryptionNoAes128: If you
  choose this option, File Gateway only allows connections from SMBv3 clients that use
  256-bit AES encryption algorithms. 128-bit algorithms are not allowed. This option is
  recommended for environments that handle sensitive data. It works with SMB clients on
  Microsoft Windows 8, Windows Server 2012, or later.

"""
function update_smbsecurity_strategy(
    GatewayARN, SMBSecurityStrategy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateSMBSecurityStrategy",
        Dict{String,Any}(
            "GatewayARN" => GatewayARN, "SMBSecurityStrategy" => SMBSecurityStrategy
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_smbsecurity_strategy(
    GatewayARN,
    SMBSecurityStrategy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSMBSecurityStrategy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GatewayARN" => GatewayARN, "SMBSecurityStrategy" => SMBSecurityStrategy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_snapshot_schedule(recurrence_in_hours, start_at, volume_arn)
    update_snapshot_schedule(recurrence_in_hours, start_at, volume_arn, params::Dict{String,<:Any})

Updates a snapshot schedule configured for a gateway volume. This operation is only
supported in the cached volume and stored volume gateway types. The default snapshot
schedule for volume is once every 24 hours, starting at the creation time of the volume.
You can use this API to change the snapshot schedule configured for the volume. In the
request you must identify the gateway volume whose snapshot schedule you want to update,
and the schedule information, including when you want the snapshot to begin on a day and
the frequency (in hours) of snapshots.

# Arguments
- `recurrence_in_hours`: Frequency of snapshots. Specify the number of hours between
  snapshots.
- `start_at`: The hour of the day at which the snapshot schedule begins represented as hh,
  where hh is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
- `volume_arn`: The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
  to return a list of gateway volumes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Optional description of the snapshot that overwrites the existing
  description.
- `"Tags"`: A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
  key-value pair.  Valid characters for key and value are letters, spaces, and numbers
  representable in UTF-8 format, and the following special characters: + - = . _ : / @. The
  maximum length of a tag's key is 128 characters, and the maximum length for a tag's value
  is 256.
"""
function update_snapshot_schedule(
    RecurrenceInHours,
    StartAt,
    VolumeARN;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSnapshotSchedule",
        Dict{String,Any}(
            "RecurrenceInHours" => RecurrenceInHours,
            "StartAt" => StartAt,
            "VolumeARN" => VolumeARN,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_snapshot_schedule(
    RecurrenceInHours,
    StartAt,
    VolumeARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateSnapshotSchedule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RecurrenceInHours" => RecurrenceInHours,
                    "StartAt" => StartAt,
                    "VolumeARN" => VolumeARN,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vtldevice_type(device_type, vtldevice_arn)
    update_vtldevice_type(device_type, vtldevice_arn, params::Dict{String,<:Any})

Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you
select a medium changer type for the tape gateway. This operation enables you to select a
different type of medium changer after a tape gateway is activated. This operation is only
supported in the tape gateway type.

# Arguments
- `device_type`: The type of medium changer you want to select. Valid Values: STK-L700 |
  AWS-Gateway-VTL | IBM-03584L32-0402
- `vtldevice_arn`: The Amazon Resource Name (ARN) of the medium changer you want to select.

"""
function update_vtldevice_type(
    DeviceType, VTLDeviceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return storage_gateway(
        "UpdateVTLDeviceType",
        Dict{String,Any}("DeviceType" => DeviceType, "VTLDeviceARN" => VTLDeviceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vtldevice_type(
    DeviceType,
    VTLDeviceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return storage_gateway(
        "UpdateVTLDeviceType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeviceType" => DeviceType, "VTLDeviceARN" => VTLDeviceARN
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
