DataFrames.jl
=============

[![codecov](https://codecov.io/gh/JuliaData/DataFrames.jl/graph/badge.svg?token=DHYzeKcumV)](https://codecov.io/gh/JuliaData/DataFrames.jl)
[![CI Testing](https://github.com/JuliaData/DataFrames.jl/workflows/CI/badge.svg)](https://github.com/JuliaData/DataFrames.jl/actions?query=workflow%3ACI+branch%3Amain)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7632427.svg)](https://doi.org/10.5281/zenodo.7632427)

Tools for working with tabular data in Julia.

**Installation**: at the Julia REPL, `using Pkg; Pkg.add("DataFrames")`

**Documentation**: [![][docs-stable-img]][docs-stable-url] [![][docs-latest-img]][docs-latest-url]

**Reporting Issues and Contributing**: See [CONTRIBUTING.md](CONTRIBUTING.md)

[![ColPrac: Contributor's Guide on Collaborative Practices for Community Packages](https://img.shields.io/badge/ColPrac-Contributor's%20Guide-blueviolet)](https://github.com/SciML/ColPrac)

**Maintenance**: DataFrames is maintained collectively by the [JuliaData collaborators](https://github.com/orgs/JuliaData/people).
Responsiveness to pull requests and issues can vary, depending on the availability of key collaborators.

**Learning**: New to DataFrames.jl? Check out our
[free Julia Academy course](https://juliaacademy.com/p/introduction-to-dataframes-jl)
which will walk you through how to use DataFrames.jl.
You can also check out
[Bogumił Kamiński's DataFrames.jl tutorial](https://github.com/bkamins/Julia-DataFrames-Tutorial)
that is available on GitHub.

[docs-latest-img]: https://img.shields.io/badge/docs-latest-blue.svg
[docs-latest-url]: http://dataframes.juliadata.org/latest/

[docs-stable-img]: https://img.shields.io/badge/docs-stable-blue.svg
[docs-stable-url]: http://dataframes.juliadata.org/stable/

**Citing**: We encourage you to cite our work if you have used DataFrames.jl package.
Starring the DataFrames.jl repository on GitHub is also appreciated.

The citation information may be found in the [CITATION.bib](CITATION.bib) file within the repository:

> Bouchet-Valat, M., & Kamiński, B. (2023). DataFrames.jl: Flexible and Fast Tabular Data in Julia. Journal of Statistical Software, 107(4), 1–32. https://doi.org/10.18637/jss.v107.i04
