# Notes for Optim Contributors

Welcome to Optim.jl, and thanks for showing an interest in our package.

## Before filing an issue

Reporting a potential bug? Please be sure to include a [Minimal Working Example](https://en.wikipedia.org/wiki/Minimal_Working_Example) so the other contributors can get right at solving your issue. Including the version of Optim.jl you have installed and the exact version of Julia you are using is encouraged as well.

## Contributing code

Contributing code? We welcome all bug fixes, documentation, and new features. However, before you spend several weeks learning all the kinks and corners of Optim.jl to contribute a new algorithm, it is adviced to reach out via an issue or through [gitter](https://gitter.im/JuliaNLSolvers/Optim.jl) to gauge the interest. While we want to provide as many good solvers to the end-users, we need to think about the over-all fit of the algorithm for Optim.jl, and the possibility of maintaining the extra code.

If you want to contribute, but you don't have any ideas for a PR, feel free to take a look at the issues labelled [help wanted](https://github.com/JuliaNLSolvers/Optim.jl/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22).
