# emulating exmaple found on pardiso_unsym_schur.cpp found on https://pardiso-project.org

n = 16

ia = [0, 9, 17, 24, 31, 38, 46, 53, 61, 63, 65, 67, 69, 71, 73, 75, 77] .+ 1

ja = [0, 2, 5, 6, 8, 9, 10, 11, 12, 1, 2, 4, 8, 9, 10, 11, 12, 2, 7, 8, 9,
                     10, 11, 12, 3, 6, 8, 9, 10, 11, 12, 1, 4, 8, 9, 10, 11, 12, 2, 5, 7,
                     8, 9, 10, 11, 12, 1, 6, 8, 9, 10, 11, 12, 2, 6, 7, 8, 9, 10, 11, 12,
                     0, 8, 1, 9, 2, 10, 3, 11, 4, 12, 5, 13, 6, 14, 7, 15] .+ 1

a = [
    complex(7.0000000000000000, 1.),
    complex(1.0000000000000000, 1.),
    complex(2.0000000000000000, 1.),
    complex(7.0000000000000000, 1.),
    complex(0.8813528146570788, 0.),
    complex(0.9693082988664113, 0.),
    complex(0.0063764102307857, 0.),
    complex(0.0656724982252748, 0.),
    complex(0.1285133482338328, 0.),
    complex(-4.0000000000000000, 0.),
    complex(8.0000000000000000, 1.),
    complex(2.0000000000000000, 1.),
    complex(0.0246814022448006, 0.),
    complex(0.3913069588115609, 0.),
    complex(0.9199013631348676, 0.),
    complex(0.2300406237580992, 0.),
    complex(0.6371356638478847, 0.),
    complex(1.0000000000000000, 1.),
    complex(5.0000000000000000, 1.),
    complex(0.3412064600197927, 0.),
    complex(0.3135851048672553, 0.),
    complex(0.0179622413055945, 0.),
    complex(0.1170403198125443, 0.),
    complex(0.7464881699547887, 0.),
    complex(7.0000000000000000, 0.),
    complex(9.0000000000000000, 1.),
    complex(0.4214056775317185, 0.),
    complex(0.5533135799374451, 0.),
    complex(0.0294164798770650, 0.),
    complex(0.9897710614201980, 0.),
    complex(0.8052672976354331, 0.),
    complex(-4.0000000000000000, 1.),
    complex(0.0000000000000000, 0.),
    complex(0.0800111586678662, 0.),
    complex(0.7920480624973907, 0.),
    complex(0.7114519163682994, 0.),
    complex(0.0705164910828937, 0.),
    complex(0.2690271315860681, 0.),
    complex(7.0000000000000000, 1.),
    complex(3.0000000000000000, 1.),
    complex(8.0000000000000000, 0.),
    complex(0.0793538091733186, 0.),
    complex(0.7983140830802098, 0.),
    complex(0.5384141865401406, 0.),
    complex(0.0600236559152354, 0.),
    complex(0.4339797789833593, 0.),
    complex(1.0000000000000000, 1.),
    complex(11.0000000000000000, 1.),
    complex(0.0723762491986621, 0.),
    complex(0.8632585405599013, 0.),
    complex(0.5245885805189759, 0.),
    complex(0.6615771015291297, 0.),
    complex( 0.4018064872641355, 0.),
    complex(-3.0000000000000000, 1.),
    complex( 2.0000000000000000, 1.),
    complex( 5.0000000000000000, 0.),
    complex( 0.9003410060810889, 0.),
    complex( 0.7979622044473094, 0.),
    complex( 0.5022399304161738, 0.),
    complex( 0.3440577694777694, 0.),
    complex(0.6081423394349520, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.),
    complex(1.0000000000000000, 0.),
    complex(0.0000000000000000, 0.)
    ]

M = SparseMatrixCSC(n,n,ia,ja,a)

ps = PardisoSolver()
set_matrixtype!(ps,Pardiso.COMPLEX_NONSYM)
S = schur_complement(ps,M,8)

m = real(M)
set_matrixtype!(ps,Pardiso.REAL_NONSYM)
s = schur_complement(ps,m,8)

A = M[1:n-8,1:n-8]
A⁻¹ = inv(Matrix(A))
rA⁻¹ = inv(real(Matrix(A)))
B = M[1:n-8,n-7:end]
C = M[n-7:end,1:n-8]
D = M[n-7:end,n-7:end]
