```@meta
CurrentModule = StatsModels
DocTestSetup = quote
    using StatsModels, Random, StatsBase
    Random.seed!(2001)
end
```

# StatsModels.jl API

## Formulae and terms

```@docs
@formula
term
coefnames
modelcols
termnames
```

### Higher-order terms

```@docs
FormulaTerm
InteractionTerm
FunctionTerm
```

### Placeholder terms

```@docs
Term
ConstantTerm
```

### Concrete terms

These are all generated by [`apply_schema`](@ref).

```@docs
ContinuousTerm
CategoricalTerm
InterceptTerm
lead
lag
MatrixTerm
collect_matrix_terms
is_matrix_term
```

### Protection

For more fine-grained control over whether function calls are treated as normal
Julia calls ("protected" and captured as `FunctionTerm`s) or as `@formula`
syntax ("unprotected").

```@docs
protect
unprotect
@support_unprotect
Protected
```

## Schema

```@docs
Schema
schema
concrete_term
apply_schema
```

## Modeling

```@docs
fit
gvif
lrtest
formula
modelmatrix
response
vif
```

### Traits

```@docs
StatsModels.implicit_intercept
StatsModels.drop_intercept
```

### Wrappers

!!! warning

    These are internal implementation details that are likely to change in the
    near future.  In particular, the `ModelFrame` and `ModelMatrix` wrappers are
    dispreferred in favor of using terms directly, and can in most cases be
    replaced by something like

    ```julia
    # instead of ModelMatrix(ModelFrame(f::FormulaTerm, data, model=MyModel))
    sch = schema(f, data)
    f = apply_schema(f, sch, MyModel)
    response, predictors = modelcols(f, data)
    ```

```@docs
ModelFrame
ModelMatrix
StatsModels.TableStatisticalModel
StatsModels.TableRegressionModel
```
