// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{ffi, CellRenderer, CellRendererMode, TreePath};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkCellRendererText")]
    pub struct CellRendererText(Object<ffi::GtkCellRendererText, ffi::GtkCellRendererTextClass>) @extends CellRenderer;

    match fn {
        type_ => || ffi::gtk_cell_renderer_text_get_type(),
    }
}

impl CellRendererText {
    pub const NONE: Option<&'static CellRendererText> = None;

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_cell_renderer_text_new")]
    pub fn new() -> CellRendererText {
        assert_initialized_main_thread!();
        unsafe { CellRenderer::from_glib_none(ffi::gtk_cell_renderer_text_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CellRendererText`] objects.
    ///
    /// This method returns an instance of [`CellRendererTextBuilder`](crate::builders::CellRendererTextBuilder) which can be used to create [`CellRendererText`] objects.
    pub fn builder() -> CellRendererTextBuilder {
        CellRendererTextBuilder::new()
    }
}

impl Default for CellRendererText {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CellRendererText`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CellRendererTextBuilder {
    builder: glib::object::ObjectBuilder<'static, CellRendererText>,
}

impl CellRendererTextBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn align_set(self, align_set: bool) -> Self {
        Self {
            builder: self.builder.property("align-set", align_set),
        }
    }

    pub fn alignment(self, alignment: pango::Alignment) -> Self {
        Self {
            builder: self.builder.property("alignment", alignment),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn background(self, background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("background", background.into()),
        }
    }

    pub fn background_rgba(self, background_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("background-rgba", background_rgba),
        }
    }

    pub fn background_set(self, background_set: bool) -> Self {
        Self {
            builder: self.builder.property("background-set", background_set),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn editable_set(self, editable_set: bool) -> Self {
        Self {
            builder: self.builder.property("editable-set", editable_set),
        }
    }

    pub fn ellipsize(self, ellipsize: pango::EllipsizeMode) -> Self {
        Self {
            builder: self.builder.property("ellipsize", ellipsize),
        }
    }

    pub fn ellipsize_set(self, ellipsize_set: bool) -> Self {
        Self {
            builder: self.builder.property("ellipsize-set", ellipsize_set),
        }
    }

    pub fn family(self, family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("family", family.into()),
        }
    }

    pub fn family_set(self, family_set: bool) -> Self {
        Self {
            builder: self.builder.property("family-set", family_set),
        }
    }

    pub fn font(self, font: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("font", font.into()),
        }
    }

    pub fn font_desc(self, font_desc: &pango::FontDescription) -> Self {
        Self {
            builder: self.builder.property("font-desc", font_desc),
        }
    }

    pub fn foreground(self, foreground: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("foreground", foreground.into()),
        }
    }

    pub fn foreground_rgba(self, foreground_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("foreground-rgba", foreground_rgba),
        }
    }

    pub fn foreground_set(self, foreground_set: bool) -> Self {
        Self {
            builder: self.builder.property("foreground-set", foreground_set),
        }
    }

    pub fn language(self, language: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("language", language.into()),
        }
    }

    pub fn language_set(self, language_set: bool) -> Self {
        Self {
            builder: self.builder.property("language-set", language_set),
        }
    }

    pub fn markup(self, markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("markup", markup.into()),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn placeholder_text(self, placeholder_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("placeholder-text", placeholder_text.into()),
        }
    }

    pub fn rise(self, rise: i32) -> Self {
        Self {
            builder: self.builder.property("rise", rise),
        }
    }

    pub fn rise_set(self, rise_set: bool) -> Self {
        Self {
            builder: self.builder.property("rise-set", rise_set),
        }
    }

    pub fn scale(self, scale: f64) -> Self {
        Self {
            builder: self.builder.property("scale", scale),
        }
    }

    pub fn scale_set(self, scale_set: bool) -> Self {
        Self {
            builder: self.builder.property("scale-set", scale_set),
        }
    }

    pub fn single_paragraph_mode(self, single_paragraph_mode: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("single-paragraph-mode", single_paragraph_mode),
        }
    }

    pub fn size(self, size: i32) -> Self {
        Self {
            builder: self.builder.property("size", size),
        }
    }

    pub fn size_points(self, size_points: f64) -> Self {
        Self {
            builder: self.builder.property("size-points", size_points),
        }
    }

    pub fn size_set(self, size_set: bool) -> Self {
        Self {
            builder: self.builder.property("size-set", size_set),
        }
    }

    pub fn stretch(self, stretch: pango::Stretch) -> Self {
        Self {
            builder: self.builder.property("stretch", stretch),
        }
    }

    pub fn stretch_set(self, stretch_set: bool) -> Self {
        Self {
            builder: self.builder.property("stretch-set", stretch_set),
        }
    }

    pub fn strikethrough(self, strikethrough: bool) -> Self {
        Self {
            builder: self.builder.property("strikethrough", strikethrough),
        }
    }

    pub fn strikethrough_set(self, strikethrough_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("strikethrough-set", strikethrough_set),
        }
    }

    pub fn style(self, style: pango::Style) -> Self {
        Self {
            builder: self.builder.property("style", style),
        }
    }

    pub fn style_set(self, style_set: bool) -> Self {
        Self {
            builder: self.builder.property("style-set", style_set),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn underline(self, underline: pango::Underline) -> Self {
        Self {
            builder: self.builder.property("underline", underline),
        }
    }

    pub fn underline_set(self, underline_set: bool) -> Self {
        Self {
            builder: self.builder.property("underline-set", underline_set),
        }
    }

    pub fn variant(self, variant: pango::Variant) -> Self {
        Self {
            builder: self.builder.property("variant", variant),
        }
    }

    pub fn variant_set(self, variant_set: bool) -> Self {
        Self {
            builder: self.builder.property("variant-set", variant_set),
        }
    }

    pub fn weight(self, weight: i32) -> Self {
        Self {
            builder: self.builder.property("weight", weight),
        }
    }

    pub fn weight_set(self, weight_set: bool) -> Self {
        Self {
            builder: self.builder.property("weight-set", weight_set),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn wrap_mode(self, wrap_mode: pango::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn wrap_width(self, wrap_width: i32) -> Self {
        Self {
            builder: self.builder.property("wrap-width", wrap_width),
        }
    }

    pub fn cell_background(self, cell_background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-background", cell_background.into()),
        }
    }

    pub fn cell_background_rgba(self, cell_background_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-background-rgba", cell_background_rgba),
        }
    }

    pub fn cell_background_set(self, cell_background_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-background-set", cell_background_set),
        }
    }

    pub fn height(self, height: i32) -> Self {
        Self {
            builder: self.builder.property("height", height),
        }
    }

    pub fn is_expanded(self, is_expanded: bool) -> Self {
        Self {
            builder: self.builder.property("is-expanded", is_expanded),
        }
    }

    pub fn is_expander(self, is_expander: bool) -> Self {
        Self {
            builder: self.builder.property("is-expander", is_expander),
        }
    }

    pub fn mode(self, mode: CellRendererMode) -> Self {
        Self {
            builder: self.builder.property("mode", mode),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width(self, width: i32) -> Self {
        Self {
            builder: self.builder.property("width", width),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    pub fn xpad(self, xpad: u32) -> Self {
        Self {
            builder: self.builder.property("xpad", xpad),
        }
    }

    pub fn yalign(self, yalign: f32) -> Self {
        Self {
            builder: self.builder.property("yalign", yalign),
        }
    }

    pub fn ypad(self, ypad: u32) -> Self {
        Self {
            builder: self.builder.property("ypad", ypad),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CellRendererText`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CellRendererText {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::CellRendererText>> Sealed for T {}
}

pub trait CellRendererTextExt: IsA<CellRendererText> + sealed::Sealed + 'static {
    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_cell_renderer_text_set_fixed_height_from_font")]
    fn set_fixed_height_from_font(&self, number_of_rows: i32) {
        unsafe {
            ffi::gtk_cell_renderer_text_set_fixed_height_from_font(
                self.as_ref().to_glib_none().0,
                number_of_rows,
            );
        }
    }

    #[doc(alias = "align-set")]
    fn is_align_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "align-set")
    }

    fn alignment(&self) -> pango::Alignment {
        ObjectExt::property(self.as_ref(), "alignment")
    }

    fn set_alignment(&self, alignment: pango::Alignment) {
        ObjectExt::set_property(self.as_ref(), "alignment", alignment)
    }

    fn attributes(&self) -> Option<pango::AttrList> {
        ObjectExt::property(self.as_ref(), "attributes")
    }

    fn set_attributes(&self, attributes: Option<&pango::AttrList>) {
        ObjectExt::set_property(self.as_ref(), "attributes", attributes)
    }

    fn set_background(&self, background: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "background", background)
    }

    #[doc(alias = "background-rgba")]
    fn background_rgba(&self) -> Option<gdk::RGBA> {
        ObjectExt::property(self.as_ref(), "background-rgba")
    }

    #[doc(alias = "background-rgba")]
    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        ObjectExt::set_property(self.as_ref(), "background-rgba", background_rgba)
    }

    #[doc(alias = "background-set")]
    fn is_background_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "background-set")
    }

    fn is_editable(&self) -> bool {
        ObjectExt::property(self.as_ref(), "editable")
    }

    fn set_editable(&self, editable: bool) {
        ObjectExt::set_property(self.as_ref(), "editable", editable)
    }

    #[doc(alias = "editable-set")]
    fn is_editable_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "editable-set")
    }

    fn ellipsize(&self) -> pango::EllipsizeMode {
        ObjectExt::property(self.as_ref(), "ellipsize")
    }

    fn set_ellipsize(&self, ellipsize: pango::EllipsizeMode) {
        ObjectExt::set_property(self.as_ref(), "ellipsize", ellipsize)
    }

    #[doc(alias = "ellipsize-set")]
    fn is_ellipsize_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "ellipsize-set")
    }

    fn family(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "family")
    }

    fn set_family(&self, family: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "family", family)
    }

    #[doc(alias = "family-set")]
    fn is_family_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "family-set")
    }

    fn font(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "font")
    }

    fn set_font(&self, font: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "font", font)
    }

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription> {
        ObjectExt::property(self.as_ref(), "font-desc")
    }

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        ObjectExt::set_property(self.as_ref(), "font-desc", font_desc)
    }

    fn set_foreground(&self, foreground: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "foreground", foreground)
    }

    #[doc(alias = "foreground-rgba")]
    fn foreground_rgba(&self) -> Option<gdk::RGBA> {
        ObjectExt::property(self.as_ref(), "foreground-rgba")
    }

    #[doc(alias = "foreground-rgba")]
    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        ObjectExt::set_property(self.as_ref(), "foreground-rgba", foreground_rgba)
    }

    #[doc(alias = "foreground-set")]
    fn is_foreground_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "foreground-set")
    }

    fn language(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "language")
    }

    fn set_language(&self, language: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "language", language)
    }

    #[doc(alias = "language-set")]
    fn is_language_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "language-set")
    }

    fn set_markup(&self, markup: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "markup", markup)
    }

    #[doc(alias = "max-width-chars")]
    fn max_width_chars(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "max-width-chars")
    }

    #[doc(alias = "max-width-chars")]
    fn set_max_width_chars(&self, max_width_chars: i32) {
        ObjectExt::set_property(self.as_ref(), "max-width-chars", max_width_chars)
    }

    #[doc(alias = "placeholder-text")]
    fn placeholder_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "placeholder-text")
    }

    #[doc(alias = "placeholder-text")]
    fn set_placeholder_text(&self, placeholder_text: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "placeholder-text", placeholder_text)
    }

    fn rise(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "rise")
    }

    fn set_rise(&self, rise: i32) {
        ObjectExt::set_property(self.as_ref(), "rise", rise)
    }

    #[doc(alias = "rise-set")]
    fn is_rise_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "rise-set")
    }

    fn scale(&self) -> f64 {
        ObjectExt::property(self.as_ref(), "scale")
    }

    fn set_scale(&self, scale: f64) {
        ObjectExt::set_property(self.as_ref(), "scale", scale)
    }

    #[doc(alias = "scale-set")]
    fn is_scale_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "scale-set")
    }

    #[doc(alias = "single-paragraph-mode")]
    fn is_single_paragraph_mode(&self) -> bool {
        ObjectExt::property(self.as_ref(), "single-paragraph-mode")
    }

    #[doc(alias = "single-paragraph-mode")]
    fn set_single_paragraph_mode(&self, single_paragraph_mode: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "single-paragraph-mode",
            single_paragraph_mode,
        )
    }

    fn size(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "size")
    }

    fn set_size(&self, size: i32) {
        ObjectExt::set_property(self.as_ref(), "size", size)
    }

    #[doc(alias = "size-points")]
    fn size_points(&self) -> f64 {
        ObjectExt::property(self.as_ref(), "size-points")
    }

    #[doc(alias = "size-points")]
    fn set_size_points(&self, size_points: f64) {
        ObjectExt::set_property(self.as_ref(), "size-points", size_points)
    }

    #[doc(alias = "size-set")]
    fn is_size_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "size-set")
    }

    fn stretch(&self) -> pango::Stretch {
        ObjectExt::property(self.as_ref(), "stretch")
    }

    fn set_stretch(&self, stretch: pango::Stretch) {
        ObjectExt::set_property(self.as_ref(), "stretch", stretch)
    }

    #[doc(alias = "stretch-set")]
    fn is_stretch_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "stretch-set")
    }

    fn is_strikethrough(&self) -> bool {
        ObjectExt::property(self.as_ref(), "strikethrough")
    }

    fn set_strikethrough(&self, strikethrough: bool) {
        ObjectExt::set_property(self.as_ref(), "strikethrough", strikethrough)
    }

    #[doc(alias = "strikethrough-set")]
    fn is_strikethrough_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "strikethrough-set")
    }

    fn style(&self) -> pango::Style {
        ObjectExt::property(self.as_ref(), "style")
    }

    fn set_style(&self, style: pango::Style) {
        ObjectExt::set_property(self.as_ref(), "style", style)
    }

    #[doc(alias = "style-set")]
    fn is_style_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "style-set")
    }

    fn text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "text")
    }

    fn set_text(&self, text: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "text", text)
    }

    fn underline(&self) -> pango::Underline {
        ObjectExt::property(self.as_ref(), "underline")
    }

    fn set_underline(&self, underline: pango::Underline) {
        ObjectExt::set_property(self.as_ref(), "underline", underline)
    }

    #[doc(alias = "underline-set")]
    fn is_underline_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "underline-set")
    }

    fn variant(&self) -> pango::Variant {
        ObjectExt::property(self.as_ref(), "variant")
    }

    fn set_variant(&self, variant: pango::Variant) {
        ObjectExt::set_property(self.as_ref(), "variant", variant)
    }

    #[doc(alias = "variant-set")]
    fn is_variant_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "variant-set")
    }

    fn weight(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "weight")
    }

    fn set_weight(&self, weight: i32) {
        ObjectExt::set_property(self.as_ref(), "weight", weight)
    }

    #[doc(alias = "weight-set")]
    fn is_weight_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "weight-set")
    }

    #[doc(alias = "width-chars")]
    fn width_chars(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "width-chars")
    }

    #[doc(alias = "width-chars")]
    fn set_width_chars(&self, width_chars: i32) {
        ObjectExt::set_property(self.as_ref(), "width-chars", width_chars)
    }

    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> pango::WrapMode {
        ObjectExt::property(self.as_ref(), "wrap-mode")
    }

    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        ObjectExt::set_property(self.as_ref(), "wrap-mode", wrap_mode)
    }

    #[doc(alias = "wrap-width")]
    fn wrap_width(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "wrap-width")
    }

    #[doc(alias = "wrap-width")]
    fn set_wrap_width(&self, wrap_width: i32) {
        ObjectExt::set_property(self.as_ref(), "wrap-width", wrap_width)
    }

    #[doc(alias = "edited")]
    fn connect_edited<F: Fn(&Self, TreePath, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edited_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P, TreePath, &str) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            path: *mut std::ffi::c_char,
            new_text: *mut std::ffi::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            let path = from_glib_full(crate::ffi::gtk_tree_path_new_from_string(path));
            f(
                CellRendererText::from_glib_borrow(this).unsafe_cast_ref(),
                path,
                &glib::GString::from_glib_borrow(new_text),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edited\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    edited_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "align-set")]
    fn connect_align_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_align_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::align-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_align_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "alignment")]
    fn connect_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_alignment_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::alignment\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_alignment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "background")]
    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "background-rgba")]
    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "background-set")]
    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "editable-set")]
    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_editable_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ellipsize")]
    fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ellipsize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ellipsize-set")]
    fn connect_ellipsize_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ellipsize_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "family")]
    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_family_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "family-set")]
    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_family_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "font")]
    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "foreground")]
    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_foreground_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "foreground-rgba")]
    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "foreground-set")]
    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_foreground_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "language")]
    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_language_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "language-set")]
    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_language_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "markup")]
    fn connect_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-width-chars")]
    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "placeholder-text")]
    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rise")]
    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_rise_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rise-set")]
    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_rise_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scale")]
    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scale-set")]
    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scale_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "single-paragraph-mode")]
    fn connect_single_paragraph_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_single_paragraph_mode_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::single-paragraph-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_single_paragraph_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size")]
    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size-points")]
    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_points_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-points\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_size_points_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size-set")]
    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stretch")]
    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_stretch_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stretch-set")]
    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_stretch_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "strikethrough")]
    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_strikethrough_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "strikethrough-set")]
    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_strikethrough_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "style")]
    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "style-set")]
    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_style_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "underline")]
    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "underline-set")]
    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_underline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "variant")]
    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_variant_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "variant-set")]
    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_variant_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "weight")]
    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_weight_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "weight-set")]
    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_set_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight-set\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_weight_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "width-chars")]
    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-width")]
    fn connect_wrap_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_width_trampoline<
            P: IsA<CellRendererText>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkCellRendererText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CellRendererText::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<CellRendererText>> CellRendererTextExt for O {}
