/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2024 MediaTek Inc.
 * Copyright (c) 2025 Collabora Ltd
 */

#include <linux/bits.h>

#ifndef __LINUX_REGULATOR_MT6363_H
#define __LINUX_REGULATOR_MT6363_H

/* Register */
#define MT6363_TOP_TRAP				0x6
#define MT6363_TOP_TMA_KEY_L			0x36e
#define MT6363_RG_BUCK0_EN_ADDR			0x210
#define MT6363_RG_BUCK_VS2_EN_BIT		0
#define MT6363_RG_BUCK_VBUCK1_EN_BIT		1
#define MT6363_RG_BUCK_VBUCK2_EN_BIT		2
#define MT6363_RG_BUCK_VBUCK3_EN_BIT		3
#define MT6363_RG_BUCK_VBUCK4_EN_BIT		4
#define MT6363_RG_BUCK_VBUCK5_EN_BIT		5
#define MT6363_RG_BUCK_VBUCK6_EN_BIT		6
#define MT6363_RG_BUCK_VBUCK7_EN_BIT		7
#define MT6363_RG_BUCK1_EN_ADDR			0x213
#define MT6363_RG_BUCK_VS1_EN_BIT		0
#define MT6363_RG_BUCK_VS3_EN_BIT		1
#define MT6363_RG_LDO_VSRAM_DIGRF_EN_BIT	4
#define MT6363_RG_LDO_VSRAM_MDFE_EN_BIT		5
#define MT6363_RG_LDO_VSRAM_MODEM_EN_BIT	6
#define MT6363_RG_BUCK0_LP_ADDR			0x216
#define MT6363_RG_BUCK_VS2_LP_BIT		0
#define MT6363_RG_BUCK_VBUCK1_LP_BIT		1
#define MT6363_RG_BUCK_VBUCK2_LP_BIT		2
#define MT6363_RG_BUCK_VBUCK3_LP_BIT		3
#define MT6363_RG_BUCK_VBUCK4_LP_BIT		4
#define MT6363_RG_BUCK_VBUCK5_LP_BIT		5
#define MT6363_RG_BUCK_VBUCK6_LP_BIT		6
#define MT6363_RG_BUCK_VBUCK7_LP_BIT		7
#define MT6363_RG_BUCK1_LP_ADDR			0x219
#define MT6363_RG_BUCK_VS1_LP_BIT		0
#define MT6363_RG_BUCK_VS3_LP_BIT		1
#define MT6363_RG_LDO_VSRAM_DIGRF_LP_BIT	4
#define MT6363_RG_LDO_VSRAM_MDFE_LP_BIT		5
#define MT6363_RG_LDO_VSRAM_MODEM_LP_BIT	6
#define MT6363_RG_BUCK_VS2_VOSEL_ADDR		0x21c
#define MT6363_RG_BUCK_VS2_VOSEL_MASK		GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK1_VOSEL_ADDR	0x21d
#define MT6363_RG_BUCK_VBUCK1_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK2_VOSEL_ADDR	0x21e
#define MT6363_RG_BUCK_VBUCK2_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK3_VOSEL_ADDR	0x21f
#define MT6363_RG_BUCK_VBUCK3_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK4_VOSEL_ADDR	0x220
#define MT6363_RG_BUCK_VBUCK4_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK5_VOSEL_ADDR	0x221
#define MT6363_RG_BUCK_VBUCK5_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK6_VOSEL_ADDR	0x222
#define MT6363_RG_BUCK_VBUCK6_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VBUCK7_VOSEL_ADDR	0x223
#define MT6363_RG_BUCK_VBUCK7_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_RG_BUCK_VS1_VOSEL_ADDR		0x224
#define MT6363_RG_BUCK_VS1_VOSEL_MASK		GENMASK(7, 0)
#define MT6363_RG_BUCK_VS3_VOSEL_ADDR		0x225
#define MT6363_RG_BUCK_VS3_VOSEL_MASK		GENMASK(7, 0)
#define MT6363_RG_LDO_VSRAM_DIGRF_VOSEL_ADDR	0x228
#define MT6363_RG_LDO_VSRAM_DIGRF_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_LDO_VSRAM_MDFE_VOSEL_ADDR	0x229
#define MT6363_RG_LDO_VSRAM_MDFE_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_LDO_VSRAM_MODEM_VOSEL_ADDR	0x22a
#define MT6363_RG_LDO_VSRAM_MODEM_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_BUCK_TOP_KEY_PROT_LO		0x13fa
#define MT6363_BUCK_VS2_WDTDBG_VOSEL_ADDR	0x13fc
#define MT6363_BUCK_VBUCK1_WDTDBG_VOSEL_ADDR	0x13fd
#define MT6363_BUCK_VBUCK2_WDTDBG_VOSEL_ADDR	0x13fe
#define MT6363_BUCK_VBUCK3_WDTDBG_VOSEL_ADDR	0x13ff
#define MT6363_BUCK_VBUCK4_WDTDBG_VOSEL_ADDR	0x1400
#define MT6363_BUCK_VBUCK5_WDTDBG_VOSEL_ADDR	0x1401
#define MT6363_BUCK_VBUCK6_WDTDBG_VOSEL_ADDR	0x1402
#define MT6363_BUCK_VBUCK7_WDTDBG_VOSEL_ADDR	0x1403
#define MT6363_BUCK_VS1_WDTDBG_VOSEL_ADDR	0x1404
#define MT6363_BUCK_VS3_WDTDBG_VOSEL_ADDR	0x1405
#define MT6363_RG_BUCK_EFUSE_RSV1		0x1417
#define MT6363_RG_BUCK_EFUSE_RSV1_MASK		GENMASK(7, 4)
#define MT6363_BUCK_VS2_OP_EN_0			0x145d
#define MT6363_BUCK_VS2_HW_LP_MODE		0x1468
#define MT6363_BUCK_VBUCK1_OP_EN_0		0x14dd
#define MT6363_BUCK_VBUCK1_HW_LP_MODE		0x14e8
#define MT6363_RG_BUCK_VBUCK1_SSHUB_EN_ADDR	0x14ea
#define MT6363_RG_BUCK_VBUCK1_SSHUB_VOSEL_ADDR	0x14eb
#define MT6363_RG_BUCK_VBUCK1_SSHUB_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_BUCK_VBUCK2_OP_EN_0		0x155d
#define MT6363_BUCK_VBUCK2_HW_LP_MODE		0x1568
#define MT6363_RG_BUCK_VBUCK2_SSHUB_EN_ADDR	0x156a
#define MT6363_RG_BUCK_VBUCK2_SSHUB_VOSEL_ADDR	0x156b
#define MT6363_RG_BUCK_VBUCK2_SSHUB_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_BUCK_VBUCK3_OP_EN_0		0x15dd
#define MT6363_BUCK_VBUCK3_HW_LP_MODE		0x15e8
#define MT6363_BUCK_VBUCK4_OP_EN_0		0x165d
#define MT6363_BUCK_VBUCK4_HW_LP_MODE		0x1668
#define MT6363_RG_BUCK_VBUCK4_SSHUB_EN_ADDR	0x166a
#define MT6363_RG_BUCK_VBUCK4_SSHUB_VOSEL_ADDR	0x166b
#define MT6363_RG_BUCK_VBUCK4_SSHUB_VOSEL_MASK	GENMASK(7, 0)
#define MT6363_BUCK_VBUCK5_OP_EN_0		0x16dd
#define MT6363_BUCK_VBUCK5_HW_LP_MODE		0x16e8
#define MT6363_BUCK_VBUCK6_OP_EN_0		0x175d
#define MT6363_BUCK_VBUCK6_HW_LP_MODE		0x1768
#define MT6363_BUCK_VBUCK7_OP_EN_0		0x17dd
#define MT6363_BUCK_VBUCK7_HW_LP_MODE		0x17e8
#define MT6363_BUCK_VS1_OP_EN_0			0x185d
#define MT6363_BUCK_VS1_HW_LP_MODE		0x1868
#define MT6363_BUCK_VS3_OP_EN_0			0x18dd
#define MT6363_BUCK_VS3_HW_LP_MODE		0x18e8
#define MT6363_RG_VS1_FCCM_ADDR			0x1964
#define MT6363_RG_VS1_FCCM_BIT			0
#define MT6363_RG_VS3_FCCM_ADDR			0x1973
#define MT6363_RG_VS3_FCCM_BIT			0
#define MT6363_RG_BUCK0_FCCM_ADDR		0x1a02
#define MT6363_RG_VBUCK1_FCCM_BIT		0
#define MT6363_RG_VBUCK2_FCCM_BIT		1
#define MT6363_RG_VBUCK3_FCCM_BIT		2
#define MT6363_RG_VS2_FCCM_BIT			3
#define MT6363_RG_BUCK0_1_FCCM_ADDR		0x1a82
#define MT6363_RG_VBUCK4_FCCM_BIT		0
#define MT6363_RG_VBUCK5_FCCM_BIT		1
#define MT6363_RG_VBUCK6_FCCM_BIT		2
#define MT6363_RG_VBUCK7_FCCM_BIT		3
#define MT6363_RG_VCN13_VOSEL_ADDR		0x1b0f
#define MT6363_RG_VCN13_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VEMC_VOSEL_ADDR		0x1b10
#define MT6363_RG_VEMC_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VEMC_VOSEL_1_MASK		GENMASK(7, 4)
#define MT6363_RG_LDO_VSRAM_CPUB_VOSEL_ADDR	0x1b14
#define MT6363_RG_LDO_VSRAM_CPUB_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_LDO_VSRAM_CPUM_VOSEL_ADDR	0x1b15
#define MT6363_RG_LDO_VSRAM_CPUM_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_LDO_VSRAM_CPUL_VOSEL_ADDR	0x1b16
#define MT6363_RG_LDO_VSRAM_CPUL_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_LDO_VSRAM_APU_VOSEL_ADDR	0x1b17
#define MT6363_RG_LDO_VSRAM_APU_VOSEL_MASK	GENMASK(6, 0)
#define MT6363_RG_VEMC_VOCAL_ADDR		0x1b1b
#define MT6363_RG_VEMC_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_LDO_VCN15_ADDR		0x1b57
#define MT6363_RG_LDO_VCN15_EN_BIT		0
#define MT6363_RG_LDO_VCN15_LP_BIT		1
#define MT6363_LDO_VCN15_HW_LP_MODE		0x1b5b
#define MT6363_LDO_VCN15_OP_EN0			0x1b5c
#define MT6363_RG_LDO_VRF09_ADDR		0x1b65
#define MT6363_RG_LDO_VRF09_EN_BIT		0
#define MT6363_RG_LDO_VRF09_LP_BIT		1
#define MT6363_LDO_VRF09_HW_LP_MODE		0x1b69
#define MT6363_LDO_VRF09_OP_EN0			0x1b6a
#define MT6363_RG_LDO_VRF12_ADDR		0x1b73
#define MT6363_RG_LDO_VRF12_EN_BIT		0
#define MT6363_RG_LDO_VRF12_LP_BIT		1
#define MT6363_LDO_VRF12_HW_LP_MODE		0x1b77
#define MT6363_LDO_VRF12_OP_EN0			0x1b78
#define MT6363_RG_LDO_VRF13_ADDR		0x1b81
#define MT6363_RG_LDO_VRF13_EN_BIT		0
#define MT6363_RG_LDO_VRF13_LP_BIT		1
#define MT6363_LDO_VRF13_HW_LP_MODE		0x1b85
#define MT6363_LDO_VRF13_OP_EN0			0x1b86
#define MT6363_RG_LDO_VRF18_ADDR		0x1b8f
#define MT6363_RG_LDO_VRF18_EN_BIT		0
#define MT6363_RG_LDO_VRF18_LP_BIT		1
#define MT6363_LDO_VRF18_HW_LP_MODE		0x1b93
#define MT6363_LDO_VRF18_OP_EN0			0x1b94
#define MT6363_RG_LDO_VRFIO18_ADDR		0x1b9d
#define MT6363_RG_LDO_VRFIO18_EN_BIT		0
#define MT6363_RG_LDO_VRFIO18_LP_BIT		1
#define MT6363_LDO_VRFIO18_HW_LP_MODE		0x1ba1
#define MT6363_LDO_VRFIO18_OP_EN0		0x1ba2
#define MT6363_RG_LDO_VTREF18_ADDR		0x1bd7
#define MT6363_RG_LDO_VTREF18_EN_BIT		0
#define MT6363_RG_LDO_VTREF18_LP_BIT		1
#define MT6363_LDO_VTREF18_HW_LP_MODE		0x1bdb
#define MT6363_LDO_VTREF18_OP_EN0		0x1bdc
#define MT6363_RG_LDO_VAUX18_ADDR		0x1be5
#define MT6363_RG_LDO_VAUX18_EN_BIT		0
#define MT6363_RG_LDO_VAUX18_LP_BIT		1
#define MT6363_LDO_VAUX18_HW_LP_MODE		0x1be9
#define MT6363_LDO_VAUX18_OP_EN0		0x1bea
#define MT6363_RG_LDO_VEMC_ADDR			0x1bf3
#define MT6363_RG_LDO_VEMC_EN_BIT		0
#define MT6363_RG_LDO_VEMC_LP_BIT		1
#define MT6363_LDO_VEMC_HW_LP_MODE		0x1bf7
#define MT6363_LDO_VEMC_OP_EN0			0x1bf8
#define MT6363_RG_LDO_VUFS12_ADDR		0x1c01
#define MT6363_RG_LDO_VUFS12_EN_BIT		0
#define MT6363_RG_LDO_VUFS12_LP_BIT		1
#define MT6363_LDO_VUFS12_HW_LP_MODE		0x1c05
#define MT6363_LDO_VUFS12_OP_EN0		0x1c06
#define MT6363_RG_LDO_VUFS18_ADDR		0x1c0f
#define MT6363_RG_LDO_VUFS18_EN_BIT		0
#define MT6363_RG_LDO_VUFS18_LP_BIT		1
#define MT6363_LDO_VUFS18_HW_LP_MODE		0x1c13
#define MT6363_LDO_VUFS18_OP_EN0		0x1c14
#define MT6363_RG_LDO_VIO18_ADDR		0x1c1d
#define MT6363_RG_LDO_VIO18_EN_BIT		0
#define MT6363_RG_LDO_VIO18_LP_BIT		1
#define MT6363_LDO_VIO18_HW_LP_MODE		0x1c21
#define MT6363_LDO_VIO18_OP_EN0			0x1c22
#define MT6363_RG_LDO_VIO075_ADDR		0x1c57
#define MT6363_RG_LDO_VIO075_EN_BIT		0
#define MT6363_RG_LDO_VIO075_LP_BIT		1
#define MT6363_LDO_VIO075_HW_LP_MODE		0x1c5b
#define MT6363_LDO_VIO075_OP_EN0		0x1c5c
#define MT6363_RG_LDO_VA12_1_ADDR		0x1c65
#define MT6363_RG_LDO_VA12_1_EN_BIT		0
#define MT6363_RG_LDO_VA12_1_LP_BIT		1
#define MT6363_LDO_VA12_1_HW_LP_MODE		0x1c69
#define MT6363_LDO_VA12_1_OP_EN0		0x1c6a
#define MT6363_RG_LDO_VA12_2_ADDR		0x1c73
#define MT6363_RG_LDO_VA12_2_EN_BIT		0
#define MT6363_RG_LDO_VA12_2_LP_BIT		1
#define MT6363_LDO_VA12_2_HW_LP_MODE		0x1c77
#define MT6363_LDO_VA12_2_OP_EN0		0x1c78
#define MT6363_RG_LDO_VA15_ADDR			0x1c81
#define MT6363_RG_LDO_VA15_EN_BIT		0
#define MT6363_RG_LDO_VA15_LP_BIT		1
#define MT6363_LDO_VA15_HW_LP_MODE		0x1c85
#define MT6363_LDO_VA15_OP_EN0			0x1c86
#define MT6363_RG_LDO_VM18_ADDR			0x1c8f
#define MT6363_RG_LDO_VM18_EN_BIT		0
#define MT6363_RG_LDO_VM18_LP_BIT		1
#define MT6363_LDO_VM18_HW_LP_MODE		0x1c93
#define MT6363_LDO_VM18_OP_EN0			0x1c94
#define MT6363_RG_LDO_VCN13_ADDR		0x1cd7
#define MT6363_RG_LDO_VCN13_EN_BIT		0
#define MT6363_RG_LDO_VCN13_LP_BIT		1
#define MT6363_LDO_VCN13_HW_LP_MODE		0x1cdb
#define MT6363_LDO_VCN13_OP_EN0			0x1ce4
#define MT6363_LDO_VSRAM_DIGRF_HW_LP_MODE	0x1cf1
#define MT6363_LDO_VSRAM_DIGRF_OP_EN0		0x1cfa
#define MT6363_LDO_VSRAM_MDFE_HW_LP_MODE	0x1d5b
#define MT6363_LDO_VSRAM_MDFE_OP_EN0		0x1d64
#define MT6363_LDO_VSRAM_MODEM_HW_LP_MODE	0x1d76
#define MT6363_LDO_VSRAM_MODEM_OP_EN0		0x1d7f
#define MT6363_RG_LDO_VSRAM_CPUB_ADDR		0x1dd7
#define MT6363_RG_LDO_VSRAM_CPUB_EN_BIT		0
#define MT6363_RG_LDO_VSRAM_CPUB_LP_BIT		1
#define MT6363_LDO_VSRAM_CPUB_HW_LP_MODE	0x1ddb
#define MT6363_LDO_VSRAM_CPUB_OP_EN0		0x1de4
#define MT6363_RG_LDO_VSRAM_CPUM_ADDR		0x1ded
#define MT6363_RG_LDO_VSRAM_CPUM_EN_BIT		0
#define MT6363_RG_LDO_VSRAM_CPUM_LP_BIT		1
#define MT6363_LDO_VSRAM_CPUM_HW_LP_MODE	0x1df1
#define MT6363_LDO_VSRAM_CPUM_OP_EN0		0x1dfa
#define MT6363_RG_LDO_VSRAM_CPUL_ADDR		0x1e57
#define MT6363_RG_LDO_VSRAM_CPUL_EN_BIT		0
#define MT6363_RG_LDO_VSRAM_CPUL_LP_BIT		1
#define MT6363_LDO_VSRAM_CPUL_HW_LP_MODE	0x1e5b
#define MT6363_LDO_VSRAM_CPUL_OP_EN0		0x1e64
#define MT6363_RG_LDO_VSRAM_APU_ADDR		0x1e6d
#define MT6363_RG_LDO_VSRAM_APU_EN_BIT		0
#define MT6363_RG_LDO_VSRAM_APU_LP_BIT		1
#define MT6363_LDO_VSRAM_APU_HW_LP_MODE		0x1e71
#define MT6363_LDO_VSRAM_APU_OP_EN0		0x1e7a
#define MT6363_RG_VTREF18_VOCAL_ADDR		0x1ed8
#define MT6363_RG_VTREF18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VTREF18_VOSEL_ADDR		0x1ed9
#define MT6363_RG_VTREF18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VAUX18_VOCAL_ADDR		0x1edc
#define MT6363_RG_VAUX18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VAUX18_VOSEL_ADDR		0x1edd
#define MT6363_RG_VAUX18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VCN15_VOCAL_ADDR		0x1ee3
#define MT6363_RG_VCN15_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VCN15_VOSEL_ADDR		0x1ee4
#define MT6363_RG_VCN15_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VUFS18_VOCAL_ADDR		0x1ee7
#define MT6363_RG_VUFS18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VUFS18_VOSEL_ADDR		0x1ee8
#define MT6363_RG_VUFS18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VIO18_VOCAL_ADDR		0x1eeb
#define MT6363_RG_VIO18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VIO18_VOSEL_ADDR		0x1eec
#define MT6363_RG_VIO18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VM18_VOCAL_ADDR		0x1eef
#define MT6363_RG_VM18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VM18_VOSEL_ADDR		0x1ef0
#define MT6363_RG_VM18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA15_VOCAL_ADDR		0x1ef3
#define MT6363_RG_VA15_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA15_VOSEL_ADDR		0x1ef4
#define MT6363_RG_VA15_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF18_VOCAL_ADDR		0x1ef7
#define MT6363_RG_VRF18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF18_VOSEL_ADDR		0x1ef8
#define MT6363_RG_VRF18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRFIO18_VOCAL_ADDR		0x1efb
#define MT6363_RG_VRFIO18_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRFIO18_VOSEL_ADDR		0x1efc
#define MT6363_RG_VRFIO18_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VIO075_VOCFG_ADDR		0x1f01
#define MT6363_RG_VIO075_VOCAL_ADDR		MT6363_RG_VIO075_VOCFG_ADDR
#define MT6363_RG_VIO075_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VIO075_VOSEL_ADDR		MT6363_RG_VIO075_VOCFG_ADDR
#define MT6363_RG_VIO075_VOSEL_MASK		GENMASK(6, 4)
#define MT6363_RG_VCN13_VOCAL_ADDR		0x1f58
#define MT6363_RG_VCN13_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VUFS12_VOCAL_ADDR		0x1f61
#define MT6363_RG_VUFS12_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VUFS12_VOSEL_ADDR		0x1f62
#define MT6363_RG_VUFS12_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA12_1_VOCAL_ADDR		0x1f65
#define MT6363_RG_VA12_1_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA12_1_VOSEL_ADDR		0x1f66
#define MT6363_RG_VA12_1_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA12_2_VOCAL_ADDR		0x1f69
#define MT6363_RG_VA12_2_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VA12_2_VOSEL_ADDR		0x1f6a
#define MT6363_RG_VA12_2_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF12_VOCAL_ADDR		0x1f6d
#define MT6363_RG_VRF12_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF12_VOSEL_ADDR		0x1f6e
#define MT6363_RG_VRF12_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF13_VOCAL_ADDR		0x1f71
#define MT6363_RG_VRF13_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF13_VOSEL_ADDR		0x1f72
#define MT6363_RG_VRF13_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF09_VOCAL_ADDR		0x1f78
#define MT6363_RG_VRF09_VOCAL_MASK		GENMASK(3, 0)
#define MT6363_RG_VRF09_VOSEL_ADDR		0x1f79
#define MT6363_RG_VRF09_VOSEL_MASK		GENMASK(3, 0)
#define MT6363_ISINK_EN_CTRL0			0x21db
#define MT6363_ISINK_CTRL0_MASK			GENMASK(7, 0)
#define MT6363_ISINK_EN_CTRL1			0x21dc
#define MT6363_ISINK_CTRL1_MASK			GENMASK(7, 4)

#endif /* __LINUX_REGULATOR_MT6363_H */
