<?php

namespace CirrusSearch\Query;

class ArticleCountryFeature {

	/**
	 * Maps ISO 3166 country codes to their full country names.
	 *
	 * This constant provides a mapping between three-letter country codes and their
	 * corresponding full country names in English. Used for display and normalization
	 * purposes throughout the application.
	 *
	 * @var array<string, string> Keys are ISO 3166 codes, values are country names
	 *
	 * @example
	 * 'AFG' => 'Afghanistan'
	 * 'ALA' => 'Åland'
	 */
	public const COUNTRY_CODES_TO_LABELS = [
		'afg' => 'Afghanistan',
		'ala' => 'Åland',
		'alb' => 'Albania',
		'dza' => 'Algeria',
		'asm' => 'American Samoa',
		'and' => 'Andorra',
		'ago' => 'Angola',
		'aia' => 'Anguilla',
		'ata' => 'Antarctica',
		'atg' => 'Antigua and Barbuda',
		'arg' => 'Argentina',
		'arm' => 'Armenia',
		'abw' => 'Aruba',
		'aus' => 'Australia',
		'aut' => 'Austria',
		'aze' => 'Azerbaijan',
		'bhs' => 'Bahamas',
		'bhr' => 'Bahrain',
		'bgd' => 'Bangladesh',
		'brb' => 'Barbados',
		'blr' => 'Belarus',
		'bel' => 'Belgium',
		'blz' => 'Belize',
		'ben' => 'Benin',
		'bmu' => 'Bermuda',
		'btn' => 'Bhutan',
		'bol' => 'Bolivia',
		'bes' => 'Bonaire, Sint Eustatius, and Saba',
		'bih' => 'Bosnia and Herzegovina',
		'bwa' => 'Botswana',
		'bvt' => 'Bouvet Island',
		'bra' => 'Brazil',
		'iot' => 'British Indian Ocean Territory',
		'vgb' => 'British Virgin Islands',
		'brn' => 'Brunei',
		'bgr' => 'Bulgaria',
		'bfa' => 'Burkina Faso',
		'bdi' => 'Burundi',
		'khm' => 'Cambodia',
		'cmr' => 'Cameroon',
		'can' => 'Canada',
		'cpv' => 'Cape Verde',
		'cym' => 'Cayman Islands',
		'caf' => 'Central African Republic',
		'tcd' => 'Chad',
		'chl' => 'Chile',
		'chn' => 'China',
		'cxr' => 'Christmas Island',
		'cck' => 'Cocos (Keeling) Islands',
		'col' => 'Colombia',
		'com' => 'Comoros',
		'cok' => 'Cook Islands',
		'cri' => 'Costa Rica',
		'hrv' => 'Croatia',
		'cub' => 'Cuba',
		'cuw' => 'Curaçao',
		'cyp' => 'Cyprus',
		'cze' => 'Czech Republic',
		'cod' => 'Democratic Republic of the Congo',
		'dnk' => 'Denmark',
		'dji' => 'Djibouti',
		'dma' => 'Dominica',
		'dom' => 'Dominican Republic',
		'tls' => 'East Timor',
		'ecu' => 'Ecuador',
		'egy' => 'Egypt',
		'slv' => 'El Salvador',
		'gnq' => 'Equatorial Guinea',
		'eri' => 'Eritrea',
		'est' => 'Estonia',
		'swz' => 'Eswatini',
		'eth' => 'Ethiopia',
		'flk' => 'Falkland Islands',
		'fro' => 'Faroe Islands',
		'fsm' => 'Federated States of Micronesia',
		'fji' => 'Fiji',
		'fin' => 'Finland',
		'fra' => 'France',
		'guf' => 'French Guiana',
		'pyf' => 'French Polynesia',
		'atf' => 'French Southern and Antarctic Lands',
		'gab' => 'Gabon',
		'gmb' => 'Gambia',
		'geo' => 'Georgia',
		'deu' => 'Germany',
		'gha' => 'Ghana',
		'gib' => 'Gibraltar',
		'grc' => 'Greece',
		'grl' => 'Greenland',
		'grd' => 'Grenada',
		'glp' => 'Guadeloupe',
		'gum' => 'Guam',
		'gtm' => 'Guatemala',
		'ggy' => 'Guernsey',
		'gin' => 'Guinea',
		'gnb' => 'Guinea-Bissau',
		'guy' => 'Guyana',
		'hti' => 'Haiti',
		'hmd' => 'Heard Island and McDonald Islands',
		'hnd' => 'Honduras',
		'hkg' => 'Hong Kong',
		'hun' => 'Hungary',
		'isl' => 'Iceland',
		'ind' => 'India',
		'idn' => 'Indonesia',
		'irn' => 'Iran',
		'irq' => 'Iraq',
		'irl' => 'Ireland',
		'imn' => 'Isle of Man',
		'isr' => 'Israel',
		'ita' => 'Italy',
		'civ' => 'Ivory Coast',
		'jam' => 'Jamaica',
		'jpn' => 'Japan',
		'jey' => 'Jersey',
		'jor' => 'Jordan',
		'kaz' => 'Kazakhstan',
		'ken' => 'Kenya',
		'kir' => 'Kiribati',
		'xkx' => 'Kosovo',
		'kwt' => 'Kuwait',
		'kgz' => 'Kyrgyzstan',
		'lao' => 'Laos',
		'lva' => 'Latvia',
		'lbn' => 'Lebanon',
		'lso' => 'Lesotho',
		'lbr' => 'Liberia',
		'lby' => 'Libya',
		'lie' => 'Liechtenstein',
		'ltu' => 'Lithuania',
		'lux' => 'Luxembourg',
		'mac' => 'Macao',
		'mdg' => 'Madagascar',
		'mwi' => 'Malawi',
		'mys' => 'Malaysia',
		'mdv' => 'Maldives',
		'mli' => 'Mali',
		'mlt' => 'Malta',
		'mhl' => 'Marshall Islands',
		'mtq' => 'Martinique',
		'mrt' => 'Mauritania',
		'mus' => 'Mauritius',
		'myt' => 'Mayotte',
		'mex' => 'Mexico',
		'mda' => 'Moldova',
		'mco' => 'Monaco',
		'mng' => 'Mongolia',
		'mne' => 'Montenegro',
		'msr' => 'Montserrat',
		'mar' => 'Morocco',
		'moz' => 'Mozambique',
		'mmr' => 'Myanmar',
		'nam' => 'Namibia',
		'nru' => 'Nauru',
		'npl' => 'Nepal',
		'nld' => 'Netherlands',
		'ncl' => 'New Caledonia',
		'nzl' => 'New Zealand',
		'nic' => 'Nicaragua',
		'ner' => 'Niger',
		'nga' => 'Nigeria',
		'niu' => 'Niue',
		'nfk' => 'Norfolk Island',
		'prk' => 'North Korea',
		'mkd' => 'North Macedonia',
		'mnp' => 'Northern Mariana Islands',
		'nor' => 'Norway',
		'omn' => 'Oman',
		'pak' => 'Pakistan',
		'plw' => 'Palau',
		'pse' => 'Palestine',
		'pan' => 'Panama',
		'png' => 'Papua New Guinea',
		'pry' => 'Paraguay',
		'per' => 'Peru',
		'phl' => 'Philippines',
		'pcn' => 'Pitcairn Islands',
		'pol' => 'Poland',
		'prt' => 'Portugal',
		'pri' => 'Puerto Rico',
		'qat' => 'Qatar',
		'cog' => 'Republic of the Congo',
		'reu' => 'Réunion',
		'rou' => 'Romania',
		'rus' => 'Russia',
		'rwa' => 'Rwanda',
		'blm' => 'Saint Barthélemy',
		'shn' => 'Saint Helena, Ascension, and Tristan da Cunha',
		'kna' => 'Saint Kitts and Nevis',
		'lca' => 'Saint Lucia',
		'maf' => 'Saint Martin',
		'spm' => 'Saint Pierre and Miquelon',
		'vct' => 'Saint Vincent and the Grenadines',
		'wsm' => 'Samoa',
		'smr' => 'San Marino',
		'stp' => 'São Tomé and Príncipe',
		'sau' => 'Saudi Arabia',
		'sen' => 'Senegal',
		'srb' => 'Serbia',
		'syc' => 'Seychelles',
		'sle' => 'Sierra Leone',
		'sgp' => 'Singapore',
		'sxm' => 'Sint Maarten',
		'svk' => 'Slovakia',
		'svn' => 'Slovenia',
		'slb' => 'Solomon Islands',
		'som' => 'Somalia',
		'zaf' => 'South Africa',
		'sgs' => 'South Georgia and the South Sandwich Islands',
		'kor' => 'South Korea',
		'ssd' => 'South Sudan',
		'esp' => 'Spain',
		'lka' => 'Sri Lanka',
		'sdn' => 'Sudan',
		'sur' => 'Suriname',
		'sjm' => 'Svalbard and Jan Mayen',
		'swe' => 'Sweden',
		'che' => 'Switzerland',
		'syr' => 'Syria',
		'twn' => 'Taiwan',
		'tjk' => 'Tajikistan',
		'tza' => 'Tanzania',
		'tha' => 'Thailand',
		'tgo' => 'Togo',
		'tkl' => 'Tokelau',
		'ton' => 'Tonga',
		'tto' => 'Trinidad and Tobago',
		'tun' => 'Tunisia',
		'tur' => 'Turkey',
		'tkm' => 'Turkmenistan',
		'tca' => 'Turks and Caicos Islands',
		'tuv' => 'Tuvalu',
		'uga' => 'Uganda',
		'ukr' => 'Ukraine',
		'are' => 'United Arab Emirates',
		'gbr' => 'United Kingdom',
		'usa' => 'United States',
		'umi' => 'United States Minor Outlying Islands',
		'vir' => 'United States Virgin Islands',
		'ury' => 'Uruguay',
		'uzb' => 'Uzbekistan',
		'vut' => 'Vanuatu',
		'vat' => 'Vatican City',
		'ven' => 'Venezuela',
		'vnm' => 'Vietnam',
		'wlf' => 'Wallis and Futuna',
		'esh' => 'Western Sahara',
		'yem' => 'Yemen',
		'zmb' => 'Zambia',
		'zwe' => 'Zimbabwe'
	];

	/**
	 * Maps area codes to lists of country codes in ISO 3166 format.
	 *
	 * This constant defines geographic areas and their constituent countries using
	 * ISO country codes. It's used for area-based filtering and grouping operations.
	 *
	 * Structure:
	 * - Keys: Area identifiers (e.g. for a specific geographic region)
	 * - Values: Arrays of ISO country codes belonging to that area
	 *
	 * @var array<string, array<string>>
	 */
	public const AREA_CODES_TO_COUNTRY_CODES = [];
}
