# MiKTeX

The [MiKTeX Project Page](https://miktex.org) is the place to go, if
you are new to MiKTeX.

In short: MiKTeX is a modern C/C++ implementation of TeX & Friends for Windows, macOS and Linux. The MiKTeX source code is documented here:
[https://docs.miktex.org/hacking/index.html](https://docs.miktex.org/hacking/index.html)

MiKTeX is also a scalable TeX distribution (["Just enough TeX"](https://miktex.org/kb/just-enough-tex)):

- you have the option to start with MiKTeX executables and some configuration files
- in the course of authoring your documents, only necessary LaTeX packages, fonts etc.
  will be downloaded and installed

## Building

MiKTeX can be built on Windows and Unix-like (including macOS)
systems.  Please consult these HOWTOs for platform-specific build
instructions:

- [https://miktex.org/howto/build-win](https://miktex.org/howto/build-win "Building MiKTeX (Windows)")
- [https://miktex.org/howto/build-unx](https://miktex.org/howto/build-unx "Building MiKTeX (Unix-like)")
- [https://miktex.org/howto/build-mac](https://miktex.org/howto/build-mac "Building MiKTeX (macOS)")

In addition, you can try one of the Dockerized build environments to build MiKTeX:

- [Ubuntu](https://github.com/MiKTeX/docker-miktex-build-ubuntu)
- [Debian](https://github.com/MiKTeX/docker-miktex-build-debian)
- [Fedora](https://github.com/MiKTeX/docker-miktex-build-fedora)
- [openSUSE](https://github.com/MiKTeX/docker-miktex-build-opensuse)

## Deep diving

If you want to understand the MiKTeX source code, have a look at [HACKING.md](HACKING.md).
