static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "ac", .opt_idx = kOptAutocomplete },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "dia", .opt_idx = kOptDiffanchors },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "msc", .opt_idx = kOptMaxsearchcount },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "chi", .opt_idx = kOptChistory },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "lhi", .opt_idx = kOptLhistory },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "acl", .opt_idx = kOptAutocompletedelay },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "cto", .opt_idx = kOptCompletetimeout },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "act", .opt_idx = kOptAutocompletetimeout },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "pmw", .opt_idx = kOptPummaxwidth },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "list", .opt_idx = kOptList },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "busy", .opt_idx = kOptBusy },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "chistory", .opt_idx = kOptChistory },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "lhistory", .opt_idx = kOptLhistory },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "pumborder", .opt_idx = kOptPumborder },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "diffanchors", .opt_idx = kOptDiffanchors },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "pummaxwidth", .opt_idx = kOptPummaxwidth },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "autocomplete", .opt_idx = kOptAutocomplete },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "maxsearchcount", .opt_idx = kOptMaxsearchcount },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "completetimeout", .opt_idx = kOptCompletetimeout },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "autocompletedelay", .opt_idx = kOptAutocompletedelay },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
  { .name = "autocompletetimeout", .opt_idx = kOptAutocompletetimeout },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 17; break;
      case 'd': low = 17; high = 22; break;
      case 'e': low = 22; high = 25; break;
      case 'f': low = 25; high = 31; break;
      case 'g': low = 31; high = 33; break;
      case 'h': low = 33; high = 40; break;
      case 'i': low = 40; high = 49; break;
      case 'j': low = 49; high = 50; break;
      case 'k': low = 50; high = 52; break;
      case 'l': low = 52; high = 59; break;
      case 'm': low = 59; high = 66; break;
      case 'o': low = 66; high = 73; break;
      case 'p': low = 73; high = 81; break;
      case 'r': low = 81; high = 85; break;
      case 's': low = 85; high = 93; break;
      case 't': low = 93; high = 98; break;
      case 'u': low = 98; high = 101; break;
      case 'w': low = 101; high = 107; break;
      case 'x': low = 107; high = 108; break;
      case 'y': low = 108; high = 109; break;
      case 'z': low = 109; high = 110; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 110; high = 115; break;
      case 'b': low = 115; high = 120; break;
      case 'c': low = 120; high = 134; break;
      case 'd': low = 134; high = 142; break;
      case 'e': low = 142; high = 145; break;
      case 'f': low = 145; high = 157; break;
      case 'g': low = 157; high = 160; break;
      case 'h': low = 160; high = 165; break;
      case 'i': low = 165; high = 172; break;
      case 'k': low = 172; high = 177; break;
      case 'l': low = 177; high = 194; break;
      case 'm': low = 194; high = 207; break;
      case 'n': low = 207; high = 213; break;
      case 'o': low = 213; high = 220; break;
      case 'p': low = 220; high = 234; break;
      case 'q': low = 234; high = 236; break;
      case 'r': low = 236; high = 247; break;
      case 's': low = 247; high = 263; break;
      case 't': low = 263; high = 271; break;
      case 'u': low = 271; high = 276; break;
      case 'v': low = 276; high = 277; break;
      case 'w': low = 277; high = 285; break;
      case 'x': low = 285; high = 290; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 290; high = 291; break;
      case 'b': low = 291; high = 293; break;
      case 'c': low = 293; high = 298; break;
      case 'e': low = 298; high = 301; break;
      case 'f': low = 301; high = 304; break;
      case 'h': low = 304; high = 305; break;
      case 'k': low = 305; high = 308; break;
      case 'l': low = 308; high = 309; break;
      case 'n': low = 309; high = 311; break;
      case 'o': low = 311; high = 314; break;
      case 'p': low = 314; high = 319; break;
      case 'r': low = 319; high = 322; break;
      case 's': low = 322; high = 325; break;
      case 't': low = 325; high = 330; break;
      case 'u': low = 330; high = 332; break;
      case 'v': low = 332; high = 333; break;
      case 'w': low = 333; high = 335; break;
      case 'x': low = 335; high = 336; break;
      case 'y': low = 336; high = 337; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 337; high = 338; break;
      case 'b': low = 338; high = 339; break;
      case 'c': low = 339; high = 341; break;
      case 'd': low = 341; high = 342; break;
      case 'e': low = 342; high = 343; break;
      case 'f': low = 343; high = 345; break;
      case 'h': low = 345; high = 346; break;
      case 'l': low = 346; high = 347; break;
      case 'm': low = 347; high = 349; break;
      case 'p': low = 349; high = 350; break;
      case 'r': low = 350; high = 352; break;
      case 's': low = 352; high = 355; break;
      case 't': low = 355; high = 359; break;
      case 'v': low = 359; high = 360; break;
      case 'w': low = 360; high = 363; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 363; high = 364; break;
      case 'c': low = 364; high = 366; break;
      case 'd': low = 366; high = 367; break;
      case 'f': low = 367; high = 369; break;
      case 'h': low = 369; high = 370; break;
      case 'i': low = 370; high = 371; break;
      case 'k': low = 371; high = 372; break;
      case 'l': low = 372; high = 373; break;
      case 'm': low = 373; high = 375; break;
      case 'n': low = 375; high = 379; break;
      case 'o': low = 379; high = 380; break;
      case 'p': low = 380; high = 382; break;
      case 'r': low = 382; high = 383; break;
      case 'u': low = 383; high = 387; break;
      case 'v': low = 387; high = 388; break;
      case 'x': low = 388; high = 389; break;
      case 'y': low = 389; high = 390; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 390; high = 391; break;
      case 'b': low = 391; high = 393; break;
      case 'c': low = 393; high = 394; break;
      case 'd': low = 394; high = 395; break;
      case 'e': low = 395; high = 398; break;
      case 'f': low = 398; high = 401; break;
      case 'g': low = 401; high = 404; break;
      case 'i': low = 404; high = 406; break;
      case 'k': low = 406; high = 407; break;
      case 'l': low = 407; high = 410; break;
      case 'm': low = 410; high = 412; break;
      case 'n': low = 412; high = 416; break;
      case 'o': low = 416; high = 417; break;
      case 'p': low = 417; high = 418; break;
      case 'r': low = 418; high = 419; break;
      case 's': low = 419; high = 423; break;
      case 'y': low = 423; high = 424; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 424; high = 425; break;
      case 'c': low = 425; high = 429; break;
      case 'd': low = 429; high = 430; break;
      case 'e': low = 430; high = 432; break;
      case 'f': low = 432; high = 437; break;
      case 'g': low = 437; high = 438; break;
      case 'h': low = 438; high = 441; break;
      case 'i': low = 441; high = 443; break;
      case 'k': low = 443; high = 444; break;
      case 'l': low = 444; high = 446; break;
      case 'm': low = 446; high = 449; break;
      case 'o': low = 449; high = 450; break;
      case 'p': low = 450; high = 453; break;
      case 'r': low = 453; high = 454; break;
      case 's': low = 454; high = 459; break;
      case 't': low = 459; high = 466; break;
      case 'u': low = 466; high = 467; break;
      case 'w': low = 467; high = 474; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 474; high = 479; break;
      case 'c': low = 479; high = 483; break;
      case 'd': low = 483; high = 486; break;
      case 'e': low = 486; high = 493; break;
      case 'f': low = 493; high = 495; break;
      case 'h': low = 495; high = 499; break;
      case 'i': low = 499; high = 502; break;
      case 'l': low = 502; high = 507; break;
      case 'm': low = 507; high = 511; break;
      case 'n': low = 511; high = 515; break;
      case 'o': low = 515; high = 518; break;
      case 'p': low = 518; high = 521; break;
      case 'r': low = 521; high = 528; break;
      case 's': low = 528; high = 532; break;
      case 't': low = 532; high = 537; break;
      case 'u': low = 537; high = 540; break;
      case 'x': low = 540; high = 541; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 541; high = 548; break;
      case 'b': low = 548; high = 554; break;
      case 'c': low = 554; high = 556; break;
      case 'd': low = 556; high = 561; break;
      case 'e': low = 561; high = 568; break;
      case 'h': low = 568; high = 569; break;
      case 'i': low = 569; high = 575; break;
      case 'j': low = 575; high = 576; break;
      case 'k': low = 576; high = 578; break;
      case 'l': low = 578; high = 585; break;
      case 'm': low = 585; high = 588; break;
      case 'n': low = 588; high = 591; break;
      case 'o': low = 591; high = 595; break;
      case 'r': low = 595; high = 601; break;
      case 's': low = 601; high = 604; break;
      case 't': low = 604; high = 608; break;
      case 'u': low = 608; high = 609; break;
      case 'v': low = 609; high = 611; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 611; high = 615; break;
      case 'b': low = 615; high = 617; break;
      case 'c': low = 617; high = 619; break;
      case 'd': low = 619; high = 620; break;
      case 'e': low = 620; high = 625; break;
      case 'f': low = 625; high = 628; break;
      case 'g': low = 628; high = 629; break;
      case 'i': low = 629; high = 632; break;
      case 'l': low = 632; high = 634; break;
      case 'm': low = 634; high = 635; break;
      case 'n': low = 635; high = 638; break;
      case 'o': low = 638; high = 643; break;
      case 'p': low = 643; high = 648; break;
      case 'r': low = 648; high = 650; break;
      case 's': low = 650; high = 653; break;
      case 't': low = 653; high = 654; break;
      case 'u': low = 654; high = 655; break;
      case 'w': low = 655; high = 656; break;
      case 'x': low = 656; high = 660; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 660; high = 661; break;
      case 'c': low = 661; high = 662; break;
      case 'd': low = 662; high = 664; break;
      case 'e': low = 664; high = 669; break;
      case 'g': low = 669; high = 671; break;
      case 'k': low = 671; high = 672; break;
      case 'l': low = 672; high = 674; break;
      case 'm': low = 674; high = 675; break;
      case 'n': low = 675; high = 679; break;
      case 'o': low = 679; high = 680; break;
      case 'r': low = 680; high = 682; break;
      case 't': low = 682; high = 684; break;
      case 'x': low = 684; high = 686; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 686; high = 687; break;
      case 'b': low = 687; high = 688; break;
      case 'c': low = 688; high = 690; break;
      case 'e': low = 690; high = 693; break;
      case 'm': low = 693; high = 694; break;
      case 'n': low = 694; high = 696; break;
      case 'o': low = 696; high = 697; break;
      case 'r': low = 697; high = 698; break;
      case 't': low = 698; high = 700; break;
      case 'u': low = 700; high = 702; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 702; high = 703; break;
      case 'e': low = 703; high = 704; break;
      case 'f': low = 704; high = 706; break;
      case 'm': low = 706; high = 708; break;
      case 'p': low = 708; high = 709; break;
      case 'r': low = 709; high = 710; break;
      case 's': low = 710; high = 711; break;
      case 'v': low = 711; high = 712; break;
      case 'w': low = 712; high = 713; break;
      default: break;
    }
    break;
    case 15: switch (str[0]) {
      case 'c': low = 713; high = 714; break;
      case 't': low = 714; high = 715; break;
      default: break;
    }
    break;
    case 16: low = 715; high = 716; break;
    case 17: switch (str[0]) {
      case 'a': low = 716; high = 717; break;
      case 'c': low = 717; high = 718; break;
      default: break;
    }
    break;
    case 19: low = 718; high = 719; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


