/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.DOMTreeManager;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.SVGAttribute;
import io.sf.carte.echosvg.svggen.SVGAttributeMap;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGSyntax;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class DOMGroupManager
implements SVGSyntax,
ErrorConstants {
    public static final short DRAW = 1;
    public static final short FILL = 16;
    private GraphicContext gc;
    private DOMTreeManager domTreeManager;
    private SVGGraphicContext groupGC;
    private Element currentGroup;

    public DOMGroupManager(GraphicContext gc, DOMTreeManager domTreeManager) {
        if (gc == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (domTreeManager == null) {
            throw new SVGGraphics2DRuntimeException("domTreeManager should not be null");
        }
        this.gc = gc;
        this.domTreeManager = domTreeManager;
        this.recycleCurrentGroup();
        this.groupGC = domTreeManager.getGraphicContextConverter().toSVG(gc);
    }

    void recycleCurrentGroup() {
        this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
    }

    public void addElement(Element element) {
        this.addElement(element, (short)17);
    }

    public void addElement(Element element, short method) {
        this.addElement(element, method, null);
    }

    void addElement(Element element, short method, SVGGraphicContext elementGC) {
        if (!this.currentGroup.hasChildNodes()) {
            this.currentGroup.appendChild(element);
            this.groupGC = elementGC == null ? this.domTreeManager.getGraphicContextConverter().toSVG(this.gc) : elementGC;
            SVGGraphicContext deltaGC = DOMGroupManager.processDeltaGC(this.groupGC, this.domTreeManager.defaultGC);
            this.domTreeManager.getStyleHandler().setStyle(this.currentGroup, deltaGC.getGroupContext(), this.domTreeManager.getGeneratorContext());
            if ((method & 1) == 0) {
                deltaGC.getGraphicElementContext().put("stroke", "none");
            }
            if ((method & 0x10) == 0) {
                deltaGC.getGraphicElementContext().put("fill", "none");
            }
            this.domTreeManager.getStyleHandler().setStyle(element, deltaGC.getGraphicElementContext(), this.domTreeManager.getGeneratorContext());
            this.setTransform(this.currentGroup, deltaGC.getTransformStack());
            this.domTreeManager.appendGroup(this.currentGroup, this);
        } else if (this.gc.isTransformStackValid()) {
            if (elementGC == null) {
                elementGC = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
            }
            SVGGraphicContext deltaGC = DOMGroupManager.processDeltaGC(elementGC, this.groupGC);
            this.trimContextForElement(deltaGC, element);
            if (this.countOverrides(deltaGC) <= this.domTreeManager.maxGCOverrides) {
                this.currentGroup.appendChild(element);
                if ((method & 1) == 0) {
                    deltaGC.getContext().put("stroke", "none");
                }
                if ((method & 0x10) == 0) {
                    deltaGC.getContext().put("fill", "none");
                }
                this.domTreeManager.getStyleHandler().setStyle(element, deltaGC.getContext(), this.domTreeManager.getGeneratorContext());
                this.setTransform(element, deltaGC.getTransformStack());
            } else {
                this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
                this.addElement(element, method);
            }
        } else {
            this.currentGroup = this.domTreeManager.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
            this.gc.validateTransformStack();
            this.addElement(element, method);
        }
    }

    protected int countOverrides(SVGGraphicContext deltaGC) {
        return deltaGC.getGroupContext().size();
    }

    protected void trimContextForElement(SVGGraphicContext svgGC, Element element) {
        String tag = element.getTagName();
        Map<String, String> groupAttrMap = svgGC.getGroupContext();
        if (tag != null) {
            for (String attrName : groupAttrMap.keySet()) {
                SVGAttribute attr = SVGAttributeMap.get(attrName);
                if (attr == null || attr.appliesTo(tag)) continue;
                groupAttrMap.remove(attrName);
            }
        }
    }

    protected void setTransform(Element element, TransformStackElement[] transformStack) {
        String transform = this.domTreeManager.getGraphicContextConverter().toSVG(transformStack).trim();
        if (transform.length() > 0) {
            element.setAttributeNS(null, "transform", transform);
        }
    }

    static SVGGraphicContext processDeltaGC(SVGGraphicContext gc, SVGGraphicContext referenceGc) {
        Map<String, String> groupDelta = DOMGroupManager.processDeltaMap(gc.getGroupContext(), referenceGc.getGroupContext());
        Map<String, String> graphicElementDelta = gc.getGraphicElementContext();
        TransformStackElement[] gcTransformStack = gc.getTransformStack();
        TransformStackElement[] referenceStack = referenceGc.getTransformStack();
        int deltaStackLength = gcTransformStack.length - referenceStack.length;
        TransformStackElement[] deltaTransformStack = new TransformStackElement[deltaStackLength];
        System.arraycopy(gcTransformStack, referenceStack.length, deltaTransformStack, 0, deltaStackLength);
        SVGGraphicContext deltaGC = new SVGGraphicContext(groupDelta, graphicElementDelta, deltaTransformStack);
        return deltaGC;
    }

    static Map<String, String> processDeltaMap(Map<String, String> map, Map<String, String> referenceMap) {
        HashMap<String, String> mapDelta = new HashMap<String, String>();
        for (String key : map.keySet()) {
            String refValue;
            String value = map.get(key);
            if (value.equals(refValue = referenceMap.get(key))) continue;
            mapDelta.put(key, value);
        }
        return mapDelta;
    }
}

