/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataWrapper;
import gov.nasa.giss.data.nc.NcUtils;
import java.io.IOException;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcDataWrapperVar
implements NcDataWrapper {
    private VariableDS njvarDS_;

    public NcDataWrapperVar(VariableDS varDS) {
        this.njvarDS_ = varDS;
    }

    @Override
    public Object getSource() {
        return this.njvarDS_;
    }

    @Override
    public DataType getDataType() {
        return this.njvarDS_.getDataType();
    }

    @Override
    public String getShortName() {
        return this.njvarDS_.getShortName();
    }

    @Override
    public String getFullName() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getUnitsStr() {
        return NcUtils.getUnitsStr(this.njvarDS_);
    }

    @Override
    public int getRank() {
        return this.njvarDS_.getRank();
    }

    @Override
    public int[] getShape() {
        return this.njvarDS_.getShape();
    }

    @Override
    public Dimension getNjDimension(int index) {
        return this.njvarDS_.getDimension(index);
    }

    @Override
    public CoordinateSystem[] getNjCoordinateSystems() {
        List cslist = this.njvarDS_.getCoordinateSystems();
        if (cslist == null) {
            return new CoordinateSystem[0];
        }
        return cslist.toArray(new CoordinateSystem[0]);
    }

    @Override
    public double valueAt(int idx1) throws IOException {
        return Double.NaN;
    }

    @Override
    public double valueAt(int idx1, int idx2) throws IOException {
        return Double.NaN;
    }
}

