/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcGridder1D
extends NcGridder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private double bound1_;
    private double bound2_;
    protected NcAxisMethod axisMethod_ = NcAxisMethod.SCALAR;
    protected Unit axisUnits_;

    public void setAxisMethod(NcAxisMethod method) {
        this.axisMethod_ = method;
    }

    public void setAxisUnits(Unit unit) {
        LOGGER.trace("{}", (Object)this.axisUnits_);
        this.axisUnits_ = unit;
    }

    protected Converter getAxisUnitsConverter(NcArray1D nca1D) {
        Unit udunits = nca1D.getAxis().getUdunits();
        if (udunits == null) {
            return null;
        }
        try {
            return udunits.getConverterTo(this.axisUnits_);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public boolean setBounds(double[] bounds) {
        return this.setBounds(bounds[0], bounds[1]);
    }

    public boolean setBounds(double b1, double b2) {
        LOGGER.trace("{}, {}", (Object)b1, (Object)b2);
        this.bound1_ = b1;
        this.bound2_ = b2;
        return true;
    }

    public Point2D.Double[] regridAsIs(NcArray a) {
        double axval;
        NcArray1D nca = (NcArray1D)a;
        Converter axisUnitsConverter = this.getAxisUnitsConverter(nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis ax = nca.getAxis();
        boolean isLongitudeAxis = ax.isLongitudeAxis();
        double[] axvals = ax.getValues();
        ArrayList<Point2D.Double> clist = new ArrayList<Point2D.Double>(axvals.length);
        double lastAxval = axvals[0];
        double halfWidth = 0.5 * Math.abs(this.bound2_ - this.bound1_);
        for (int i = 0; i < axvals.length; ++i) {
            double axvalP1;
            double axvalM1 = i > 0 ? axvals[i - 1] : Double.NaN;
            axval = axvals[i];
            double d = axvalP1 = i < axvals.length - 1 ? axvals[i + 1] : Double.NaN;
            if (axisUnitsConverter != null) {
                if (!Double.isNaN(axvalM1)) {
                    axvalM1 = axisUnitsConverter.convert(axvalM1);
                }
                axval = axisUnitsConverter.convert(axval);
                if (!Double.isNaN(axvalP1)) {
                    axvalP1 = axisUnitsConverter.convert(axvalP1);
                }
            }
            if (axval < this.bound1_ && axval < this.bound2_) {
                if (isLongitudeAxis) {
                    while (axval < this.bound1_ && axval < this.bound2_) {
                        axval += 360.0;
                    }
                    if (axval > this.bound1_ && axval > this.bound2_) {
                        continue;
                    }
                } else if (i > 0 && i < axvals.length - 1 && axvalM1 < this.bound1_ && axvalM1 < this.bound2_ && axvalP1 < this.bound1_ && axvalP1 < this.bound2_) {
                    continue;
                }
            } else if (axval > this.bound1_ && axval > this.bound2_) {
                if (isLongitudeAxis) {
                    while (axval > this.bound1_ && axval > this.bound2_) {
                        axval -= 360.0;
                    }
                    if (axval < this.bound1_ && axval < this.bound2_) {
                        continue;
                    }
                } else if (i > 0 && i < axvals.length - 1 && axvalM1 > this.bound1_ && axvalM1 > this.bound2_ && axvalP1 > this.bound1_ && axvalP1 > this.bound2_) continue;
            }
            if (isLongitudeAxis && Math.abs(axval - lastAxval) > halfWidth) {
                if (Math.abs(axval - this.bound1_) < Math.abs(axval - this.bound2_)) {
                    clist.add(new Point2D.Double(this.bound1_, Double.NaN));
                } else {
                    clist.add(new Point2D.Double(this.bound2_, Double.NaN));
                }
            }
            double val = nca.valueAt(i);
            if (hasBad && nca.isMissingOrInvalid(val)) {
                val = Double.NaN;
            }
            clist.add(new Point2D.Double(axval, val));
            lastAxval = axval;
        }
        if (isLongitudeAxis) {
            double val0 = nca.valueAt(0);
            if (!hasBad || !nca.isMissingOrInvalid(val0)) {
                double axval0 = axvals[0];
                double axval1 = axvals[1];
                for (axval = axval0; axval < this.bound1_ && axval < this.bound2_; axval += 360.0) {
                }
                while (axval > this.bound1_ && axval > this.bound2_) {
                    axval -= 360.0;
                }
                if ((axval >= this.bound1_ && axval <= this.bound2_ || axval <= this.bound1_ && axval >= this.bound2_) && Math.abs(axval - lastAxval) <= 1.5 * Math.abs(axval1 - axval0)) {
                    clist.add(new Point2D.Double(axval, val0));
                }
            }
        }
        return clist.toArray(new Point2D.Double[0]);
    }
}

