/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class AdamsHemisphereInASquare
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "Adams Hemisphere in a Square";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double SQRT2_TIMES_K = 2.62205755429212;
    private static final double MAX_X_OVER_RS = 2.62205755429212;
    private static final double MAX_Y_OVER_RS = 2.62205755429212;
    private double sqrt2timesKRS_;

    public AdamsHemisphereInASquare(int width, int height) {
        this(width, height, 0, 0);
    }

    public AdamsHemisphereInASquare(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 2.62205755429212, 2.62205755429212);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.sqrt2timesKRS_ = 2.62205755429212 * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.sqrt2timesKRS_);
        }
        if (lat < -89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.sqrt2timesKRS_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double sinLambda = Math.sin(absLambdaRad);
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double cosPhi = Math.cos(absPhiRad);
        double sinPhi = Math.sin(absPhiRad);
        double cosA = cosPhi * sinLambda;
        double cosB = sinPhi;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhi + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhi - cosA < 0.0) {
            nnn = -nnn;
        }
        double xxx = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double yyy = Elliptic.ellipticF(nnn, 0.5000000000000001);
        double xx = 0.7071067811865476 * (xxx - yyy);
        double yy = 0.7071067811865476 * (xxx + yyy);
        if (lambdaRad < 0.0) {
            xx = -xx;
        }
        if (phiRad < 0.0) {
            yy = -yy;
        }
        double x = (double)this.outCenterX_ + xx * this.rS_;
        double y = (double)this.outCenterY_ - yy * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double absY;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        if (absX + (absY = Math.abs(y)) > this.sqrt2timesKRS_) {
            return null;
        }
        double xOverRS = absX * this.invRS_;
        double yOverRS = absY * this.invRS_;
        double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
        if (absLL == null || Double.isNaN(absLL[0]) || Double.isNaN(absLL[1])) {
            return null;
        }
        double lambda = x < 0.0 ? -absLL[0] : absLL[0];
        double phi = y < 0.0 ? -absLL[1] : absLL[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AdamsHemisphereInASquare adamsHemisphereInASquare = this;
        synchronized (adamsHemisphereInASquare) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double[] absLL;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && iy + ix <= this.dxMax_ && (absLL = this.transformAbsXYrs2LL(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    this.setInvPoints(ix, iy, absLL[0], absLL[1]);
                }
            }
        }
    }

    private double[] transformAbsXYrs2LL(double x, double y) {
        double cosB;
        double xx = 0.7071067811865476 * (x + y);
        double yy = 0.7071067811865476 * (-x + y);
        double[] jacobiM = Elliptic.jacobiSnCnDn(xx, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yy, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y > x ? Math.acos(cosAminusB) : -Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhi = cosB = Math.cos(b);
        double phiRad = Math.asin(sinPhi);
        double cosPhi = Math.cos(phiRad);
        double sinLambda = cosA / cosPhi;
        double lambdaRad = Math.asin(sinLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double dd = this.sqrt2timesKRS_;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(this.outCenterX_, (double)this.outCenterY_ - dd);
        path.lineTo((double)this.outCenterX_ + dd, this.outCenterY_);
        path.lineTo(this.outCenterX_, (double)this.outCenterY_ + dd);
        path.lineTo((double)this.outCenterX_ - dd, this.outCenterY_);
        path.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(path);
        g2x.dispose();
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            double ll = (double)this.outCenterX_ - this.sqrt2timesKRS_;
            double rr = (double)this.outCenterX_ + this.sqrt2timesKRS_;
            GraphicUtils.drawLine(g2d, ll, this.outCenterY_, rr, this.outCenterY_);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 89.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            super.drawMeridian(g2d, lon, maxLat, label);
        }
    }
}

