/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzimuthalFarSidePerspective
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Azimuthal Far-Side Perspective";
    public static final int PROPERTIES = 0x200040;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 120.0;
    private static final double DEFAULT_D = 1.7071067811865475;
    private final ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance between point of projection and center of body", "Proj. pt. distance", "Radii (D\u22651)", 1.7071067811865475, 1.0, Double.POSITIVE_INFINITY, true, true);
    private double dPerspective_ = 1.7071067811865475;
    private double oneOverD_ = 0.585786437626905;
    private double maxEdgeAngleRad_;
    private double cosMaxZ_;

    public AzimuthalFarSidePerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalFarSidePerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.addEdgeAngleParameter(90.0, 120.0, true);
        this.setAzimuthalFill(true);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.distParam_)) {
            this.setPerspectiveDistance(this.distParam_.getValue());
        }
    }

    private void setPerspectiveDistance(double d) {
        this.dPerspective_ = d;
        this.oneOverD_ = 1.0 / this.dPerspective_;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoEdgeOverR;
        double sinZ;
        double cosZ;
        this.maxEdgeAngleRad_ = Math.PI - Math.acos(this.oneOverD_);
        double maxEdgeAngle = Math.toDegrees(this.maxEdgeAngleRad_);
        LOGGER.trace("maxEdgeAngle {}", (Object)maxEdgeAngle);
        if (LOGGER.isTraceEnabled()) {
            cosZ = Math.cos(this.maxEdgeAngleRad_);
            sinZ = Math.sin(this.maxEdgeAngleRad_);
            rhoEdgeOverR = this.dPerspective_ * sinZ / (this.dPerspective_ + cosZ);
            LOGGER.trace("max rho  {}", (Object)rhoEdgeOverR);
        }
        if (LOGGER.isTraceEnabled()) {
            cosZ = Math.cos(this.edgeAngleRad_);
            sinZ = Math.sin(this.edgeAngleRad_);
            rhoEdgeOverR = this.dPerspective_ * sinZ / (this.dPerspective_ + cosZ);
            LOGGER.trace("clip rho {}", (Object)rhoEdgeOverR);
        }
        double angleRad = Math.min(this.maxEdgeAngleRad_, this.edgeAngleRad_);
        LOGGER.trace("using angle {}", (Object)Math.toDegrees(angleRad));
        this.cosMaxZ_ = Math.cos(angleRad);
        sinZ = Math.sin(angleRad);
        rhoEdgeOverR = this.dPerspective_ * sinZ / (this.dPerspective_ + this.cosMaxZ_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = Math.min(this.xmRS_, this.ymRS_);
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < this.cosMaxZ_) {
            return -1.0;
        }
        return this.dPerspective_ / (this.dPerspective_ + cosZ);
    }

    @Override
    protected final double getZRadForRho(double rho) {
        if (rho > this.rhoBorder_) {
            return Double.NaN;
        }
        double rhoOverRS = rho * this.invRS_;
        double dOverRho = this.dPerspective_ / rhoOverRS;
        double z = rhoOverRS * 1.5707963267948966;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = this.dPerspective_ + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

