/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.Circles;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConicProjection
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x200010;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private static final double DEFAULT_PHI1 = 60.0;
    private static final double DEFAULT_PHI2 = 30.0;
    private static final double DEFAULT_HEIGHT = Math.abs(30.0);
    protected double phi1_ = 60.0;
    protected double phi2_ = 30.0;
    protected double phiHeight_ = 1.5 * Math.abs(30.0);
    private Point2D.Double arcCenter_ = new Point2D.Double();
    private double arcOrientation_;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of first standard parallel", "Std. Par. 1", "\u00b0N", 60.0, -90.0, 90.0, true, true);
    private final ProjDoubleParameter phi2Param_ = new ProjDoubleParameter("Latitude of second standard parallel", "Std. Par. 2", "\u00b0N", 30.0, -90.0, 90.0, true, true);
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Height", "\u00b0", DEFAULT_HEIGHT, 0.002, 180.0, true, true);

    public ConicProjection(String name, int properties, int width, int height, int xmargin, int ymargin) {
        super(name, properties, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.phi2Param_);
        this.addParameter(this.hgtParam_);
    }

    public ProjDoubleParameter getHeightParameter() {
        return this.hgtParam_;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setStandardParallels(this.phi1Param_.getValue(), this.phi2Param_.getValue());
            this.setHeight(this.hgtParam_.getValue());
        } else if (p.equals(this.phi1Param_) || p.equals(this.phi2Param_)) {
            this.setStandardParallels(this.phi1Param_.getValue(), this.phi2Param_.getValue());
        } else if (p.equals(this.hgtParam_)) {
            this.setHeight(this.hgtParam_.getValue());
        } else {
            LOGGER.trace("Param not handled by ConicProjection. Perhaps a subclass does so.");
        }
    }

    private void setStandardParallels(double lat1, double lat2) {
        if (Math.abs(lat1) > 90.0) {
            throw new IllegalArgumentException("Standard parallel 1 outside valid range");
        }
        if (Math.abs(lat2) > 90.0) {
            throw new IllegalArgumentException("Standard parallel 2 outside valid range");
        }
        this.phi1_ = lat1;
        this.phi2_ = lat2;
        if (Math.abs(this.phi2_) > Math.abs(this.phi1_)) {
            double phiTemp = this.phi1_;
            this.phi1_ = this.phi2_;
            this.phi2_ = phiTemp;
        }
        if (this.phi1_ + this.phi2_ == 0.0) {
            this.phi2_ *= 0.99999;
        }
        this.autoscale();
    }

    private void setHeight(double h) {
        this.phiHeight_ = h;
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        double phiSum = this.phi1_ + this.phi2_;
        if (phiSum > 0.0) {
            this.arcOrientation_ = 90.0;
        } else if (phiSum < 0.0) {
            this.arcOrientation_ = -90.0;
        } else {
            this.arcOrientation_ = 0.0;
            this.arcCenter_ = null;
            return;
        }
        Point2D.Double pt1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 179.99999, 0.0);
        Point2D.Double pt2 = this.transformLL2XYIgnoreMargins(this.lambdaC_, 0.0);
        Point2D.Double pt3 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, 0.0);
        if (pt1 == null || pt2 == null || pt3 == null) {
            LOGGER.warn("Got a null point along equator when trying to calculate arc center");
            this.arcCenter_ = null;
            return;
        }
        this.arcCenter_ = Circles.getCenter(pt1, pt2, pt3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        this.drawParallelX(g2d, lat);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        this.drawMeridianX(g2d, lon, maxLat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.arcOrientation_ == 0.0) {
            return;
        }
        ArrayList<Point2D.Double> cropNP = this.drawParallelX(g2d, 90.0);
        ArrayList<Point2D.Double> cropSP = this.drawParallelX(g2d, -90.0);
        ArrayList<Point2D.Double> cropLeft = this.drawMeridianX(g2d, this.lambdaC_ - 179.99999, 90.0);
        ArrayList<Point2D.Double> cropPts = new ArrayList<Point2D.Double>(24);
        if (cropNP != null) {
            cropPts.addAll(cropNP);
        }
        if (cropSP != null) {
            cropPts.addAll(cropSP);
        }
        if (cropLeft != null) {
            cropPts.addAll(cropLeft);
        }
        for (int i = cropPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt = (Point2D.Double)cropPts.get(i);
            if (!(pt.x > (double)this.outCenterX_)) continue;
            cropPts.remove(i);
        }
        Rectangle2D.Double marginRect = this.getMarginRect0();
        double lMargin = marginRect.x;
        double tMargin = marginRect.y;
        double rMargin = marginRect.x + marginRect.width;
        double bMargin = marginRect.y + marginRect.height;
        PointLL topCenterLL = this.transformXY2LL(this.outCenterX_, tMargin);
        PointLL botCenterLL = this.transformXY2LL(this.outCenterX_, bMargin);
        PointLL topLeftLL = this.transformXY2LL(lMargin, tMargin);
        PointLL botLeftLL = this.transformXY2LL(lMargin, bMargin);
        for (int jj = 0; jj < 2; ++jj) {
            PointLL sideLL = jj == 0 ? topLeftLL : botLeftLL;
            PointLL centLL = jj == 0 ? topCenterLL : botCenterLL;
            double yMargin = jj == 0 ? tMargin : bMargin;
            Point2D.Double pt1 = null;
            Point2D.Double pt2 = null;
            if (sideLL != null) {
                pt1 = new Point2D.Double(lMargin, yMargin);
            }
            for (int i = cropPts.size() - 1; i >= 0; --i) {
                Point2D.Double pt = (Point2D.Double)cropPts.get(i);
                if (!(Math.abs(pt.y - yMargin) < 1.0E-5)) continue;
                if (pt1 == null) {
                    pt1 = pt;
                    continue;
                }
                pt2 = pt;
            }
            if (centLL != null) {
                pt2 = new Point2D.Double(this.outCenterX_, yMargin);
            }
            if (pt1 == null && pt2 == null) {
                String side = jj == 0 ? "top" : "bottom";
                LOGGER.trace("No crop points along {} margin", (Object)side);
                continue;
            }
            if (pt1 != null && pt2 != null) {
                if (centLL == null) {
                    GraphicUtils.drawLine(g2d, pt1, pt2);
                    pt1.x = 2.0 * (double)this.outCenterX_ - pt1.x;
                    pt2.x = 2.0 * (double)this.outCenterX_ - pt2.x;
                    GraphicUtils.drawLine(g2d, pt1, pt2);
                    continue;
                }
                pt2.x = 2.0 * (double)this.outCenterX_ - pt1.x;
                GraphicUtils.drawLine(g2d, pt1, pt2);
                continue;
            }
            String side = jj == 0 ? "top" : "bottom";
            LOGGER.trace("Somehow only one crop point along {} margin", (Object)side);
        }
        Point2D.Double pt1 = null;
        Point2D.Double pt2 = null;
        if (topLeftLL != null) {
            pt1 = new Point2D.Double(lMargin, tMargin);
        }
        for (int i = cropPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt = (Point2D.Double)cropPts.get(i);
            if (!(Math.abs(pt.x - lMargin) < 1.0E-5)) continue;
            if (pt1 == null) {
                pt1 = pt;
                continue;
            }
            pt2 = pt;
        }
        if (botLeftLL != null) {
            pt2 = new Point2D.Double(lMargin, bMargin);
        }
        if (pt1 == null && pt2 == null) {
            LOGGER.trace("No crop points along side margin");
        } else if (pt1 != null && pt2 != null) {
            GraphicUtils.drawLine(g2d, pt1, pt2);
            pt1.x = rMargin;
            pt2.x = rMargin;
            GraphicUtils.drawLine(g2d, pt1, pt2);
        } else {
            LOGGER.trace("Somehow only one crop point along side margin");
        }
    }

    private ArrayList<Point2D.Double> drawMeridianX(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
        if (dotN == null) {
            dotN = this.transformLL2XYIgnoreMargins(lon, maxLat - 1.0E-5);
        }
        if (dotS == null) {
            dotS = this.transformLL2XYIgnoreMargins(lon, -(maxLat - 1.0E-5));
        }
        if (dotN == null) {
            LOGGER.trace("NP looks bad");
            return null;
        }
        if (dotS == null) {
            LOGGER.trace("SP looks bad");
            return null;
        }
        return ProjGraphicUtils.drawCroppedLine(g2d, this, dotN, dotS);
    }

    private ArrayList<Point2D.Double> drawParallelX(Graphics2D g2d, double lat) {
        if (this.arcCenter_ == null) {
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 179.99999, lat);
            Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, lat);
            try {
                ProjGraphicUtils.drawCroppedLine(g2d, this, dot1, dot3);
            }
            catch (Exception exc) {
                LOGGER.debug("Unable to draw straight-line parallel for lat {}", (Object)lat);
            }
            return null;
        }
        Point2D.Double pt = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
        if (pt == null) {
            return null;
        }
        double radius = Math.abs(pt.y - this.arcCenter_.y);
        if (radius < 1.0E-5) {
            return null;
        }
        Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 179.99999, lat);
        Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
        Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, lat);
        try {
            return ProjGraphicUtils.drawCroppedCircularArc(g2d, this, dot1, dot2, dot3);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public LonLatEdges getBounds() {
        double llRight;
        double llLeft;
        int ix;
        PointLL ll;
        Rectangle2D.Double marginRect = this.getMarginRect0();
        double tMargin = marginRect.y;
        double rMargin = marginRect.x + marginRect.width;
        double bMargin = marginRect.y + marginRect.height;
        int ww = this.getWidth();
        int hh = this.getHeight();
        int wOver2 = ww / 2;
        int hOver2 = hh / 2;
        try {
            ll = this.transformXY2LL(wOver2, hOver2);
            if (ll == null) {
                return LonLatEdges.ENTIRE_GLOBE;
            }
        }
        catch (Exception exc) {
            return LonLatEdges.ENTIRE_GLOBE;
        }
        double xright = rMargin;
        double ytop = tMargin;
        double ybottom = bMargin;
        double tLat = Double.NaN;
        double bLat = Double.NaN;
        Point2D.Double xy = this.transformLL2XY(this.lambdaC_, 90.0);
        if (xy != null && xy.y > 0.0 && xy.y < (double)hh) {
            tLat = 90.0;
        }
        if (Double.isNaN(tLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.transformXY2LL(ix, ytop + 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(tLat) || lat > tLat) {
                        tLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(tLat)) {
                tLat = 90.0;
            }
        }
        if ((xy = this.transformLL2XY(this.lambdaC_, -90.0)) != null && xy.y > 0.0 && xy.y < (double)hh) {
            bLat = -90.0;
        }
        if (Double.isNaN(bLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.transformXY2LL(ix, ybottom - 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(bLat) || lat < bLat) {
                        bLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(bLat)) {
                bLat = -90.0;
            }
        }
        if (tLat > 89.0 || bLat < -89.0) {
            return LonLatEdges.ENTIRE_GLOBE;
        }
        double llTop = tLat + 1.0;
        double llBottom = bLat - 1.0;
        double dlon = -9999.0;
        if (ybottom - ytop < 10.0) {
            dlon = 180.0;
        } else {
            int jy = (int)ytop + 1;
            while ((double)jy < ybottom - 1.0) {
                ll = this.transformXY2LL(xright - 1.0, jy);
                if (ll == null) {
                    dlon = 180.0;
                    break;
                }
                double xlon = ll.getLon();
                if (xlon < this.lambdaC_) {
                    xlon += 360.0;
                }
                dlon = Math.max(dlon, xlon - this.lambdaC_);
                ++jy;
            }
        }
        if (dlon < 0.0) {
            dlon = 180.0;
        }
        if ((dlon += 1.0) > 180.0) {
            dlon = 180.0;
        }
        if (2.0 * dlon > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else {
            llLeft = this.lambdaC_ - dlon;
            llRight = this.lambdaC_ + dlon;
        }
        return new LonLatEdges(llLeft, llTop, llRight, llBottom);
    }
}

