/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.text.NumberFormat;

public class PointLL {
    private double lon_;
    private double lat_;
    private NumberFormat formatter_;

    public PointLL() {
        this(0.0, 0.0);
    }

    public PointLL(PointLL p) {
        this(p.getLon(), p.getLat());
    }

    public PointLL(double lon, double lat) {
        this.setLon(lon);
        this.setLat(lat);
    }

    public void setLon(double lon) {
        if (Double.isNaN(lon)) {
            throw new IllegalArgumentException("Longitude cannot be NaN.");
        }
        this.lon_ = PointLL.normalizeLon(lon);
    }

    public void setLat(double lat) {
        if (Double.isNaN(lat)) {
            throw new IllegalArgumentException("Latitude cannot be NaN.");
        }
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be between -90 and 90, inclusive.");
        }
        this.lat_ = lat;
    }

    public void set(PointLL p) {
        this.setLon(p.getLon());
        this.setLat(p.getLat());
    }

    public void set(double lon, double lat) {
        this.setLon(lon);
        this.setLat(lat);
    }

    public void setRadians(double lonRad, double latRad) {
        this.setLon(lonRad * 57.29577951308232);
        this.setLat(latRad * 57.29577951308232);
    }

    public double getLon() {
        return this.lon_;
    }

    public double getLonRad() {
        return this.lon_ * (Math.PI / 180);
    }

    public double getLat() {
        return this.lat_;
    }

    public double getLatRad() {
        return this.lat_ * (Math.PI / 180);
    }

    public static double normalizeLon(double lon) {
        double xlon;
        for (xlon = lon; xlon < -180.0; xlon += 360.0) {
        }
        while (xlon > 180.0) {
            xlon -= 360.0;
        }
        return xlon;
    }

    public static double normalizeLon360(double lon) {
        double xlon;
        for (xlon = lon; xlon < 0.0; xlon += 360.0) {
        }
        while (xlon > 360.0) {
            xlon -= 360.0;
        }
        return xlon;
    }

    public String toString() {
        return "PointLL[" + this.lon_ + ", " + this.lat_ + "]";
    }

    public String toString(int fracDigits) {
        if (this.formatter_ == null) {
            this.formatter_ = NumberFormat.getNumberInstance();
        }
        this.formatter_.setMinimumFractionDigits(fracDigits);
        this.formatter_.setMaximumFractionDigits(fracDigits);
        return this.formatter_.format(this.lon_) + "\u00b0E " + this.formatter_.format(this.lat_) + "\u00b0N";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PointLL)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PointLL ll = (PointLL)obj;
        return this.lon_ == ll.getLon() && this.lat_ == ll.getLat();
    }

    public boolean equals(PointLL pt) {
        if (pt == null) {
            return false;
        }
        if (pt == this) {
            return true;
        }
        return this.lon_ == pt.getLon() && this.lat_ == pt.getLat();
    }

    public PointLL copy() {
        return new PointLL(this.lon_, this.lat_);
    }

    public Object clone() {
        return this.copy();
    }

    public int hashCode() {
        return Double.valueOf(this.lon_).hashCode() + Double.valueOf(this.lat_).hashCode();
    }
}

