/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.cl.PCLDataset;
import gov.nasa.giss.panoply.cl.PCLPlot;
import gov.nasa.giss.panoply.cl.PCLPreferences;
import gov.nasa.giss.panoply.cl.PCLVariable;
import gov.nasa.giss.panoply.log.PanLoggingGroup;
import gov.nasa.giss.panoply.log.PanLoggingUtils;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PCLFactory getSharedInstance() {
        return Singleton.INSTANCE;
    }

    public PCLPlot createPlot(String ptypeStr, PCLVariable clvar) {
        return this.createPlot(ptypeStr, clvar, new String[]{null});
    }

    public PCLPlot createPlot(String ptypeStr, PCLVariable clvar, String ... axisInfo) {
        PanPlotType ptype = PanPlotType.matching(ptypeStr);
        if (ptype == null) {
            throw new IllegalArgumentException("Plot type '" + ptypeStr + "' is unknown.");
        }
        if (ptype == PanPlotType.LON_LAT || ptype == PanPlotType.LON_TIME || ptype == PanPlotType.LON_VERT || ptype == PanPlotType.LAT_TIME || ptype == PanPlotType.LAT_VERT || ptype == PanPlotType.TIME_LAT || ptype == PanPlotType.TIME_VERT || ptype == PanPlotType.LL_ZONAL || ptype == PanPlotType.LL_TRAJ) {
            return PCLPlot.createGeoreferencedPlot(ptypeStr, clvar);
        }
        if (axisInfo == null || axisInfo.length == 0) {
            throw new IllegalArgumentException("Insufficient axis info to create '" + ptypeStr + "' plot.");
        }
        if (axisInfo.length < 1 || axisInfo.length > 2) {
            throw new IllegalArgumentException("Crazy number (" + axisInfo.length + ") of axes specified.");
        }
        if (ptype == PanPlotType.GENERAL_CC) {
            if (axisInfo.length != 2) {
                throw new IllegalArgumentException("General color contour plots require two axes definitions.");
            }
            int xindex = -1;
            int yindex = -1;
            LOGGER.trace("x {}, y {}", (Object)axisInfo[0], (Object)axisInfo[1]);
            try {
                xindex = Integer.parseInt(axisInfo[0]) - 1;
                yindex = Integer.parseInt(axisInfo[1]) - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.trace("xindex {}, yindex {}", (Object)xindex, (Object)yindex);
            if (xindex > -1 && yindex > -1) {
                return PCLPlot.createGeneralCCPlot(ptypeStr, clvar, xindex, yindex);
            }
            return PCLPlot.createGeneralCCPlot(ptypeStr, clvar, axisInfo[0], axisInfo[1]);
        }
        if (ptype == PanPlotType.HORZ_LINE || ptype == PanPlotType.VERT_LINE) {
            if (axisInfo.length != 1) {
                throw new IllegalArgumentException("Line plots require one and only one axis definition.");
            }
            int index = -1;
            try {
                index = Integer.parseInt(axisInfo[0]);
                --index;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (index > -1) {
                return PCLPlot.createLinePlot(ptypeStr, clvar, index);
            }
            return PCLPlot.createLinePlot(ptypeStr, clvar, axisInfo[0]);
        }
        throw new IllegalArgumentException("Plot specification options make no sense to me.");
    }

    public void openColorTable(String fpath) {
        this.openColorTable(fpath, false);
    }

    public void openColorTable(String fpath, boolean importToLib) {
        File f = new File(fpath);
        if (!ColorTableFilenameFilter.isColorTableName(f)) {
            LOGGER.error("File name does not look like a color table.");
            return;
        }
        ColorTableResourceList reslist = PanResourceUtils.getColorTableList();
        reslist.addAlphabetic(null, importToLib, f);
    }

    public PCLDataset openDataset(String address) {
        return new PCLDataset(address);
    }

    public void openOverlay(String fpath) {
        this.openOverlay(fpath, false);
    }

    public void openOverlay(String fpath, boolean importToLib) {
        File f = new File(fpath);
        if (!OverlayFilenameFilter.isOverlayName(f)) {
            LOGGER.error("File name does not look like an overlay.");
            return;
        }
        OverlayResourceList reslist = PanResourceUtils.getOverlayList();
        reslist.addAlphabetic(null, importToLib, f);
    }

    public void printProjectionList() {
        System.out.println("Projections available for lon-lat map plots are:");
        for (String name : ProjectionFactory.getNormalizedNames()) {
            System.out.println(name);
        }
    }

    public void printProjectionInfo(String pname) {
        try {
            System.out.println(ProjectionFactory.describeProjection(pname));
        }
        catch (Exception exc) {
            if (exc.toString().toLowerCase().contains("unknown")) {
                System.out.println("There is no projection known by that name.");
            }
            System.out.printf("Exception querying for '%s': %s%n", pname, exc.toString());
        }
    }

    public void printColorTableList() {
        System.out.println("Color tables available for plots are:");
        for (String name : PanResourceUtils.getColorTableList().getNames()) {
            System.out.println(name);
        }
    }

    public void printOverlayList() {
        System.out.println("Overlays available for lon-lat plots are:");
        for (String name : PanResourceUtils.getOverlayList().getNames()) {
            System.out.println(name);
        }
    }

    public PCLPreferences getPreferences() {
        return PCLPreferences.getSharedInstance();
    }

    public void printMemory() {
        LOGGER.info("Max memory heap is {} MB", (Object)(Runtime.getRuntime().maxMemory() / 1000L / 1000L));
    }

    public void setLocale(String ... lname) {
        if (lname.length == 1) {
            Locale.setDefault(new Locale(lname[0]));
        } else if (lname.length == 2) {
            Locale.setDefault(new Locale(lname[0], lname[1]));
        } else if (lname.length == 3) {
            Locale.setDefault(new Locale(lname[0], lname[1], lname[2]));
        } else {
            LOGGER.warn("Bad parameter count for specifying locale.");
        }
        this.printLocale();
    }

    public void printLocale() {
        Locale locale = Locale.getDefault();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        System.out.printf("Locale is '%s'%n", locale.getDisplayName());
        System.out.printf("Locale language is '%s'%n", locale.getDisplayLanguage());
        System.out.printf("Locale country is '%s'%n", locale.getDisplayCountry());
        System.out.printf("Locale variant is '%s'%n", locale.getDisplayVariant());
        System.out.printf("Locale decimal character is '%s'%n", Character.valueOf(symbols.getDecimalSeparator()));
    }

    public void setLogLevel(String level) {
        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, level.toUpperCase());
    }

    private PCLFactory() {
    }

    private static class Singleton {
        private static final PCLFactory INSTANCE = new PCLFactory();

        private Singleton() {
        }
    }
}

