/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.desktop;

import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanQuitHandler;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.AppForegroundEvent;
import java.awt.desktop.AppForegroundListener;
import java.awt.desktop.AppHiddenEvent;
import java.awt.desktop.AppHiddenListener;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDesktopAdapter
implements AboutHandler,
AppForegroundListener,
AppHiddenListener,
OpenFilesHandler,
PreferencesHandler,
QuitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean initted_;

    public static void init() {
        if (!Desktop.isDesktopSupported()) {
            LOGGER.info("Desktop not supported on this platform.");
            return;
        }
        if (initted_) {
            LOGGER.info("Already initialized.");
            return;
        }
        PanDesktopAdapter adapter = new PanDesktopAdapter();
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.setAboutHandler(adapter);
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.info("Desktop About handler not supported on this platform.");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting About handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setOpenFileHandler(adapter);
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.info("Desktop OpenFile handler not supported on this platform.");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting OpenFile handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setPreferencesHandler(adapter);
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.info("Desktop Preferences handler not supported on this platform.");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting Preferences handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.setQuitHandler(adapter);
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.info("Desktop Quit handler not supported on this platform.");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting Quit handler: {}", (Object)exc.getClass());
        }
        try {
            desktop.addAppEventListener(adapter);
        }
        catch (UnsupportedOperationException exc) {
            LOGGER.info("Desktop AppEvent handler not supported on this platform.");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception setting AppEvent listener: {}", (Object)exc.getClass());
        }
        initted_ = true;
    }

    @Override
    public void handleAbout(AboutEvent e) {
        PanAboutFrame.getSharedInstance().reveal();
    }

    @Override
    public void openFiles(OpenFilesEvent e) {
        if (e == null) {
            return;
        }
        List<File> ff = e.getFiles();
        LOGGER.trace("Desktop handler reports {} files to open", (Object)ff.size());
        if (ff.isEmpty()) {
            return;
        }
        Panoply.setFilesRequested();
        PanFileUtils.openLocalFiles(null, ff.toArray(new File[0]));
    }

    @Override
    public void handlePreferences(PreferencesEvent e) {
        PanPreferencesFrame.getSharedInstance().reveal();
    }

    @Override
    public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
        LOGGER.debug("");
        PanQuitHandler.quit();
        LOGGER.debug("");
        response.performQuit();
    }

    @Override
    public void appMovedToBackground(AppForegroundEvent e) {
        PanPlotFrame.setAppInForeground(false);
        Frame[] frames = Frame.getFrames();
        if (frames.length > 0) {
            for (Frame f : frames) {
                if (f == null || !f.isVisible() || !(f instanceof PanPlotFrame)) continue;
                PanPlotFrame ppf = (PanPlotFrame)f;
                ppf.setWindoidsVisible(false);
            }
        }
    }

    @Override
    public void appRaisedToForeground(AppForegroundEvent e) {
        PanPlotFrame.setAppInForeground(true);
        boolean oneVis = false;
        for (Frame frame : Frame.getFrames()) {
            if (frame instanceof PanHiddenMacFrame || !frame.isVisible()) continue;
            oneVis = true;
            break;
        }
        if (!oneVis) {
            PanSourcesFrame.getSharedInstance().setVisible(true);
        }
        EventQueue.invokeLater(() -> {
            boolean animating = false;
            for (Frame f : Frame.getFrames()) {
                PanPlotFrame ppf;
                if (f == null || !f.isVisible() || !(f instanceof PanPlotFrame) || !(ppf = (PanPlotFrame)f).isAnimating()) continue;
                ppf.setWindoidsVisible(true);
                animating = true;
                break;
            }
            if (!animating) {
                JFrame f = GuiUtils.getActiveFrame();
                if (f == null || !f.isVisible()) {
                    return;
                }
                if (f instanceof PanPlotFrame) {
                    ((PanPlotFrame)f).setWindoidsVisible(true);
                }
            }
        });
    }

    @Override
    public void appHidden(AppHiddenEvent e) {
    }

    @Override
    public void appUnhidden(AppHiddenEvent e) {
    }

    private PanDesktopAdapter() {
    }
}

