/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanApplySavedSettingsAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.ui.menu.GissMenuUtils;

public class PanApplySavedSettingsMenu
extends PanMenu {
    public PanApplySavedSettingsMenu(PanFrame parent) {
        super(parent, "plot-apply-settings-menu");
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.removeAll();
        PanSavedSettingsHandler pssl = PanSavedSettingsHandler.getSharedInstance();
        int isze = pssl.getChildCount();
        if (isze < 1) {
            this.add(GissMenuUtils.makeItem(null, "No saved settings", null, null)).setEnabled(false);
            return;
        }
        PanPlotFrame pframe = this.pframe_ instanceof PanPlotFrame ? (PanPlotFrame)this.pframe_ : null;
        PanPlotMeta pmeta = pframe != null ? ((PanPlotFrame)this.pframe_).getMeta() : null;
        PanPlotType ptype = pmeta != null ? pmeta.getType() : null;
        for (int i = 0; i < isze; ++i) {
            PanSavedSettings pss = pssl.get(i);
            String iname = pss.getPlotType().name() + ": " + pss.getName();
            GissMenuItem jmi = GissMenuUtils.makeItem(null, iname, null, null);
            if (pmeta == null) {
                this.add(jmi).setEnabled(false);
                continue;
            }
            PanPlotType stype = pss.getPlotType();
            if (stype == ptype) {
                PanApplySavedSettingsAction a = new PanApplySavedSettingsAction(pframe, pss);
                jmi.setAction(a);
                this.add(jmi).setEnabled(true);
                continue;
            }
            this.add(jmi).setEnabled(false);
        }
    }
}

