/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanPlotHeightAction;
import gov.nasa.giss.panoply.action.PanShorterPlotAction;
import gov.nasa.giss.panoply.action.PanTallerPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotHeightFactor;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class PanPlotHeightMenu
extends PanMenu {
    private final JMenuItem miCurrentHeight_;
    private final JMenuItem miTaller_;
    private final JMenuItem miShorter_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotHeightMenu(PanFrame parent) {
        super(parent, "plot-height-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanPlotMeta pmeta = parentIsPlot ? ((PanPlotFrame)parent).getMeta() : null;
        this.miCurrentHeight_ = this.makeItemFromProperties("current-height", null);
        this.add(this.miCurrentHeight_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanTallerPlotAction(pmeta) : null;
        this.miTaller_ = this.makeItemFromProperties("show-taller", a);
        this.add(this.miTaller_).setEnabled(false);
        a = parentIsPlot ? new PanShorterPlotAction(pmeta) : null;
        this.miShorter_ = this.makeItemFromProperties("show-shorter", a);
        this.add(this.miShorter_).setEnabled(false);
        this.addSeparator();
        for (PanPlotHeightFactor pheight : PanPlotHeightFactor.values()) {
            String aid = pheight.getActionID();
            String atext = pheight.toString();
            PanPlotHeightAction a2 = parentIsPlot && aid != null ? new PanPlotHeightAction(pmeta, pheight) : null;
            GissCheckBoxMenuItem mi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(atext, mi);
            this.add(mi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame ppf = (PanPlotFrame)this.pframe_;
        boolean animating = PanPlotFrame.isAnimationInProgress();
        if (animating) {
            return;
        }
        PanPlotMeta pmeta = ppf.getMeta();
        int hf = pmeta.getInt("size.height");
        this.miCurrentHeight_.setText(PanProperties.MENU_PROPS.getString("current-height") + " = " + hf);
        this.miTaller_.setEnabled(hf < 400);
        this.miShorter_.setEnabled(hf > 20);
        for (String key : this.miPresetsHash_.keySet()) {
            JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
            String text = mi.getText();
            PanPlotHeightFactor pheight = PanPlotHeightFactor.matching(text);
            if (pheight == null) {
                mi.setSelected(false);
                continue;
            }
            mi.setSelected(pheight.getHeightFactor() == hf);
        }
    }
}

