/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class PanContourControls
extends PanControlsPanel {
    private DescribedEnumComboBox styleCombo_;
    private DescribedEnumComboBox locationCombo_;
    private ColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private JCheckBox labelVisCB_;
    private JLabel labelSizeLabel_;
    private FloatComboBox labelSizeCombo_;
    private boolean refreshing_;

    public PanContourControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("contour-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel locationLabel = new JLabel("Locations:\u2009");
        this.locationCombo_ = new DescribedEnumComboBox(PanContourLocation.class);
        this.locationCombo_.setName("contour.location");
        this.locationCombo_.setSelItemMatching(this.pmeta_.getString("contour.location"));
        QuickBox cbox1 = QuickBox.createLeftBox(locationLabel, this.locationCombo_);
        JLabel styleLabel = new JLabel("Style:\u2009");
        this.styleCombo_ = new DescribedEnumComboBox(PanContourStyle.class);
        this.styleCombo_.setName("contour.style");
        this.styleCombo_.setSelItemMatching(this.pmeta_.getString("contour.style"));
        QuickBox cbox2 = QuickBox.createLeftBox(styleLabel, this.styleCombo_);
        JLabel colorLabel = new JLabel("Color:\u2009");
        JLabel opacityLabel = new JLabel("\u2014 Weight:\u2009");
        JLabel cPctLabel = new JLabel("%");
        this.colorCombo_ = new ColorComboBox();
        this.colorCombo_.setName("contour.color");
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("contour.color"));
        this.weightSpinner_ = PanIntSpinner.smallWeight("contour.weight", this.pmeta_.getInt("contour.weight"), 0, 500);
        QuickBox cbox3 = QuickBox.createLeftBox(colorLabel, this.colorCombo_, opacityLabel, this.weightSpinner_, cPctLabel);
        JLabel labelLabel = new JLabel("Labels:\u2009");
        this.labelVisCB_ = new JCheckBox("Visible,", this.pmeta_.getBoolean("contour.label.vis"));
        this.labelVisCB_.setName("contour.label.vis");
        this.labelSizeLabel_ = new JLabel(" Size:\u2009");
        this.labelSizeCombo_ = FloatComboBox.create(5.0f, 12.0f);
        this.labelSizeCombo_.setName("contour.label.size");
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("contour.label.size"));
        PanContourStyle cstyle = PanContourStyle.matching(this.pmeta_.getString("contour.style"));
        this.labelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        QuickBox cbox4 = QuickBox.createLeftBox(labelLabel, this.labelVisCB_, this.labelSizeLabel_, this.labelSizeCombo_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(cbox1);
        this.add(Box.createVerticalStrut(1));
        this.add(cbox3);
        this.add(Box.createVerticalStrut(1));
        this.add(cbox2);
        this.add(Box.createVerticalStrut(1));
        this.add(cbox3);
        this.add(Box.createVerticalStrut(1));
        this.add(cbox4);
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(styleLabel, locationLabel, colorLabel, labelLabel);
    }

    private void attachListeners() {
        this.styleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanContourStyle cstyle = (PanContourStyle)this.styleCombo_.getSelectedItem();
            this.pmeta_.put("contour.style", (Object)cstyle.toString());
            this.labelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
            this.labelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
            this.labelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        });
        this.colorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.colorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("contour.color"))) {
                this.pmeta_.setColor("contour.color", cnew);
            }
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("contour.weight", this.weightSpinner_.getIntValue());
        });
        this.locationCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("contour.location", (Object)this.locationCombo_.getEnumName());
        });
        this.labelVisCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("contour.label.vis", this.labelVisCB_.isSelected());
        });
        this.labelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("contour.label.size", value);
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.styleCombo_.setSelItemMatching(this.pmeta_.getString("contour.style"));
        this.weightSpinner_.setValue(this.pmeta_.getInt("contour.weight"));
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("contour.color"));
        this.locationCombo_.setSelItemMatching(this.pmeta_.getString("contour.location"));
        this.labelVisCB_.setSelected(this.pmeta_.getBoolean("contour.label.vis"));
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("contour.label.size"));
        PanContourStyle cstyle = PanContourStyle.matching(this.pmeta_.getString("contour.style"));
        this.labelVisCB_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeLabel_.setEnabled(cstyle != PanContourStyle.NONE);
        this.labelSizeCombo_.setEnabled(cstyle != PanContourStyle.NONE);
        this.refreshing_ = false;
    }
}

