/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanUnderlayComboBox;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.SizeVariant;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class PanLonLatAlphaControls
extends PanControlsPanel {
    private PanCheckBox alphaEnabledCB_;
    private DescribedEnumComboBox alphaMethodCombo_;
    private PanIntSpinner[] alphaLevelSpinners_ = new PanIntSpinner[2];
    private PanCheckBox alphaKnockoutCB_;
    private PanUnderlayComboBox underlayCombo_;
    private boolean refreshing_;

    public PanLonLatAlphaControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("alpha-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.refreshEnable();
        this.attachListeners();
    }

    private void createLayout() {
        this.alphaEnabledCB_ = PanCheckBox.small("beta.alpha.enabled", "Enabled", this.pmeta_.getBoolean("beta.alpha.enabled"));
        QuickBox row1 = QuickBox.createLeftBox(this.alphaEnabledCB_);
        JLabel row2Label2 = new JLabel("Method:\u2009");
        this.alphaMethodCombo_ = new DescribedEnumComboBox(PanAlphaMethod.class);
        this.alphaMethodCombo_.setName("beta.alpha.method");
        if (this.ptype_.isLonLatTrajectory()) {
            this.alphaMethodCombo_.removeAllItems();
            this.alphaMethodCombo_.addItem(PanAlphaMethod.CONSTANT);
        }
        QuickBox row2 = QuickBox.createLeftBox(row2Label2, this.alphaMethodCombo_);
        JLabel row3Label2 = new JLabel("Min:\u2009");
        JLabel row3Label3 = new JLabel("%");
        JLabel row3Label4 = new JLabel(", Max:\u2009");
        JLabel row3Label5 = new JLabel("%");
        this.alphaLevelSpinners_[0] = PanIntSpinner.smallPct("beta.alpha.lavel.1", this.pmeta_.getInt("beta.alpha.lavel.1"));
        this.alphaLevelSpinners_[1] = PanIntSpinner.smallPct("beta.alpha.lavel.2", this.pmeta_.getInt("beta.alpha.lavel.2"));
        QuickBox row3 = QuickBox.createLeftBox(row3Label2, this.alphaLevelSpinners_[0], row3Label3, row3Label4, this.alphaLevelSpinners_[1], row3Label5);
        this.alphaKnockoutCB_ = PanCheckBox.small("beta.alpha.knockout", "Invalids are transparent", this.pmeta_.getBoolean("beta.alpha.knockout"));
        QuickBox row4 = QuickBox.createLeftBox(this.alphaKnockoutCB_);
        JLabel row5Label1 = new JLabel("Underlay:\u2009");
        this.underlayCombo_ = new PanUnderlayComboBox(SizeVariant.SMALL);
        QuickBox row5 = QuickBox.createLeftBox(row5Label1, this.underlayCombo_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(row1);
        this.add(row2);
        this.add(row3);
        this.add(row4);
        this.add(row5);
        GuiUtils.setSizeSmall(this);
    }

    private void attachListeners() {
        this.alphaEnabledCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("beta.alpha.enabled", e.getStateChange() == 1);
            this.refreshEnable();
        });
        this.alphaMethodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanAlphaMethod amethod = (PanAlphaMethod)this.alphaMethodCombo_.getSelectedItem();
            this.pmeta_.put("beta.alpha.method", (Object)amethod.name());
            this.refreshEnable();
        });
        this.alphaLevelSpinners_[0].addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            int ival = this.alphaLevelSpinners_[0].getIntValue();
            this.pmeta_.setInt("beta.alpha.lavel.1", ival);
        });
        this.alphaLevelSpinners_[1].addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            int ival = this.alphaLevelSpinners_[1].getIntValue();
            this.pmeta_.setInt("beta.alpha.lavel.2", ival);
        });
        if (this.alphaKnockoutCB_ != null) {
            if (this.refreshing_) {
                return;
            }
            this.alphaKnockoutCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.alpha.knockout", e.getStateChange() == 1));
        }
        this.underlayCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("beta.alpha.underlay", this.underlayCombo_.getSelectedItem());
            this.refreshEnable();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatAlphaControls panLonLatAlphaControls = this;
        synchronized (panLonLatAlphaControls) {
            this.underlayCombo_.flush();
            this.underlayCombo_ = null;
            super.flush();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.underlayCombo_.setSelectedItem(this.pmeta_.getString("beta.alpha.underlay"));
        this.alphaEnabledCB_.setSelected(this.pmeta_.getBoolean("beta.alpha.enabled"));
        if (this.ptype_ != PanPlotType.LL_TRAJ) {
            this.alphaMethodCombo_.setSelItemMatching(this.pmeta_.getString("beta.alpha.method"));
        }
        this.refreshing_ = false;
    }

    private void refreshEnable() {
        KMLData oo = this.underlayCombo_.getSelectedUnderlay();
        boolean cbenabled = this.alphaEnabledCB_.isSelected();
        boolean enabled = cbenabled && oo != null;
        PanAlphaMethod amethod = (PanAlphaMethod)this.alphaMethodCombo_.getSelectedItem();
        int acount = amethod.getAlphaCount();
        this.underlayCombo_.setEnabled(this.alphaEnabledCB_.isSelected());
        this.alphaMethodCombo_.setEnabled(enabled);
        this.alphaLevelSpinners_[0].setEnabled(enabled);
        this.alphaLevelSpinners_[1].setEnabled(enabled && acount > 1);
        if (this.alphaKnockoutCB_ != null) {
            this.alphaKnockoutCB_.setEnabled(enabled);
        }
        this.repaint();
    }
}

