/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PanHistoryPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Integer[] DAYS = new Integer[]{1, 2, 3, 7, 14, 30, 45, 60, 90, 180, 365};
    private JComboBox<Integer> daysCombo_;
    private boolean refreshing_;

    public PanHistoryPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.daysCombo_ = new JComboBox<Integer>(DAYS);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("History"));
        this.add(QuickBox.createLeftBox(new JLabel("Remove history items after "), this.daysCombo_, new JLabel(" days")));
        this.daysCombo_.setMaximumSize(this.daysCombo_.getPreferredSize());
    }

    private void attachListeners() {
        this.daysCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Integer days = (Integer)this.daysCombo_.getSelectedItem();
            prefs_.setInt("files:history.days", days);
            PanHistoryList.getSharedInstance().enforceAgeLimit();
            GuiUtils.refreshFrontFrameMenuBar();
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.daysCombo_.setSelectedItem(prefs_.getInt("files:history.days"));
        this.refreshing_ = false;
    }
}

