/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.Pan1DGridPrefsPanel;
import gov.nasa.giss.panoply.prefsui.Pan2DGridPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanBetaPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorContourPlotPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorTableLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorbarPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanContourPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanDataPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanDnvLayoutPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanHistoryPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLabelsPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLatTimePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLatVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLayoutPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLinePlotStrokePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonLatGridPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonLatOverlaysPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonLatProjectionPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonTimePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanMainAlphaPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanOpenFilePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanOverlayLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanPlotControlsPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanProjectionLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanSaveFilePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanSavedSettingsPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanScalePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanShadingPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTimeLatPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTimeVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTrajectoryPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanUnderlayPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanUnitsPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanVectorPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanVersionPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanZonalAveragePlotPrefsPanel;
import gov.nasa.giss.panoply.ui.PanContentPanel;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPreferencesFrame
extends PanFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DefaultListModel<PrefGroupContainer> pgcModel_;
    private JList<PrefGroupContainer> pgcList_;
    private JScrollPane scrollpane_;
    private JButton prevBtn_;
    private JButton nextBtn_;
    private JButton resetBtn_;
    private JPanel currentPanel_;
    private boolean betaVis_;
    private PrefGroupContainer beta1_;
    private PrefGroupContainer beta2_;
    private PrefGroupContainer beta3_;
    private static boolean exists_;

    public static PanPreferencesFrame getSharedInstance() {
        PanPreferencesFrame instance = Singleton.INSTANCE;
        exists_ = true;
        return instance;
    }

    public static boolean instanceExists() {
        return exists_;
    }

    private PanPreferencesFrame() {
        super("Preferences");
        this.setName(this.getTitle());
        this.setResizable(false);
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
        this.attachListeners();
        this.attachAltActions();
    }

    private void createLayout() {
        PrefGroupContainer pgc;
        this.pgcModel_ = new DefaultListModel();
        if (PanUtils.isBeta()) {
            this.pgcModel_.addElement(new PrefGroupContainer("Interface", new PanPlotControlsPrefsPanel(), new PanDnvLayoutPrefsPanel()));
            this.pgcModel_.addElement(new PrefGroupContainer("Layout & Labels", new PanLayoutPrefsPanel(), new PanLabelsPrefsPanel()));
        } else {
            this.pgcModel_.addElement(new PrefGroupContainer("Layout & Labels", new PanPlotControlsPrefsPanel(), new PanLayoutPrefsPanel(), new PanLabelsPrefsPanel()));
        }
        this.pgcModel_.addElement(new PrefGroupContainer("Data & Scale", new PanDataPrefsPanel(), new PanScalePrefsPanel(), new PanColorbarPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Grid", new Pan2DGridPrefsPanel(), new Pan1DGridPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Map Projection", new PanLonLatProjectionPrefsPanel(), new PanLonLatGridPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Map Overlay", new PanLonLatOverlaysPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Map Shading", new PanShadingPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Other Georef Plots", new PanLatVertPrefsPanel(), new PanLonVertPrefsPanel(), new PanTimeVertPrefsPanel(), new PanLatTimePrefsPanel(), new PanLonTimePrefsPanel(), new PanTimeLatPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Other Color Contour Plots", new PanColorContourPlotPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Line Plots", new PanLinePlotStrokePrefsPanel(), new PanZonalAveragePlotPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Trajectories", new PanTrajectoryPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Contours & Vectors", new PanContourPrefsPanel(), new PanVectorPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Units", new PanUnitsPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Files", new PanOpenFilePrefsPanel(), new PanSaveFilePrefsPanel(), new PanHistoryPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Update", new PanVersionPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Color Tables", new PanColorTableLibPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Map Projections", new PanProjectionLibPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Map Overlays", new PanOverlayLibPrefsPanel()));
        if (PanUtils.isDevoSavedSettings()) {
            this.pgcModel_.addElement(new PrefGroupContainer("Library: Saved Settings", new PanSavedSettingsPrefsPanel()));
        }
        if (PanUtils.isBeta()) {
            this.beta1_ = new PrefGroupContainer("Beta Features", new PanBetaPrefsPanel());
            this.beta2_ = new PrefGroupContainer("Beta: Map Alpha & Underlay", new PanMainAlphaPrefsPanel());
            this.beta3_ = new PrefGroupContainer("Beta: Library: Map Underlays", new PanUnderlayPrefsPanel());
            this.pgcModel_.addElement(this.beta1_);
            this.pgcModel_.addElement(this.beta2_);
            this.pgcModel_.addElement(this.beta3_);
        }
        Dimension asize = new Dimension();
        for (Object oo : this.pgcModel_.toArray()) {
            pgc = (PrefGroupContainer)oo;
            String pname = pgc.toString();
            Dimension psize = pgc.getPanel().getPreferredSize();
            asize.width = Math.max(asize.width, psize.width);
            if (pname.contains("Library") || pname.contains("Projections") || pname.contains("Beta")) continue;
            asize.height = Math.max(asize.height, psize.height);
        }
        asize.height += 40;
        asize.width = Math.min(720, asize.width);
        for (Object oo : this.pgcModel_.toArray()) {
            pgc = (PrefGroupContainer)oo;
            JPanel jp = pgc.getPanel();
            jp.setMaximumSize(asize);
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean bl = this.betaVis_ = prefs.getBoolean("beta:underlays") || prefs.getBoolean("beta:numberlays");
        if (!this.betaVis_) {
            this.pgcModel_.removeElement(this.beta1_);
            this.pgcModel_.removeElement(this.beta2_);
            this.pgcModel_.removeElement(this.beta3_);
        }
        this.pgcList_ = new JList<PrefGroupContainer>(this.pgcModel_);
        this.scrollpane_ = new JScrollPane(this.pgcList_);
        Dimension bsize = this.scrollpane_.getPreferredSize();
        bsize.height = Math.max(bsize.height, asize.height);
        this.scrollpane_.setMinimumSize(bsize);
        this.scrollpane_.setPreferredSize(bsize);
        this.currentPanel_ = new JPanel();
        this.currentPanel_.setLayout(new BorderLayout());
        this.currentPanel_.setOpaque(false);
        this.currentPanel_.setMinimumSize(asize);
        this.currentPanel_.setPreferredSize(asize);
        this.pgcList_.setSelectedIndex(0);
        this.setCurrentPanel(0);
        this.prevBtn_ = new JButton("Prev");
        this.nextBtn_ = new JButton("Next");
        this.resetBtn_ = new JButton("Reset");
        QuickBox navbox = QuickBox.createTopBox(this.prevBtn_, this.nextBtn_);
        PanContentPanel mainContent = new PanContentPanel(PanGuiUtils.STD_BORDER);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 8, 2);
        fgl.setRowWeight(2, 999999.0f);
        mainContent.setLayout(fgl);
        mainContent.add((Component)this.scrollpane_, new FGConstraint(0, 0, 1, 4, 1.0, 0.0));
        mainContent.add((Component)this.currentPanel_, new FGConstraint(1, 0, 1, 4, 1.0, 0.0));
        mainContent.add((Component)navbox, new FGConstraint(2, 0, 1, 1, 0.5, 0.0));
        mainContent.add((Component)this.resetBtn_, new FGConstraint(2, 3, 1, 1, 0.5, 1.0));
        JPanel allContent = new JPanel();
        allContent.setBorder(PanGuiUtils.NO_BORDER);
        allContent.setLayout(new BoxLayout(allContent, 1));
        allContent.add(mainContent);
        allContent.add(this.statusBar_);
        this.getContentPane().add(allContent);
        this.currentPanel_.setOpaque(false);
        mainContent.setOpaque(false);
        allContent.setOpaque(false);
        this.pack();
    }

    private void attachListeners() {
        this.pgcList_.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = PanPreferencesFrame.this.pgcList_.getSelectedIndex();
                PanPreferencesFrame.this.setCurrentPanel(index);
            }
        });
        this.prevBtn_.addActionListener(e -> {
            int newindex = this.pgcList_.getSelectedIndex() - 1;
            if (newindex < 0) {
                this.pgcList_.setSelectedIndex(this.pgcList_.getModel().getSize() - 1);
            } else {
                this.pgcList_.setSelectedIndex(newindex);
            }
        });
        this.nextBtn_.addActionListener(e -> {
            int newindex = this.pgcList_.getSelectedIndex() + 1;
            if (newindex < this.pgcList_.getModel().getSize()) {
                this.pgcList_.setSelectedIndex(newindex);
            } else {
                this.pgcList_.setSelectedIndex(0);
            }
        });
        this.resetBtn_.addActionListener(e -> this.handleReset());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    int index = PanPreferencesFrame.this.pgcList_.locationToIndex(e.getPoint());
                    PanPreferencesFrame.this.setCurrentPanel(index);
                }
            }
        };
        this.pgcList_.addMouseListener(ml);
    }

    private void attachAltActions() {
        InputMap im = this.scrollpane_.getInputMap(2);
        ActionMap am = this.scrollpane_.getActionMap();
        ToggleBetaFeaturesAction a = new ToggleBetaFeaturesAction();
        PanGuiUtils.attachKeyStrokeAction(a, "toggle-beta-prefs", im, am);
    }

    void setCurrentPanel(int index) {
        PrefGroupContainer item = this.pgcList_.getModel().getElementAt(index);
        item.refresh();
        JPanel panel = item.getPanel();
        panel.invalidate();
        this.currentPanel_.removeAll();
        this.currentPanel_.add((Component)panel, "North");
        this.currentPanel_.validate();
        this.repaint();
    }

    void toggleBetaFeatures() {
        boolean bl = this.betaVis_ = !this.betaVis_;
        if (this.betaVis_) {
            this.pgcModel_.addElement(this.beta1_);
            this.pgcModel_.addElement(this.beta2_);
            this.pgcModel_.addElement(this.beta3_);
        } else {
            PrefGroupContainer pgc;
            int index = this.pgcList_.getSelectedIndex();
            if (index > -1 && ((pgc = this.pgcList_.getModel().getElementAt(index)).equals(this.beta1_) || pgc.equals(this.beta2_) || pgc.equals(this.beta3_))) {
                this.pgcList_.setSelectedIndex(0);
            }
            this.pgcModel_.removeElement(this.beta1_);
            this.pgcModel_.removeElement(this.beta2_);
            this.pgcModel_.removeElement(this.beta3_);
        }
        this.repaint();
    }

    @Override
    public void refresh() {
        super.refresh();
        for (Object oo : this.pgcModel_.toArray()) {
            PrefGroupContainer pgc = (PrefGroupContainer)oo;
            pgc.refresh();
        }
    }

    private void handleReset() {
        Object[] options = new String[]{"Yes", "Cancel"};
        int choice = JOptionPane.showOptionDialog(this, "Are you sure want to reset all Panoply preferences to the \n'factory defaults'? This will not remove any color tables\nor overlays that you may have imported.", "Preferences", 0, 3, null, options, options[0]);
        if (choice == 0) {
            PanPreferences.getSharedInstance().restoreDefaults();
            this.refresh();
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis) {
            PanQuitWatcher.quitIfNone();
        }
    }

    class ToggleBetaFeaturesAction
    extends AbstractAction {
        ToggleBetaFeaturesAction() {
            super("Toggle Beta Features");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanPreferencesFrame.this.toggleBetaFeatures();
        }
    }

    class PrefGroupContainer {
        private final String name_;
        private final JPanel panel_;

        PrefGroupContainer(String name, JPanel ... subpanels) {
            this.name_ = name;
            this.panel_ = new JPanel();
            this.panel_.setLayout(new BoxLayout(this.panel_, 1));
            this.panel_.setOpaque(false);
            this.panel_.setBorder(PanGuiUtils.NO_BORDER);
            for (JPanel jp : subpanels) {
                this.panel_.add(jp);
                this.panel_.add(Box.createVerticalStrut(2));
            }
            this.panel_.add(Box.createVerticalGlue());
            this.panel_.add(Box.createVerticalGlue());
            this.panel_.setOpaque(false);
        }

        public void refresh() {
            for (Component child : this.panel_.getComponents()) {
                if (!(child instanceof PanAbstractPrefsPanel)) continue;
                ((PanAbstractPrefsPanel)child).refresh();
            }
        }

        public String toString() {
            return this.name_;
        }

        public JPanel getPanel() {
            return this.panel_;
        }
    }

    private static class Singleton {
        private static final PanPreferencesFrame INSTANCE = new PanPreferencesFrame();

        private Singleton() {
        }
    }
}

