/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.panoply.util.PanQuitHandler;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanQuitWatcher
extends TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean busy_;

    @Override
    public void run() {
        PanQuitWatcher.quitIfNone();
    }

    public static void quitIfNone() {
        if (busy_) {
            return;
        }
        if (PlatformUtils.isMacintosh()) {
            return;
        }
        busy_ = true;
        for (Window ww : Window.getWindows()) {
            if (!ww.isVisible()) continue;
            busy_ = false;
            return;
        }
        LOGGER.trace("Calling it quits");
        busy_ = false;
        PanQuitHandler.quit();
    }
}

