/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.JulianType;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class JulianTime
implements UnixTimeFormatter {
    private JulianType epoch_ = JulianType.SIMPLE;
    private SimpleDateFormat dtFormat_;
    private JDCalendar calendar_ = new JDCalendar();

    public JulianTime() {
        this(JulianType.SIMPLE);
    }

    public JulianTime(JulianType epoch) {
        this.dtFormat_ = new SimpleDateFormat();
        this.dtFormat_.setCalendar(this.calendar_);
        this.applyPattern("yyyy-MM-dd HH");
        this.setEpoch(epoch);
    }

    public final void setEpoch(JulianType epoch) {
        this.epoch_ = epoch;
    }

    @Override
    public String getPattern() {
        return this.dtFormat_.toPattern();
    }

    @Override
    public final void applyPattern(String pattern) {
        Objects.requireNonNull(pattern, "Pattern may not be null.");
        this.dtFormat_.applyPattern(pattern);
    }

    @Override
    public String format(Number jdate) {
        return this.format(jdate.doubleValue());
    }

    @Override
    public String format(long jdate) {
        return this.format((double)jdate);
    }

    @Override
    public String format(double jdate) {
        if (Double.isNaN(jdate)) {
            throw new IllegalArgumentException("Cannot format an NaN value.");
        }
        if (Double.isInfinite(jdate)) {
            throw new IllegalArgumentException("Cannot format an infinite value.");
        }
        this.calendar_.setJulianDate(this.epoch_, jdate);
        return this.dtFormat_.format(this.calendar_.getTime());
    }
}

