/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import javax.swing.JProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusProgressBar
extends JProgressBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color FILL = new Color(49, 157, 255, 0);
    private static final Color OUTLINE = new Color(51, 51, 51, 102);
    private boolean active_;

    public void setActive(boolean active) {
        this.active_ = active;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.active_) {
            return;
        }
        if (PlatformUtils.isMacintosh()) {
            int ttt = (int)(System.currentTimeMillis() / 6L % 300L);
            int alpha = 100 + (ttt < 150 ? ttt : 300 - ttt);
            Color ccc = ColorUtils.deriveColorAlpha(FILL, alpha);
            Rectangle rr = this.getBounds();
            Insets ins = this.getInsets();
            int width1 = rr.width;
            int width2 = width1 - ins.left - ins.right - 4;
            int height1 = rr.height;
            int height2 = height1 - ins.top - ins.bottom;
            int height3 = Math.min(height1 - 2, Math.min(8, height2));
            int dheight = height1 > height3 ? (height1 - height3) / 2 : 0;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(ccc);
            GraphicUtils.fillRect(g2d, ins.left + 1, ins.top + dheight, width2, height3);
            g2d.setColor(OUTLINE);
            GraphicUtils.drawRect(g2d, ins.left + 1, ins.top + dheight, width2, height3);
        } else {
            super.paintComponent(g);
        }
    }
}

