/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.treetable.TreeTableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.Icon;

public abstract class TreeTableNode {
    private TreeTableNode parent_;
    private ArrayList<TreeTableNode> children_;

    public TreeTableNode() {
        if (this.getAllowsChildren()) {
            this.children_ = new ArrayList(20);
        }
    }

    public Enumeration<TreeTableNode> children() {
        Enumeration<TreeTableNode> e = Collections.enumeration(this.children_);
        return e;
    }

    public abstract boolean getAllowsChildren();

    public TreeTableNode getChildAt(int index) {
        return this.children_.get(index);
    }

    public TreeTableNode[] getChildren() {
        if (this.children_ == null) {
            return null;
        }
        return this.children_.toArray(new TreeTableNode[0]);
    }

    public int getChildCount() {
        if (this.children_ == null) {
            return 0;
        }
        return this.children_.size();
    }

    public int getIndex(TreeTableNode child) {
        int isize = this.getChildCount();
        for (int i = 0; i < isize; ++i) {
            if (!this.getChildAt(i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public TreeTableNode getParent() {
        return this.parent_;
    }

    public boolean isLeaf() {
        if (this.getAllowsChildren()) {
            return this.getChildCount() == 0;
        }
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public Icon getIcon() {
        return null;
    }

    public void setParent(TreeTableNode parent) {
        this.parent_ = parent;
    }

    public TreeTableNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    private TreeTableNode[] getPathToRoot(TreeTableNode node, int depth) {
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            return new TreeTableNode[depth];
        }
        TreeTableNode[] retNodes = this.getPathToRoot(node.getParent(), ++depth);
        retNodes[retNodes.length - depth] = node;
        return retNodes;
    }

    public TreeTableNode getRoot() {
        TreeTableNode[] ptr = this.getPath();
        if (ptr == null || ptr.length == 0) {
            return this;
        }
        return ptr[0];
    }

    public boolean isNodeAncestor(TreeTableNode anotherNode) {
        if (anotherNode == this || anotherNode == null) {
            return true;
        }
        TreeTableNode[] ptr = this.getPath();
        if (ptr == null) {
            return false;
        }
        for (TreeTableNode node : ptr) {
            if (anotherNode != node) continue;
            return true;
        }
        return false;
    }

    public void add(TreeTableNode node) {
        Objects.requireNonNull(node, "Child node cannot be null.");
        if (!this.getAllowsChildren()) {
            throw new TreeTableException("Node does not allow children.");
        }
        this.children_.add(node);
        node.setParent(this);
    }

    public void add(int index, TreeTableNode node) {
        Objects.requireNonNull(node, "Child node cannot be null.");
        if (!this.getAllowsChildren()) {
            throw new TreeTableException("Node does not allow children.");
        }
        this.children_.add(index, node);
        node.setParent(this);
    }

    public TreeTableNode remove(int index) {
        if (!this.getAllowsChildren()) {
            throw new TreeTableException("Node does not allow children.");
        }
        return this.children_.remove(index);
    }

    public TreeTableNode remove(TreeTableNode child) {
        if (!this.getAllowsChildren()) {
            throw new TreeTableException("Node does not allow children.");
        }
        int cindex = this.getIndex(child);
        if (cindex < 0) {
            throw new TreeTableException("Not a child of this node.");
        }
        return this.remove(cindex);
    }

    public void clear() {
        if (!this.getAllowsChildren()) {
            throw new TreeTableException("Node does not allow children.");
        }
        this.children_.clear();
    }

    public String toString() {
        return this.getName();
    }

    public abstract Object getObject();

    public abstract String getName();
}

