/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.awt;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.jcodec.common.Codec;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.muxer.MP4Muxer;

public class SequenceMuxer {
    private SeekableByteChannel ch;
    private MuxerTrack outTrack;
    private int frameNo;
    private MP4Muxer muxer;
    private Size size;

    public SequenceMuxer(File out) throws IOException {
        this.ch = NIOUtils.writableChannel((File)out);
        this.muxer = MP4Muxer.createMP4Muxer((SeekableByteChannel)this.ch, (Brand)Brand.MP4);
    }

    public void encodeImage(File png) throws IOException {
        if (this.size == null) {
            BufferedImage read = ImageIO.read(png);
            this.size = new Size(read.getWidth(), read.getHeight());
            this.outTrack = this.muxer.addVideoTrack(Codec.PNG, VideoCodecMeta.createSimpleVideoCodecMeta((Size)this.size, (ColorSpace)ColorSpace.RGB));
        }
        this.outTrack.addFrame((Packet)MP4Packet.createMP4Packet((ByteBuffer)NIOUtils.fetchFromFile((File)png), (long)this.frameNo, (int)25, (long)1L, (long)this.frameNo, (Packet.FrameType)Packet.FrameType.KEY, null, (int)this.frameNo, (long)this.frameNo, (int)0));
        ++this.frameNo;
    }

    public void finish() throws IOException {
        this.muxer.finish();
        NIOUtils.closeQuietly((Closeable)this.ch);
    }
}

