/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.vpx.vp9;

import org.jcodec.codecs.vpx.VPXBooleanDecoder;
import org.jcodec.codecs.vpx.vp9.Consts;
import org.jcodec.codecs.vpx.vp9.DecodingContext;
import org.jcodec.codecs.vpx.vp9.Probabilities;

public class ModeInfo {
    private int segmentId;
    private boolean skip;
    private int txSize;
    private int yMode;
    private int subModes;
    private int uvMode;

    public ModeInfo(int segmentId, boolean skip, int txSize, int yMode, int subModes, int uvMode) {
        this.segmentId = segmentId;
        this.skip = skip;
        this.txSize = txSize;
        this.yMode = yMode;
        this.subModes = subModes;
        this.uvMode = uvMode;
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public int getTxSize() {
        return this.txSize;
    }

    public int getyMode() {
        return this.yMode;
    }

    public int getSubModes() {
        return this.subModes;
    }

    public int getUvMode() {
        return this.uvMode;
    }

    public static ModeInfo read(int miCol, int miRow, int blSz, VPXBooleanDecoder decoder, Probabilities probs, DecodingContext c) {
        int yMode;
        int segmentId = 0;
        if (c.isSegmentationEnabled() && c.isUpdateSegmentMap()) {
            segmentId = ModeInfo.readSegmentId(decoder, probs);
        }
        boolean skip = true;
        if (!c.isSegmentFeatureActive(segmentId, 3)) {
            skip = ModeInfo.readSkipFlag(miCol, miRow, blSz, decoder, probs, c);
        }
        int txSize = ModeInfo.readTxSize(miCol, miRow, blSz, true, decoder, probs, c);
        int subModes = 0;
        if (blSz >= 3) {
            yMode = ModeInfo.readDefaultIntraMode(miCol, miRow, blSz, decoder, probs, c);
        } else {
            subModes = ModeInfo.readDefaultIntraModeSub(miCol, miRow, blSz, decoder, probs, c);
            yMode = subModes & 0xFF;
        }
        int uvMode = ModeInfo.readDefaultUVMode(yMode, decoder, probs, c);
        return new ModeInfo(segmentId, skip, txSize, yMode, subModes, uvMode);
    }

    private static int readDefaultIntraMode(int miCol, int miRow, int blSz, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        int intraMode;
        boolean availAbove = miRow > 0;
        boolean availLeft = miCol > c.getTileStart();
        int[] aboveIntraModes = c.getAboveIntraModes();
        int[] leftIntraModes = c.getLeftIntraModes();
        int aboveMode = availAbove ? aboveIntraModes[miCol] : 0;
        int leftMode = availLeft ? leftIntraModes[miRow % 8] : 0;
        int[][][] probs = probStore.getKfYModeProbs();
        aboveIntraModes[miCol] = intraMode = decoder.readTree(Consts.TREE_INTRA_MODE, probs[aboveMode][leftMode]);
        leftIntraModes[miRow % 8] = intraMode;
        return intraMode;
    }

    private static int readDefaultIntraModeSub(int miCol, int miRow, int blSz, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        boolean availAbove = miRow > 0;
        boolean availLeft = miCol > c.getTileStart();
        int[] aboveIntraModes = c.getAboveIntraModes();
        int[] leftIntraModes = c.getLeftIntraModes();
        int[][][] probs = probStore.getKfYModeProbs();
        int aboveMode = availAbove ? aboveIntraModes[2 * miCol + 1] : 0;
        int leftMode = availLeft ? leftIntraModes[2 * (miRow % 8) + 1] : 0;
        int mode0 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[aboveMode][leftMode]);
        int mode1 = 0;
        int mode2 = 0;
        int mode3 = 0;
        if (blSz == 0) {
            mode1 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[aboveMode][mode0]);
            mode2 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[mode0][leftMode]);
            mode3 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[mode1][mode2]);
            aboveIntraModes[miCol] = mode2;
            leftIntraModes[miRow % 8] = mode1;
            return mode0 << 24 | mode1 << 16 | mode2 << 8 | mode3;
        }
        if (blSz == 1) {
            mode1 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[aboveMode][mode0]);
            aboveIntraModes[miCol] = mode0;
            leftIntraModes[miRow % 8] = mode1;
            return mode0 << 8 | mode1;
        }
        if (blSz == 2) {
            aboveIntraModes[miCol] = mode1 = decoder.readTree(Consts.TREE_INTRA_MODE, probs[mode0][leftMode]);
            leftIntraModes[miRow % 8] = mode0;
            return mode0 << 8 | mode1;
        }
        return 0;
    }

    private static int readDefaultUVMode(int yMode, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        int[][] probs = probStore.getKfUVModeProbs();
        return decoder.readTree(Consts.TREE_INTRA_MODE, probs[yMode]);
    }

    public static int readTxSize(int miCol, int miRow, int blSz, boolean allowSelect, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        int maxTxSize = Consts.maxTxLookup[blSz];
        int txSize = Math.min(maxTxSize, c.getTxMode());
        int[][] txSizes = c.getTxSizes();
        boolean[][] skipped = c.getSkippedBlockes();
        if (allowSelect && c.getTxMode() == 4 && blSz >= 3) {
            boolean availAbove = miRow > 0;
            boolean availLeft = miCol > c.getTileStart();
            int above = maxTxSize;
            int left = maxTxSize;
            if (availAbove && !skipped[miRow - 1][miCol]) {
                above = txSizes[miRow - 1][miCol];
            }
            if (availLeft && !skipped[miRow][miCol - 1]) {
                left = txSizes[miRow][miCol - 1];
            }
            if (!availLeft) {
                left = above;
            }
            if (!availAbove) {
                above = left;
            }
            int ctx = above + left > maxTxSize ? 1 : 0;
            int[][][] probs = probStore.getTxProbs();
            txSize = decoder.readTree(Consts.TREE_TX_SIZE[maxTxSize], probs[maxTxSize][ctx]);
        }
        for (int i = 0; i < Consts.blH[blSz]; ++i) {
            for (int j = 0; j < Consts.blW[blSz]; ++j) {
                txSizes[i + miRow][j + miCol] = txSize;
            }
        }
        return 0;
    }

    public static int readSegmentId(VPXBooleanDecoder decoder, Probabilities probStore) {
        int[] probs = probStore.getSegmentationTreeProbs();
        return decoder.readTree(Consts.TREE_SEGMENT_ID, probs);
    }

    public static boolean readSkipFlag(int miCol, int miRow, int blSz, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        int[] probs;
        int ctx = 0;
        boolean availAbove = miRow > 0;
        boolean availLeft = miCol > c.getTileStart();
        boolean[][] skipped = c.getSkippedBlockes();
        if (availAbove) {
            ctx += skipped[miRow - 1][miCol] ? 1 : 0;
        }
        if (availLeft) {
            ctx += skipped[miRow][miCol - 1] ? 1 : 0;
        }
        boolean ret = decoder.readBit((probs = probStore.getSkipProbs())[ctx]) == 1;
        for (int i = 0; i < Consts.blH[blSz]; ++i) {
            for (int j = 0; j < Consts.blW[blSz]; ++j) {
                skipped[i + miRow][j + miCol] = ret;
            }
        }
        return ret;
    }

    public boolean isInter() {
        return false;
    }
}

