/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced2D;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import java.awt.Dimension;

public class NcGridderLonLatReduced2D
extends NcGridderLonLat {
    public NcGridderLonLatReduced2D() {
        this(100, 50);
    }

    public NcGridderLonLatReduced2D(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatReduced2D(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatReduced2D nca = (NcArrayLonLatReduced2D)a;
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        boolean hasBad = nca.hasBadValues();
        for (int i = 0; i < numXs; ++i) {
            for (int j = 0; j < numYs; ++j) {
                double[][] corners;
                double value = nca.valueAt(i, j);
                if (hasBad && nca.isMissingOrInvalid(value) || (corners = nca.cornerLonLats(i, j)) == null) continue;
                double lon1 = corners[0][0];
                double lon2 = corners[1][0];
                double lon3 = corners[2][0];
                double lon4 = corners[3][0];
                double lat1 = corners[0][1];
                double lat2 = corners[1][1];
                double lat3 = corners[2][1];
                double lat4 = corners[3][1];
                this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatReduced2D nca = (NcArrayLonLatReduced2D)a;
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        boolean hasBad = nca.hasBadValues();
        boolean wrapsOnX = this.doesGridWrap(nca, true);
        boolean wrapsOnY = this.doesGridWrap(nca, false);
        int lastX = wrapsOnX ? numXs : numXs - 1;
        int lastY = wrapsOnY ? numYs : numYs - 1;
        for (int i = 0; i < lastX; ++i) {
            int ip1 = i < numXs - 1 ? i + 1 : 0;
            for (int j = 0; j < lastY; ++j) {
                double lon2;
                int jp1 = j < numYs - 1 ? j + 1 : 0;
                double lat1 = nca.latitudeAt(i, j);
                double lat2 = nca.latitudeAt(ip1, j);
                double lat3 = nca.latitudeAt(ip1, jp1);
                double lat4 = nca.latitudeAt(i, jp1);
                double lon1 = nca.longitudeAt(i, j);
                double lon3 = nca.longitudeAt(ip1, jp1);
                double lon4 = nca.longitudeAt(i, jp1);
                for (lon2 = nca.longitudeAt(ip1, j); lon1 - 90.0 > lon2; lon2 += 360.0) {
                }
                while (lon1 - 90.0 > lon3) {
                    lon3 += 360.0;
                }
                while (lon1 - 90.0 > lon4) {
                    lon4 += 360.0;
                }
                while (lon2 - 90.0 > lon1) {
                    lon2 -= 360.0;
                }
                while (lon3 - 90.0 > lon1) {
                    lon3 -= 360.0;
                }
                while (lon4 - 90.0 > lon1) {
                    lon4 -= 360.0;
                }
                double value1 = nca.valueAt(i, j);
                double value2 = nca.valueAt(ip1, j);
                double value3 = nca.valueAt(ip1, jp1);
                double value4 = nca.valueAt(i, jp1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(value1)) {
                        value1 = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(value2)) {
                        value2 = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(value3)) {
                        value3 = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(value4)) {
                        value4 = Double.NaN;
                    }
                }
                if (!nca.doCellsShareCorner(i, j, ip1, j)) {
                    value2 = Double.NaN;
                }
                if (!nca.doCellsShareCorner(i, j, ip1, jp1)) {
                    value3 = Double.NaN;
                }
                if (!nca.doCellsShareCorner(i, j, i, jp1)) {
                    value4 = Double.NaN;
                }
                if (Double.isNaN(value2) && Double.isNaN(value3) || Double.isNaN(value3) && Double.isNaN(value4)) continue;
                this.quadInterpolateFillLL(lon1, lat1, value1, lon2, lat2, value2, lon3, lat3, value3, lon4, lat4, value4, target);
            }
        }
    }

    private boolean doesGridWrap(NcArrayLonLatReduced2D nca, boolean onX) {
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        if (onX) {
            for (int j = 0; j < lastY; ++j) {
                boolean abutting = nca.doCellsAbut(lastX, j, 0, j);
                if (abutting) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < lastX; ++i) {
            boolean abutting = nca.doCellsAbut(i, lastY, i, 0);
            if (abutting) continue;
            return false;
        }
        return true;
    }
}

