/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatProjected;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatRotatedPole
extends NcGridderLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void constrainIntermediateGridBounds(NcArrayLonLatProjected nca) {
        super.constrainIntermediateGridBounds(nca);
        if (this.rProjBound_ <= this.lProjBound_) {
            this.rProjBound_ += 360.0;
        }
    }

    @Override
    protected void transformProjectedGrid(NcArrayLonLatProjected anca, double[] fromArray, double[] toArray) {
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rowLat = this.tBound_ + ((double)row + 0.5) * this.yDegPerPxl_;
            for (int col = 0; col < this.gridWidth_; ++col) {
                double colLon = this.lBound_ + ((double)col + 0.5) * this.xDegPerPxl_;
                Point2D.Double fromXY = anca.transformLL2XY(colLon, rowLat);
                if (fromXY == null) continue;
                double dlonProj0 = fromXY.x - this.lProjBound_;
                double dlonProj = dlonProj0;
                if (dlonProj < 0.0) {
                    dlonProj += 360.0;
                } else if (dlonProj > 360.0) {
                    dlonProj -= 360.0;
                }
                double altCol = dlonProj * this.xPxlPerProj_ + 0.5;
                double altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5;
                if (altCol < 0.0 || altCol >= (double)this.iigridWidth_ || altRow < 0.0 || altRow >= (double)this.iigridHeight_) continue;
                int fromIndex = (int)altRow * this.iigridWidth_ + (int)altCol;
                int toIndex = row * this.gridWidth_ + col;
                toArray[toIndex] = fromArray[fromIndex];
            }
        }
    }
}

