/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.NatCubic;

public class NatCubicClosed
extends NatCubic {
    NatCubic.Cubic[] calcNaturalCubic(int n, int[] x) {
        int k;
        float[] w = new float[n + 1];
        float[] v = new float[n + 1];
        float[] y = new float[n + 1];
        float[] D = new float[n + 1];
        float z = 0.25f;
        v[1] = 0.25f;
        w[1] = 0.25f;
        y[0] = z * 3.0f * (float)(x[1] - x[n]);
        float H = 4.0f;
        float F = 3 * (x[0] - x[n - 1]);
        float G = 1.0f;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0f / (4.0f - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * ((float)(3 * (x[k + 1] - x[k - 1])) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0f) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0f) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        NatCubic.Cubic[] C = new NatCubic.Cubic[n + 1];
        for (int k2 = 0; k2 < n; ++k2) {
            C[k2] = new NatCubic.Cubic(x[k2], D[k2], (float)(3 * (x[k2 + 1] - x[k2])) - 2.0f * D[k2] - D[k2 + 1], (float)(2 * (x[k2] - x[k2 + 1])) + D[k2] + D[k2 + 1]);
        }
        C[n] = new NatCubic.Cubic(x[n], D[n], (float)(3 * (x[0] - x[n])) - 2.0f * D[n] - D[0], (float)(2 * (x[n] - x[0])) + D[n] + D[0]);
        return C;
    }
}

