/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Hoelzel
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "H\u00f6lzel";
    private static final double CONST_A = 0.322673;
    private static final double CONST_B = 0.369722;
    private static final double CONST_C = 0.40928;
    private static final double CONST_D = 1.161517;
    private static final double CONST_E = 1.0 / Math.sqrt(5.141592653589793);
    private static final double EIGHTY_DEG_RAD = 1.3962634015954636;
    private static final double MAX_X_OVER_RS = 2.0 * CONST_E * Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public Hoelzel(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hoelzel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absLat = Math.abs(lat);
        double phiRad = Math.toRadians(lat);
        double x = this.lonToLambdaRad(lon);
        if (absLat > 80.0) {
            double a = Math.max(0.0, (Math.abs(phiRad) - 0.40928) / 1.161517);
            x *= 0.322673 + 0.369722 * Math.sqrt(1.0 - a * a);
        } else {
            x *= CONST_E * (1.0 + Math.cos(phiRad));
        }
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absy > this.ymRS_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = absYOverRS;
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        if (phiRad > 1.3962634015954636) {
            double a = (phiRad - 0.40928) / 1.161517;
            xFactor = 1.0 / (0.322673 + 0.369722 * Math.sqrt(1.0 - a * a));
        } else {
            xFactor = 1.0 / (CONST_E * (1.0 + Math.cos(phiRad)));
        }
        double lambdaRad = absXOverRS * xFactor;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hoelzel hoelzel = this;
        synchronized (hoelzel) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                if (phiRad > 1.3962634015954636) {
                    double a = (phiRad - 0.40928) / 1.161517;
                    xFactor = this.invRS_ / (0.322673 + 0.369722 * Math.sqrt(1.0 - a * a));
                } else {
                    xFactor = this.invRS_ / (CONST_E * (1.0 + Math.cos(phiRad)));
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

