/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner7RC
extends ConcavePoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner VII RC";
    public static final int PROPERTIES = 270368;
    private static final double ECKERT_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double INV_ECKERT_A = 1.0 / ECKERT_A;
    private static final double PI_ECKERT_A = Math.PI * ECKERT_A;
    private static final double INV_PI_ECKERT_A = 1.0 / PI_ECKERT_A;
    private static final double PI_ECKERT_A2_OVER_2 = 1.5707963267948966 * ECKERT_A * ECKERT_A;
    private static final double TWO_PLUS_PI_OVER_2 = 3.5707963267948966;
    private static final double WAGNER_M = 0.9063077870366499;
    private static final double WAGNER_N = 0.3333333333333333;
    private static final double WAGNER_CX = 5.334466902926652;
    private static final double WAGNER_CY = 2.482072767249852;
    private static final double INV_WAGNER_N = 3.0;
    private static final double INV_WAGNER_CX = 0.18746015641251226;
    private static final double INV_WAGNER_CY = 0.4028890744843087;
    private static final double MAX_X_OVER_RS = 2.3457503152736896;
    private static final double MAX_Y_OVER_RS = 1.234355634040439;

    public Wagner7RC(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner7RC(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 270368, width, height, xmargin, ymargin, 2.3457503152736896, 1.234355634040439);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double xy1 = this.eckertLL2XY(this.lonToLambda(lon), lat);
        xy1.x /= 1.15;
        xy1.y /= 1.15;
        Point2D.Double llERad = this.eckertXY2LLRad(xy1.x, xy1.y);
        Point2D.Double xy = this.wagnerLLRad2XY(llERad.x, llERad.y);
        double x = (double)this.outCenterX_ + xy.x * this.rS_;
        double y = (double)this.outCenterY_ - xy.y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        PointLL llW = this.wagnerXY2LL(absx * this.invRS_, absy * this.invRS_);
        if (llW == null) {
            return null;
        }
        Point2D.Double xyE = this.eckertLL2XY(llW.getLon(), llW.getLat());
        xyE.x *= 1.15;
        xyE.y *= 1.15;
        if (xyE.y > PI_ECKERT_A) {
            return null;
        }
        Point2D.Double llRad = this.eckertXY2LLRad(xyE.x, xyE.y);
        if (llRad == null || llRad.x > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            llRad.x = -llRad.x;
        }
        if (y < 0.0) {
            llRad.y = -llRad.y;
        }
        double lambda = Math.toDegrees(llRad.x);
        double phi = Math.toDegrees(llRad.y);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner7RC wagner7RC = this;
        synchronized (wagner7RC) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                PointLL llW;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && (llW = this.wagnerXY2LL(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    Point2D.Double xyE = this.eckertLL2XY(llW.getLon(), llW.getLat());
                    xyE.x *= 1.15;
                    xyE.y *= 1.15;
                    if (xyE.y > PI_ECKERT_A) continue;
                    Point2D.Double llRad = this.eckertXY2LLRad(xyE.x, xyE.y);
                    if (llRad == null || llRad.x > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(llRad.x), Math.toDegrees(llRad.y));
                }
            }
        }
    }

    private final Point2D.Double eckertLL2XY(double lambda, double lat) {
        double phiRad = Math.toRadians(lat);
        double phiFactor = 3.5707963267948966 * Math.sin(phiRad);
        double lambdaRad = Math.toRadians(lambda);
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta * (2.0 + cosTheta) - phiFactor;
            double dfunc = 2.0 * cosTheta * (1.0 + cosTheta);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x1 = ECKERT_A * lambdaRad * (1.0 + Math.cos(thetaRad));
        double y1 = PI_ECKERT_A * Math.sin(thetaRad);
        return new Point2D.Double(x1, y1);
    }

    private Point2D.Double eckertXY2LLRad(double x1, double y1) {
        double thetaRad = Math.asin(y1 * INV_PI_ECKERT_A);
        double sinTheta = Math.sin(thetaRad);
        double cosTheta = Math.cos(thetaRad);
        double phiERad = Math.asin((thetaRad + sinTheta * (2.0 + cosTheta)) * PI_ECKERT_A2_OVER_2);
        double lambdaERad = x1 * INV_ECKERT_A / (1.0 + cosTheta);
        return new Point2D.Double(lambdaERad, phiERad);
    }

    private Point2D.Double wagnerLLRad2XY(double lambdaRad, double phiRad) {
        double y;
        double x;
        double absPhiRad = Math.abs(phiRad);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad < 1.0E-10) {
            double cosPsi;
            double sinPsi = 0.9063077870366499 * Math.sin(absPhiRad);
            double cosDelta = cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
            double deltaRad = Math.acos(cosDelta);
            double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
            x = 0.0;
            y = 2.482072767249852 * sinDeltaOver2;
        } else if (absPhiRad < 1.0E-10) {
            double cosNLambda;
            double nLambdaRad = 0.3333333333333333 * absLambdaRad;
            double cosDelta = cosNLambda = Math.cos(nLambdaRad);
            double deltaRad = Math.acos(cosDelta);
            double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
            x = 5.334466902926652 * sinDeltaOver2;
            y = 0.0;
        } else {
            double nLambdaRad = 0.3333333333333333 * absLambdaRad;
            double cosNLambda = Math.cos(nLambdaRad);
            double sinPsi = 0.9063077870366499 * Math.sin(absPhiRad);
            double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
            double cosDelta = cosNLambda * cosPsi;
            double sinDelta = Math.sqrt(1.0 - cosDelta * cosDelta);
            double deltaRad = Math.acos(cosDelta);
            double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
            double cosAlpha = sinPsi / sinDelta;
            double sinAlpha = Math.sqrt(1.0 - cosAlpha * cosAlpha);
            x = 5.334466902926652 * sinDeltaOver2 * sinAlpha;
            y = 2.482072767249852 * sinDeltaOver2 * cosAlpha;
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        return new Point2D.Double(x, y);
    }

    private PointLL wagnerXY2LL(double absx, double absy) {
        double xOverCx = absx * 0.18746015641251226;
        double yOverCy = absy * 0.4028890744843087;
        double sinDeltaOver2 = Math.hypot(xOverCx, yOverCy);
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        if (sinDeltaOver2 > 1.0E-5) {
            if (Math.abs(phiRad) > 0.9063077870366499) {
                return null;
            }
            double delta = 2.0 * Math.asin(sinDeltaOver2);
            double sinPsi = yOverCy * Math.sin(delta) / sinDeltaOver2;
            phiRad = Math.asin(sinPsi / 0.9063077870366499);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (phiRad == 1.5707963267948966) {
                lambdaRad = 0.0;
            } else {
                double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
                lambdaRad = 3.0 * Math.acos(Math.cos(delta) / cosPsi);
            }
        }
        if (Double.isNaN(lambdaRad) || Double.isNaN(phiRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(lambda, phi);
    }
}

