/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.dialog.PanCreatePlotDialog;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.task.PanCreatePlotTask;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotSizeFactor;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCreatePlotAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;
    private PanCreatePlotTask creator_;

    public PanCreatePlotAction(PanSourcesFrame f) {
        super(PanProperties.SOURCES_PROPS.getString("create-plot"));
        this.parent_ = f;
    }

    public boolean isBusy() {
        return this.creator_ != null && this.creator_.isBusy();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isBusy()) {
            return;
        }
        this.createPlot(null);
    }

    public void createPlot(PanPlotSizeFactor size) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        if (!ncvar.isGriddable()) {
            LOGGER.warn("Not a plottable variable.");
            return;
        }
        PanCreatePlotDialog dlog = null;
        try {
            dlog = new PanCreatePlotDialog(this.parent_, ncvar);
        }
        catch (Exception exc) {
            LOGGER.trace("Exception creating plot dialog");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            String errMsg = exc.toString().replaceFirst(".*: ", "");
            SlowMessage.show(null, "Dialog Error", new StringBuilder("There was an exception preparing the plot dialog: ").append(errMsg));
            return;
        }
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            return;
        }
        Hashtable<PanCreatePlotOption, Object> opts = dlog.getOptions();
        if (size != null) {
            opts.put(PanCreatePlotOption.SIZE_FACTOR, size);
        }
        this.creator_ = new PanCreatePlotTask(ncvar, opts);
        this.parent_.addTask(this.creator_);
    }
}

