/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.prefs.PanPreferenceUtils;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.EasyXmlParser;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PanExtraPrefsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String stype_;
    private File xprefsFile_;
    private final EventListenerList listeners_;

    protected PanExtraPrefsHandler(String stype) {
        LOGGER.trace("{}", (Object)stype);
        this.stype_ = stype;
        try {
            this.xprefsFile_ = PanPreferenceUtils.findExtraPreferencesFile(stype, 0);
            if (this.xprefsFile_ == null) {
                LOGGER.warn("Got null constructing {} xprefs File object.", (Object)stype);
            } else if (this.xprefsFile_.exists()) {
                this.read();
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to instantiate {} xprefs list.", (Object)stype);
        }
        this.listeners_ = new EventListenerList();
    }

    protected void read() {
        block7: {
            LOGGER.trace("{}", (Object)this.stype_);
            try (FileInputStream is = new FileInputStream(this.xprefsFile_);){
                this.readStream(is);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception reading {} xprefs file: {}", (Object)this.stype_, (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) break block7;
                exc.printStackTrace();
            }
        }
    }

    protected void readStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(istream);
        Element root = document.getRootElement();
        String rootName = root.getName();
        if (!"gissapp".equals(rootName) && !"application".equals(rootName)) {
            LOGGER.warn("Root of {} XML tree is not 'gissapp' or 'application'.", (Object)this.stype_);
            LOGGER.warn("File content will be ignored.");
            LOGGER.warn("File will be overwritten on exit.");
            return;
        }
        try {
            String name = root.getAttribute("name").getValue();
            if (!"Panoply".equalsIgnoreCase(name)) {
                LOGGER.warn("Root of {} file XML tree has wrong 'name' value, {}.", (Object)this.stype_, (Object)name);
                LOGGER.warn("Undesired results will probably occur parsing the file.");
                LOGGER.warn("File will be overwritten on exit.");
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read 'name' attribute in {} XML tree root element.", (Object)this.stype_);
            LOGGER.warn("Undesired results will probably occur parsing the file.");
            LOGGER.warn("File will be overwritten on exit.");
        }
        try {
            String ftype = root.getAttribute("type").getValue();
            if (!this.stype_.equalsIgnoreCase(ftype)) {
                LOGGER.warn("Root of {} file XML tree has wrong 'type' value, {}.", (Object)this.stype_, (Object)ftype);
                LOGGER.warn("Undesired results will probably occur parsing the file.");
                LOGGER.warn("File will be overwritten on exit.");
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read 'type' attribute in {} XML tree root element.", (Object)this.stype_);
            LOGGER.warn("Undesired results will probably occur parsing the file.");
            LOGGER.warn("File will be overwritten on exit.");
        }
        for (Element child : root.getChildren()) {
            String childName = child.getName();
            if ("group".equals(childName)) {
                this.readRootChild(child);
                continue;
            }
            LOGGER.warn("Child '{}' of {} root is not 'group'.", (Object)this.stype_, (Object)childName);
        }
    }

    protected abstract void readRootChild(Element var1);

    public void save() {
        boolean success;
        File backup;
        block35: {
            block34: {
                LOGGER.trace("{}", (Object)this.stype_);
                if (this.xprefsFile_ == null) {
                    LOGGER.warn("No {} File object exists; xprefs file will not be saved.", (Object)this.stype_);
                    return;
                }
                backup = null;
                try {
                    String bkpName = this.xprefsFile_.toString() + "_bkp";
                    backup = new File(bkpName);
                }
                catch (Exception exc) {
                    backup = null;
                }
                if (this.xprefsFile_.exists() && backup != null) {
                    try (FileInputStream fis = new FileInputStream(this.xprefsFile_);
                         FileOutputStream fos = new FileOutputStream(backup);
                         FileChannel inputChannel = fis.getChannel();
                         FileChannel outputChannel = fos.getChannel();){
                        outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Exception saving {} backup: {}", (Object)this.stype_, (Object)exc.toString());
                        if (!LOGGER.isTraceEnabled()) break block34;
                        exc.printStackTrace();
                    }
                }
            }
            success = false;
            try {
                this.save(this.xprefsFile_);
                success = true;
            }
            catch (Exception exc) {
                LOGGER.warn("Exception saving {}: {}", (Object)this.stype_, (Object)exc);
                if (!LOGGER.isTraceEnabled()) break block35;
                exc.printStackTrace();
            }
        }
        if (!success && backup != null && backup.exists()) {
            LOGGER.warn("Restoring previous version.");
            try {
                backup.renameTo(this.xprefsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception restoring backup: {}", exc);
            }
        }
        if (backup != null && backup.exists()) {
            backup.delete();
        }
    }

    protected void save(File f) {
        block9: {
            LOGGER.trace("{}, {}", (Object)this.stype_, (Object)f);
            try (FileOutputStream fos = new FileOutputStream(f);){
                this.saveStream(fos);
            }
            catch (Exception exc) {
                if (PlatformUtils.isHeadless()) {
                    LOGGER.warn("Failed to write {} due to exception: {}", (Object)this.stype_, (Object)exc.toString());
                } else {
                    SlowMessage.show(null, "File Error", new StringBuilder("I encountered an error while saving the '").append(this.stype_).append("' xprefs file.\n").append(exc.toString()));
                }
                if (!LOGGER.isDebugEnabled()) break block9;
                exc.printStackTrace();
            }
        }
    }

    protected void saveStream(OutputStream ostream) throws IOException {
        block2: {
            Objects.requireNonNull(ostream, "Null output stream.");
            Element root = new Element("gissapp");
            root.setAttribute("name", "Panoply".toLowerCase());
            root.setAttribute("type", this.stype_);
            root.setAttribute("version", "5.4.2");
            root.setAttribute("locale", Locale.getDefault().toString());
            this.writeRootChiildren(root);
            Document d = new Document(root);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                outputter.output(d, ostream);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    abstract void writeRootChiildren(Element var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.add(ResourceListDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.remove(ResourceListDataListener.class, l);
        }
    }

    protected void fireContentsChanged(Component component) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 0, 0, -1);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.contentsChanged(e);
        }
    }

    protected void fireIntervalAdded(Component component, int index) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 1, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalAdded(e);
        }
    }

    protected void fireIntervalRemoved(Component component, int index) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 2, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalRemoved(e);
        }
    }
}

