/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.prefs.PanExtraPrefsHandler;
import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSavedSettingsHandler
extends PanExtraPrefsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String STYPE = "xsettings";
    private static ArrayList<PanSavedSettings> internalList_;

    public static PanSavedSettingsHandler getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanSavedSettingsHandler() {
        super(STYPE);
        if (internalList_ == null) {
            internalList_ = new ArrayList(50);
        }
    }

    public int getChildCount() {
        return internalList_.size();
    }

    @Override
    protected void readRootChild(Element child) {
        PanSavedSettings pss = new PanSavedSettings(child);
        this.add(pss);
    }

    @Override
    protected void writeRootChiildren(Element rootElem) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            PanSavedSettings group = this.get(i);
            group.write(rootElem);
        }
    }

    public PanSavedSettings get(String name) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            PanSavedSettings pss = this.get(i);
            if (!pss.getName().equals(name)) continue;
            return pss;
        }
        return null;
    }

    public PanSavedSettings get(int index) {
        return internalList_.get(index);
    }

    public void add(String name, PanPlotMeta pmeta) {
        PanSavedSettings pss = new PanSavedSettings(name, pmeta);
        this.add(pss);
    }

    public boolean add(PanSavedSettings element) {
        if (internalList_.add(element)) {
            this.fireIntervalAdded(null, this.getChildCount() - 1);
            return true;
        }
        return false;
    }

    public void add(int index, PanSavedSettings element) {
        internalList_.add(index, element);
        this.fireIntervalAdded(null, index);
    }

    public void clear() {
        internalList_.clear();
        this.fireContentsChanged(null);
    }

    public PanSavedSettings remove(int index) {
        PanSavedSettings element = internalList_.remove(index);
        this.fireIntervalRemoved(null, index);
        return element;
    }

    public boolean remove(PanSavedSettings element) {
        int index = internalList_.indexOf(element);
        if (index < 0) {
            return false;
        }
        internalList_.remove(element);
        this.fireIntervalRemoved(null, index);
        return true;
    }

    public void sortByType() {
        internalList_.sort((o1, o2) -> o1.compareByType((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    public void sortByName() {
        internalList_.sort((o1, o2) -> o1.compareByName((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    public void sortByDate() {
        internalList_.sort((o1, o2) -> o1.compareByDate((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    private static class Singleton {
        private static final PanSavedSettingsHandler INSTANCE = new PanSavedSettingsHandler();

        private Singleton() {
        }
    }
}

