/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox interpolateCB_;
    private boolean refreshing_;

    public PanDataPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Data"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a color-contour plot, set\u2026");
        this.interpolateCB_ = PanCheckBox.create("On");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 2, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add((Component)new JLabel("Interpolation:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.interpolateCB_, new FGConstraint(1, row));
    }

    private void attachListeners() {
        this.interpolateCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:interpolate", this.interpolateCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.interpolateCB_.setSelected(prefs_.getBoolean("plot:interpolate"));
        this.refreshing_ = false;
    }
}

