/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.BoxLayout;

public class PanPlotControlsPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox floatingCB_;
    private PanCheckBox unifiedCB_;
    private boolean refreshing_;

    public PanPlotControlsPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        if (PanUtils.isBeta()) {
            this.floatingCB_ = PanCheckBox.create("Show plot controls as floating palettes (requires restart)");
            this.floatingCB_.setMaximumSize(this.floatingCB_.getPreferredSize());
        }
        this.unifiedCB_ = PanCheckBox.create("Unify plot controls in a single palette (requires restart)");
        this.unifiedCB_.setMaximumSize(this.unifiedCB_.getPreferredSize());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Plot Controls"));
        if (PanUtils.isBeta()) {
            this.add(QuickBox.createLeftBox(this.floatingCB_));
        }
        this.add(QuickBox.createLeftBox(this.unifiedCB_));
        this.refreshPrivate();
    }

    private void attachListeners() {
        if (this.floatingCB_ != null) {
            this.floatingCB_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                PanPlotControlsMeta.setFloating(this.floatingCB_.isSelected());
                this.unifiedCB_.setEnabled(this.floatingCB_.isSelected());
            });
        }
        this.unifiedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            PanPlotControlsMeta.setUnified(this.unifiedCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        if (this.floatingCB_ != null) {
            this.floatingCB_.setSelected(PanPlotControlsMeta.isFloating());
            this.unifiedCB_.setEnabled(this.floatingCB_.isSelected());
        }
        this.unifiedCB_.setSelected(PanPlotControlsMeta.isUnified());
        this.refreshing_ = false;
    }
}

