/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class PanSaveFilePrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox imageDialogAlwaysCB_;
    private PanCheckBox pspdfVectorizedCB_;
    private PanCheckBox exportCsvWarningCB_;
    private PanCheckBox exportTextWarningCB_;
    private DescribedEnumComboBox pspdfPaperSizeCombo_;
    private boolean refreshing_;

    public PanSaveFilePrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.imageDialogAlwaysCB_ = PanCheckBox.create("Always show file dialog when saving plot graphics");
        this.pspdfVectorizedCB_ = PanCheckBox.create("Save PS, PDF and SVG plot graphics fully vectorized");
        this.pspdfPaperSizeCombo_ = new DescribedEnumComboBox(PaperSize.class);
        this.exportCsvWarningCB_ = PanCheckBox.create("Show large-file warning when exporting data as CSV");
        this.exportTextWarningCB_ = PanCheckBox.create("Show large-file warning when exporting data as text");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Save"));
        this.add(QuickBox.createLeftBox(this.imageDialogAlwaysCB_));
        this.add(QuickBox.createLeftBox(this.pspdfVectorizedCB_));
        this.add(QuickBox.createLeftBox(new JLabel("       Output paper size for PS/PDF graphics:\u2009"), this.pspdfPaperSizeCombo_));
        this.add(QuickBox.createLeftBox(this.exportCsvWarningCB_));
        this.add(QuickBox.createLeftBox(this.exportTextWarningCB_));
    }

    private void attachListeners() {
        this.imageDialogAlwaysCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:save.image.dialog", this.imageDialogAlwaysCB_.isSelected());
        });
        this.pspdfVectorizedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:save.pspdf.vectorized", this.pspdfVectorizedCB_.isSelected());
        });
        this.pspdfPaperSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PaperSize selected = (PaperSize)this.pspdfPaperSizeCombo_.getSelectedItem();
            prefs_.set("files:save.pspdf.paper", selected.name());
        });
        this.exportCsvWarningCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("warn:export.csv", this.exportCsvWarningCB_.isSelected());
        });
        this.exportTextWarningCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("warn:export.text", this.exportTextWarningCB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.imageDialogAlwaysCB_.setSelected(prefs_.getBoolean("files:save.image.dialog"));
        this.pspdfVectorizedCB_.setSelected(prefs_.getBoolean("files:save.pspdf.vectorized"));
        this.pspdfPaperSizeCombo_.setSelItemMatching(prefs_.getString("files:save.pspdf.paper"));
        this.exportCsvWarningCB_.setSelected(prefs_.getBoolean("warn:export.csv"));
        this.exportTextWarningCB_.setSelected(prefs_.getBoolean("warn:export.text"));
        this.refreshing_ = false;
    }
}

