/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class WindowDragger
extends MouseInputAdapter {
    private final JComponent component_;
    private boolean dragInProgress_;
    private Point windowPoint_;
    private Point mousePoint_;

    public WindowDragger(JComponent jc) {
        this.component_ = jc;
    }

    private void moveWindow(Point p) {
        if (!this.dragInProgress_) {
            return;
        }
        int dx = p.x - this.mousePoint_.x;
        int dy = p.y - this.mousePoint_.y;
        this.windowPoint_.translate(dx, dy);
        Window parent = SwingUtilities.getWindowAncestor(this.component_);
        if (parent == null) {
            return;
        }
        parent.setLocation(this.windowPoint_);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveWindow(e.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Window parent = SwingUtilities.getWindowAncestor(this.component_);
        if (parent == null) {
            return;
        }
        this.dragInProgress_ = true;
        this.windowPoint_ = parent.getLocation();
        this.mousePoint_ = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveWindow(e.getPoint());
        this.dragInProgress_ = false;
    }
}

