/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.ui.plaf.GissComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.lang.invoke.MethodHandles;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTableComboBoxRenderer
extends GissComboBoxRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SAMPLE_WIDTH = 48;
    private AbstractColorTable ctable_;

    public void setColorTable(AbstractColorTable act) {
        this.ctable_ = act;
        this.text_ = this.ctable_ == null ? " " : this.ctable_.toString();
        this.measured_ = false;
        this.repaint();
    }

    @Override
    public void setOffset(boolean b) {
        LOGGER.trace("setOffset {}", (Object)b);
        this.isOffset_ = b;
        this.measured_ = false;
        this.repaint();
    }

    @Override
    protected void paintContent(Graphics2D g2d, int xOffset) {
        LOGGER.trace("xOffset {}", (Object)xOffset);
        int x = xOffset;
        Dimension size = this.getSize();
        Color fgcolor = this.getForeground();
        Color bgcolor = this.getBackground();
        if (this.ctable_ != null) {
            int colorCount = this.ctable_.getColorCount();
            float binWidth = 48.0f / (float)colorCount;
            int barHeight = this.getFont().getSize() - 2;
            int barTop = (size.height - barHeight) / 2;
            g2d.setColor(fgcolor);
            g2d.fillRect(xOffset - 1, barTop - 1, 50, barHeight + 2);
            for (int i = 0; i < colorCount; ++i) {
                Color c2;
                float binOffset = binWidth * (float)i;
                float binLeft = (float)xOffset + binOffset;
                Color c1 = this.ctable_.getColorAt(i);
                int cbins = 1;
                for (int j = i + 1; j < colorCount && (c2 = this.ctable_.getColorAt(j)).equals(c1); ++j) {
                    ++cbins;
                }
                float colorWidth = binWidth * (float)cbins;
                i += cbins - 1;
                if (binOffset + (colorWidth += 0.5f) > 48.0f) {
                    colorWidth = 48.0f - binOffset;
                }
                if (this.isEnabled()) {
                    g2d.setColor(c1);
                } else {
                    g2d.setColor(new Color((c1.getRed() + 9 * bgcolor.getRed()) / 10, (c1.getGreen() + 9 * bgcolor.getGreen()) / 10, (c1.getBlue() + 9 * bgcolor.getBlue()) / 10));
                }
                GraphicUtils.fillRect(g2d, binLeft, barTop, colorWidth, barHeight);
            }
            x += 54;
        }
        g2d.setColor(fgcolor);
        g2d.drawString(this.text_, x, (size.height - this.lineHeight_) / 2 + this.lineAscent_);
    }

    @Override
    protected synchronized void measure() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        this.prefWidth_ = this.ctable_ == null ? 54 + fm.stringWidth(this.text_) : 54 + fm.stringWidth(this.text_);
        this.prefHeight_ = this.lineHeight_ + 2;
        if (this.isOffset_) {
            this.prefWidth_ += 2 + iconWidth_ + 6;
        }
        this.measured_ = true;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null || value.toString().isEmpty()) {
            this.isSelected_ = false;
            this.hasFocus_ = false;
            return new JSeparator();
        }
        this.isSelected_ = isSelected && index > -1;
        this.hasFocus_ = cellHasFocus;
        if (cellHasFocus) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof AbstractColorTable) {
            this.setColorTable((AbstractColorTable)value);
        } else {
            this.setColorTable(null);
            this.setText(value.toString());
        }
        return this;
    }
}

