/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.ColorTableEvent;
import gov.nasa.giss.graphics.clut.ColorTableListener;
import gov.nasa.giss.graphics.clut.ColorTableOutlierShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ColorTablePreviewPanel
extends JComponent
implements ColorTableListener {
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private AbstractColorTable ctable_;
    private ColorTableOutlierShape outlierShape_ = ColorTableOutlierShape.TRIANGLE;

    public ColorTablePreviewPanel(AbstractColorTable act) {
        this.ctable_ = act;
        this.ctable_.addColorTableListener(this);
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        this.setPreferredSize(new Dimension(128, 32));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(new Dimension(2000, 32));
    }

    public void setColorTable(AbstractColorTable colortable) {
        if (this.ctable_ != null) {
            this.ctable_.removeColorTableListener(this);
        }
        this.ctable_ = colortable;
        this.ctable_.addColorTableListener(this);
        this.invalidate();
        this.repaint();
    }

    public void setOutlierShape(ColorTableOutlierShape shape) {
        this.outlierShape_ = shape;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        float outlierWidth;
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        super.paintComponent(g2d);
        Insets ins = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = h - ins.top - ins.bottom;
        float barHeight = hh - 8;
        float outlierGap = barHeight / 2.0f;
        switch (this.outlierShape_) {
            case RECTANGLE: {
                outlierWidth = 0.5f * barHeight;
                break;
            }
            case TRIANGLE_2: {
                outlierWidth = 2.0f * barHeight;
                break;
            }
            case TRIANGLE_3: {
                outlierWidth = 3.0f * barHeight;
                break;
            }
            default: {
                outlierWidth = barHeight;
            }
        }
        float barWidth = 250.0f;
        float barLeft = (float)Math.floor(0.5f * ((float)w - 250.0f));
        float barRight = barLeft + 250.0f;
        int barTop = ins.top + 4;
        int colorCount = this.ctable_.getColorCount();
        float binWidth = 250.0f / (float)colorCount;
        g2d.setColor(this.getForeground());
        g2d.fillRect((int)barLeft - 1, barTop - 1, 252, (int)barHeight + 2);
        for (int i = 0; i < colorCount; ++i) {
            Color c2;
            float binOffset = binWidth * (float)i;
            float binLeft = barLeft + binWidth * (float)i;
            Color c1 = this.ctable_.getColorAt(i);
            int iwidth = 1;
            for (int j = i + 1; j < colorCount && (c2 = this.ctable_.getColorAt(j)).equals(c1); ++j) {
                ++iwidth;
            }
            float colorWidth = binWidth * (float)iwidth;
            i += iwidth - 1;
            if (binOffset + (colorWidth += 0.25f) > 250.0f) {
                colorWidth = 250.0f - binOffset;
            }
            g2d.setColor(this.ctable_.getColorAt(i));
            GraphicUtils.fillRect(g2d, binLeft, barTop, colorWidth, barHeight);
        }
        GeneralPath path = new GeneralPath();
        switch (this.outlierShape_) {
            case TRIANGLE_2: 
            case TRIANGLE_3: 
            case TRIANGLE: {
                path.reset();
                path.moveTo(barLeft - outlierGap, barTop);
                path.lineTo(barLeft - outlierGap, (float)barTop + barHeight);
                path.lineTo(barLeft - outlierGap - outlierWidth, (float)barTop + barHeight / 2.0f);
                path.lineTo(barLeft - outlierGap, barTop);
                path.closePath();
                g2d.setColor(this.ctable_.getMinOutlierColor(false));
                g2d.fill(path);
                g2d.setColor(this.getForeground());
                g2d.draw(path);
                path.reset();
                path.moveTo(barRight + outlierGap, barTop);
                path.lineTo(barRight + outlierGap, (float)barTop + barHeight);
                path.lineTo(barRight + outlierGap + outlierWidth, (float)barTop + barHeight / 2.0f);
                path.lineTo(barRight + outlierGap, barTop);
                path.closePath();
                g2d.setColor(this.ctable_.getMaxOutlierColor(false));
                g2d.fill(path);
                g2d.setColor(this.getForeground());
                g2d.draw(path);
                break;
            }
            case RECTANGLE: {
                g2d.setColor(this.ctable_.getMinOutlierColor());
                GraphicUtils.fillRect(g2d, barLeft - outlierGap - outlierWidth, barTop, outlierWidth, barHeight);
                g2d.setColor(this.getForeground());
                GraphicUtils.drawRect(g2d, barLeft - outlierGap - outlierWidth, barTop, outlierWidth, barHeight);
                g2d.setColor(this.ctable_.getMaxOutlierColor());
                GraphicUtils.fillRect(g2d, barRight + outlierGap, barTop, outlierWidth, barHeight);
                g2d.setColor(this.getForeground());
                GraphicUtils.drawRect(g2d, barRight + outlierGap, barTop, outlierWidth, barHeight);
                break;
            }
        }
        g2d.dispose();
    }

    @Override
    public void colorTableChanged(ColorTableEvent e) {
        this.repaint();
    }
}

